package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.util.ActivityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Order(100)
@Service("taskEngineDispatchActionExecutor")
class TaskEngineDispatchActionExecutor extends MergeDataActionExecutor {
    public static final String DISPATCH_ACTION_ID = "dispatch";

    @Autowired
    private CommonPtmService taskEngineService;

    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT + DISPATCH_ACTION_ID;
    }
    @Override
    public boolean supportRetry() {
        return true;
    }
    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        execute(action, parameter);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        //为了不串对象，先将action深拷贝出来，取数据从action，做添加从cloneAction
        ObjectMapper objectMapper = new ObjectMapper();
        SubmitAction cloneAction = null;
        try {
            cloneAction = objectMapper.readValue(objectMapper.writeValueAsString(action), SubmitAction.class);
            cloneAction.setMergeDataAction(action.getMergeDataAction());
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        //从当前的action里面提出来之前已经merge好的action
        SubmitAction mergeAction = action;
        if (action != action.getMergeDataAction()) {
            mergeAction = action.getMergeDataAction();
        }
        //需要合并dispatch的action
        List<SubmitAction> combineActions = new ArrayList<>();
        if (mergeAction.getExtendParas() != null && mergeAction.getExtendParas().containsKey(UiBotConstants.MERGED_SUBMIT_DATA)) {
            combineActions = (List<SubmitAction>) mergeAction.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
            combineActions.add(cloneAction);
        } else {
            //第一个 action
            combineActions.add(cloneAction);
            if (mergeAction.getExtendParas() == null) {
                mergeAction.setExtendParas(new HashMap<>());
            }
            mergeAction.getExtendParas().put(UiBotConstants.MERGED_SUBMIT_DATA, combineActions);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(false);
        return result;
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        ExecuteResult result = ExecuteResult.ok();
        List<SubmitAction> combineActions = (List<SubmitAction>) action.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
        if (CollectionUtils.isEmpty(combineActions)) {
            log.info("[executeMergedData] combine actions is empty ,action is {}", action);
            return result;
        }
        for (SubmitAction submitAction : combineActions) {
            execute(submitAction, parameter);
        }
        result.setCompleted(true);
        return result;
    }

    private void execute(SubmitAction action, Map<String, Object> parameter) {
        //合并的任务，直接用准备好的参数执行
        setProcessVariables(action, parameter);
        if (parameter.size() > 0) {
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                //暂时强行获取第一个集合吧，如果提交多个集合，肯定
                if (!stringObjectEntry.getKey().startsWith("uibot")) {
                    if (stringObjectEntry.getValue() instanceof Collection) {
                        action.getParas().put("dispatchData", stringObjectEntry.getValue());
                        break;
                    } else {
                        List dispatchData = new ArrayList();
                        dispatchData.add(stringObjectEntry);
                        action.getParas().put("dispatchData", dispatchData);
                        break;
                    }
                }
            }

        }
        taskEngineService.execute(action);
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext.isMinSplit()){
            SubmitAction action = actionExecuteReq.getAction();
            Map<String, Object> paras = action.getParas();
            paras.put("workItemDataIdList", ActivityUtils.getMinSplitWorkItemIds(actionExecuteReq));
            ActionServiceId serviceId = action.getServiceId();
            if(serviceId != null){
                serviceId.setServiceUri("api/task/card/min/split/dispatch");
            }
            taskEngineService.execute(action);
            ExecuteResult result = ExecuteResult.ok();
            result.setCompleted(true);
            return result;
        }
        return super.execute(actionExecuteReq);
    }
}
