package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 任务引擎-提交数据
 */
@Order(100)
@Slf4j
@Service("taskEngineSubmitDataActionExecutor")
class TaskEngineSubmitDataActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonTaskEngineService commonTaskEngineService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT+ "submit-data" ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {

        setProcessVariables(action,parameter);
        if(parameter.size() >0) {
            //优先取list，没有就取第一个放进list，如果还不符合条件，就没救了
            List dispatchData = new ArrayList();
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (!stringObjectEntry.getKey().startsWith("uibot") || !stringObjectEntry.getKey().equals("return_request_data")){
                    if(stringObjectEntry.getValue() instanceof Collection){
                        dispatchData = (List)stringObjectEntry.getValue();
                        action.getParas().put("dispatchData",stringObjectEntry.getValue());
                        break;
                    }
                }
            }
            if(CollectionUtils.isEmpty(dispatchData)){
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    if (!stringObjectEntry.getKey().startsWith("uibot") || !stringObjectEntry.getKey().equals("return_request_data")){
                        dispatchData.add(stringObjectEntry);
                        break;
                    }
                }
            }
            action.getParas().put("dispatchData",dispatchData);
        }

        log.error("[submit-data] {}", action);

        //dispatchData如果为空数组，就不执行
        boolean executed = true;
        if(action.getParas().containsKey("dispatchData")){
            Object dd = action.getParas().get("dispatchData");
            /*if(dd!=null && dd instanceof List){
                List dispatchData = (List)dd;
                executed = dispatchData != null && dispatchData.size() > 0;
            }else if(dd!=null && dd instanceof Map){
                List dispatchData = new ArrayList();
                dispatchData.add(dd);
                executed = dispatchData != null && dispatchData.size() > 0;
            }*/
            if(dd!=null){
                if(dd instanceof List){
                    List dispatchData = (List)dd;
                    executed = dispatchData.size() > 0;
                }else{
                    List dispatchData = new ArrayList();
                    dispatchData.add(dd);
                    executed = dispatchData.size() > 0;
                }
            }
        }
        if(executed) {
            commonTaskEngineService.execute(action);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(false);
        return result;
    }
}
