package com.digiwin.athena.atdm.action.executor;


import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 更新任务签核状态
 */
@Service(ActionConstants.ACTION_NAME_UPDATE_SOLVE_TASK_APPROVAL_STATE)
public class UpdateSolveApprovalStateExecutor implements ActionExecutor {


    @Autowired
    CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT +ActionConstants.SPLIT+ ActionConstants.ACTION_NAME_UPDATE_SOLVE_TASK_APPROVAL_STATE;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {


        Long backlogId = Long.parseLong(executeContext.getBpmData().get("originalBacklogId").toString());
        String approvalState = action.getExtendParas().get("approvalState").toString();

        Map<String,Object> paras = new HashMap<>();
        paras.put("backlogId", backlogId);
        paras.put("approvalState", approvalState);
        atmcService.updateBacklogApprovalState(paras);

        return  ExecuteResult.ok();
    }
}
