package com.digiwin.athena.atdm.action.subscriber;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.subscriber.event.ApiErrorEvent;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * esp提交后的错误数据
 */
@Component
@Slf4j
public class ApiErrorSubscriber {
    @Autowired
    private ApiErrorInfoService apiErrorInfoService;

    @Subscribe
    public void subscriber(ApiErrorEvent event) {
        try {
            processEvent(event);
        } catch (Exception e) {
            log.error("esp api提交后向运维模组发送错误数据失败：event:{},error:{}", JsonUtils.objectToString(event), e.getMessage());
        }
    }

    /**
     * @param event
     */
    private void processEvent(ApiErrorEvent event) {
        sendErrorInfo(event.getExecuteContext(), event.getAction(), event.getResult(), event.getDataMap());

    }

    /**
     * @param executeContext
     * @param dataMap
     */
    private void sendErrorInfo(SubmitExecuteContext executeContext, SubmitAction action, HashMap result, HashMap dataMap) {
        // 没有错误数据
        if (MapUtils.isEmpty(dataMap) || !dataMap.containsKey("error_info") || null == dataMap.get("error_info")) {
            log.error("EspActionExecutor-sendErrorInfo:error_info is empty");
            return;
        }
        // 没有事项id
        if (null == executeContext || null == executeContext.getPtmData() || null == executeContext.getPtmData().get("ptmWorkItemId")) {
            log.error("EspActionExecutor-sendErrorInfo:ptmWorkItemId is null");
            return;
        }
        //同步/异步调用
        boolean sync = true;
        if (null != result.get("sync")) {
            sync = BooleanUtils.toBoolean(result.get("sync").toString());
        }
        // 同步调用时调用atmc接口向运维模组发送通知
        // 异步调用时记录请求和任务的关联关系，并提供对外接口供esp的callback调用
        if (sync) {
            //错误信息
            List<Object> errorInfos = (List<Object>) dataMap.get("error_info");
            Long ptmBacklogId = (Long) executeContext.getPtmData().get("ptmBacklogId");
            Long ptmWorkItemId = (Long) executeContext.getPtmData().get("ptmWorkItemId");
            String apiName = action.getServiceId().getName();
            apiErrorInfoService.sendApiErrorInfo(errorInfos, ptmBacklogId, ptmWorkItemId, apiName);
        } else {
            Map<String, Object> insertMap = new HashMap<>();
            insertMap.put("ptmBacklogId", executeContext.getPtmData().get("ptmBacklogId"));
            insertMap.put("ptmWorkItemId", executeContext.getPtmData().get("ptmWorkItemId"));
            insertMap.put("apiName", action.getServiceId().getName());
            insertMap.put("reqId", result.get("reqId"));
            apiErrorInfoService.insertRequestWorkItem(executeContext.getTenantId(), insertMap);
        }
    }

}
