package com.digiwin.athena.atdm.log;

import cn.hutool.core.io.resource.ResourceUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;

import java.util.List;

/**
 * @Author wuzq
 * @Date 2023/12/14 15:50
 * @Version 1.0
 */
public class LogRecordUtils {

    public static SubmitAction getSupportRetry(SubmitActionDTO submitAction) {
        if (BooleanUtils.isTrue(submitAction.getAction().getExecuted())
                && submitAction.getAction().getExecuteResult() == null) {
            throw new RuntimeException("报错节点是首个执行action不记录日志");
        }
        return recursiveAttachAction(submitAction.getAction().getAttachActions());
    }

    public static SubmitAction recursiveAttachAction(List<SubmitAction> attachActions) {
        for (SubmitAction submitAction : attachActions) {

            if (BooleanUtils.isTrue(submitAction.getExecuted())
                    && submitAction.getExecuteResult() == null) {
                return submitAction;
            }

            if (CollectionUtils.isNotEmpty(submitAction.getAttachActions())) {
                return recursiveAttachAction(submitAction.getAttachActions());
            }
        }
        return null;
    }

    public static SubmitAction getMergeSupportRetry(SubmitAction submitAction) {
        for (int i = 0; i < submitAction.getActionList().size(); i++) {
            SubmitAction action = submitAction.getActionList().get(i);
            if ((BooleanUtils.isTrue(action.getExecuted()) && action.getExecuteResult() == null) || (
                    BooleanUtils.isTrue(action.getExecuted()) && action.getExecuteResult() != null
                            && Boolean.FALSE.equals(action.getExecuteResult().getExecuteState())
            )) {
                //报错节点是首个执行action不记录日志
                if (0 == i) {
                    throw new RuntimeException("报错节点是首个执行action不记录日志");
                }
                return action;
            }
        }
        return recursiveMergeAttachAction(submitAction.getAttachActions());
    }

    public static SubmitAction recursiveMergeAttachAction(List<SubmitAction> attachActions) {
        for (SubmitAction submitAction : attachActions) {
            for (SubmitAction action : submitAction.getActionList()) {
                if ((BooleanUtils.isTrue(action.getExecuted()) && action.getExecuteResult() == null) || (
                        BooleanUtils.isTrue(action.getExecuted()) && action.getExecuteResult() != null
                                && Boolean.FALSE.equals(action.getExecuteResult().getExecuteState())
                )) {
                    return action;
                }
            }

            if (CollectionUtils.isNotEmpty(submitAction.getAttachActions())) {
                return recursiveMergeAttachAction(submitAction.getAttachActions());
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String data = ResourceUtil.readUtf8Str("bk/ActivityBkNormal.json");
        MergeSubmitActionDTO submitActionDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(data.toString()), MergeSubmitActionDTO.class);
        SubmitAction submitAction = LogRecordUtils.getMergeSupportRetry(submitActionDTO.getActionMerge());
        System.out.println(submitAction.getActionId());
    }

}
