/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=0)
@Service(value="AsaActionExecutor")
class AsaActionExecutor
implements ActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsaActionExecutor.class);
    @Autowired
    CommonESPService commonEspService;
    @Autowired
    private AsyncEventBus localEventBus;

    AsaActionExecutor() {
    }

    public String supportKey() {
        return "ASA:";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (action.getParas() == null) {
            action.setParas(new HashMap());
        }
        Map paras = action.getParas();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            paras.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        HashMap result = this.commonEspService.executeReturnAll(executeContext, (Action)action);
        HashMap dataMap = null;
        if (MapUtils.isNotEmpty((Map)result) && result.containsKey("data") && null != result.get("data")) {
            dataMap = (HashMap)result.get("data");
        }
        ExecuteResult executeResult = ExecuteResult.withData(dataMap);
        executeResult.setCompleted(false);
        AsaEvent asaEvent = new AsaEvent();
        asaEvent.setExecuteContext(executeContext);
        asaEvent.setAction(action);
        asaEvent.setResult(result);
        asaEvent.setDataMap(dataMap);
        this.localEventBus.post((Object)asaEvent);
        return executeResult;
    }
}

