/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.aam.CommonAttachmentService;
import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="attachmentActionExecutor")
public class AttachmentActionExecutor
extends TaskEngineActionExecutorBase {
    private static final Logger log = LoggerFactory.getLogger(AttachmentActionExecutor.class);
    @Resource
    private CommonAttachmentService commonAttachmentService;
    @Autowired
    private MessageUtils messageUtils;

    public String supportKey() {
        return "UIBOT:upload-or-save-attachment";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        Map extendParas = action.getExtendParas();
        this.checkActionExtendParas(extendParas);
        String submitVariableName = (String)extendParas.get("submitVariableName");
        List targetSchemaList = (List)extendParas.get("targetSchemaList");
        List needDeleteFilesAPI = new ArrayList();
        if (null != extendParas.get("needDeleteFilesAPI")) {
            needDeleteFilesAPI = (List)extendParas.get("needDeleteFilesAPI");
        }
        Map schemaDmcAccountMap = new HashMap();
        if (null != extendParas.get("schemaDmcAccountMap")) {
            schemaDmcAccountMap = (Map)extendParas.get("schemaDmcAccountMap");
        }
        ArrayList<Map> uploadedFiles = new ArrayList<Map>();
        ArrayList<Map> deletedFiles = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)targetSchemaList)) {
            this.classifyFiles(data.get(submitVariableName), targetSchemaList, uploadedFiles, deletedFiles);
        }
        if (CollectionUtils.isNotEmpty(uploadedFiles) || CollectionUtils.isNotEmpty(deletedFiles)) {
            this.commonAttachmentService.uploadOrDeleteAttachment(uploadedFiles, deletedFiles, Boolean.TRUE);
        }
        if (CollectionUtils.isNotEmpty(needDeleteFilesAPI)) {
            this.commonAttachmentService.deleteAttachment(needDeleteFilesAPI, schemaDmcAccountMap);
        }
        return ExecuteResult.ok();
    }

    private void classifyFiles(Object submitData, List<String> targetSchemaList, List<Map> uploadedFiles, List<Map> deletedFiles) {
        block4: {
            block3: {
                if (!(submitData instanceof Map)) break block3;
                Map data = (Map)submitData;
                for (String targetSchema : targetSchemaList) {
                    this.classifyFiles(data, targetSchema, uploadedFiles, deletedFiles);
                }
                break block4;
            }
            List dataList = (List)submitData;
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) break block4;
            for (Map data : dataList) {
                for (String targetSchema : targetSchemaList) {
                    this.classifyFiles(data, targetSchema, uploadedFiles, deletedFiles);
                }
            }
        }
    }

    private void classifyFiles(Map submitData, String targetSchema, List<Map> uploadedFiles, List<Map> deletedFiles) {
        if (MapUtils.isEmpty((Map)submitData) || null == submitData.get(targetSchema)) {
            return;
        }
        Map attachment = (Map)submitData.get(targetSchema);
        List attachmentDataList = (List)attachment.get("data");
        if (CollectionUtils.isEmpty((Collection)attachmentDataList)) {
            return;
        }
        for (Map attachmentData : attachmentDataList) {
            String status = (String)attachmentData.get("uibot__status");
            if (StringUtils.equalsIgnoreCase((String)status, (String)"NEW")) {
                uploadedFiles.add(attachmentData);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)status, (String)"DELETE")) continue;
            deletedFiles.add(attachmentData);
        }
    }

    private void checkActionExtendParas(Map<String, Object> extendParas) {
        if (MapUtils.isEmpty(extendParas) || null == extendParas.get("submitVariableName") || null == extendParas.get("targetSchemaList")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0043.getErrCode(), (String)this.messageUtils.getMessage("exception.effectAfterSubmit.config.empty"));
        }
        String submitVariableName = (String)extendParas.get("submitVariableName");
        if (StringUtils.isBlank((String)submitVariableName)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0043.getErrCode(), (String)this.messageUtils.getMessage("exception.effectAfterSubmit.config.empty"));
        }
    }

    public static void preprocessApiAttachment(List<SubmitActionDTO> submitActionList) {
        for (SubmitActionDTO submitActionDTO : submitActionList) {
            Map extendParas;
            SubmitAction action = submitActionDTO.getAction();
            SubmitAction attachementAction = AttachmentActionExecutor.parseAction("upload-or-save-attachment", action);
            if (attachementAction == null || MapUtils.isEmpty((Map)(extendParas = attachementAction.getExtendParas())) || null == extendParas.get("submitVariableName") || null == extendParas.get("targetSchemaListAPI")) continue;
            String submitVariableName = (String)extendParas.get("submitVariableName");
            List targetSchemaListAPI = (List)extendParas.get("targetSchemaListAPI");
            if (StringUtils.isBlank((String)submitVariableName) || CollectionUtils.isEmpty((Collection)targetSchemaListAPI)) continue;
            ArrayList<Map> deletedFiles = new ArrayList<Map>();
            AttachmentActionExecutor.dealApiAttachementFiles(submitActionDTO.getData().get(submitVariableName), targetSchemaListAPI, deletedFiles);
            if (!CollectionUtils.isNotEmpty(deletedFiles)) continue;
            extendParas.put("needDeleteFilesAPI", deletedFiles);
        }
    }

    private static void dealApiAttachementFiles(Object submitData, List<String> targetSchemaList, List<Map> deletedFiles) {
        block4: {
            block3: {
                if (!(submitData instanceof Map)) break block3;
                Map data = (Map)submitData;
                for (String targetSchema : targetSchemaList) {
                    LinkedList targetSchemaSplitList = AttachmentActionExecutor.getTargetSchemaSplitList(targetSchema);
                    AttachmentActionExecutor.dealApiAttachementFiles(data, targetSchema, targetSchemaSplitList, deletedFiles);
                }
                break block4;
            }
            List dataList = (List)submitData;
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) break block4;
            for (Map data : dataList) {
                for (String targetSchema : targetSchemaList) {
                    LinkedList targetSchemaSplitList = AttachmentActionExecutor.getTargetSchemaSplitList(targetSchema);
                    AttachmentActionExecutor.dealApiAttachementFiles(data, targetSchema, targetSchemaSplitList, deletedFiles);
                }
            }
        }
    }

    private static LinkedList getTargetSchemaSplitList(String targetSchema) {
        String[] targetSchemaArray = targetSchema.split("\\.");
        return new LinkedList<String>(Arrays.asList(targetSchemaArray));
    }

    private static void dealApiAttachementFiles(Map submitData, String targetSchema, LinkedList<String> targetSchemaSplitList, List<Map> deletedFiles) {
        if (MapUtils.isEmpty((Map)submitData)) {
            return;
        }
        Iterator targetSchemaIterator = targetSchemaSplitList.iterator();
        while (targetSchemaIterator.hasNext()) {
            String currentSchema = targetSchemaSplitList.poll();
            Object obj = submitData.get(currentSchema);
            if (null == obj) {
                return;
            }
            if (obj instanceof Map) {
                if (CollectionUtils.isEmpty(targetSchemaSplitList)) {
                    AttachmentActionExecutor.doDealApiAttachementFiles(submitData, targetSchema, currentSchema, deletedFiles);
                    continue;
                }
                AttachmentActionExecutor.dealApiAttachementFiles(submitData, targetSchema, targetSchemaSplitList, deletedFiles);
                continue;
            }
            List dataList = (List)submitData.get(currentSchema);
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) continue;
            String schema = targetSchemaSplitList.poll();
            for (Map data : dataList) {
                AttachmentActionExecutor.doDealApiAttachementFiles(data, targetSchema, schema, deletedFiles);
            }
        }
    }

    private static void doDealApiAttachementFiles(Map<String, Object> data, String targetSchema, String schema, List<Map> deletedFiles) {
        if (StringUtils.isEmpty((String)schema)) {
            return;
        }
        Map attachment = (Map)data.get(schema);
        if (null == attachment) {
            return;
        }
        List attachmentDataList = (List)attachment.get("data");
        if (CollectionUtils.isEmpty((Collection)attachmentDataList)) {
            return;
        }
        Iterator attachmentDataIterator = attachmentDataList.iterator();
        while (attachmentDataIterator.hasNext()) {
            Map attachmentData = (Map)attachmentDataIterator.next();
            String status = (String)attachmentData.get("uibot__status");
            attachmentData.remove("uibot__status");
            if (!StringUtils.equalsIgnoreCase((String)status, (String)"DELETE")) continue;
            attachmentData.put("targetSchema", targetSchema);
            deletedFiles.add(attachmentData);
            attachmentDataIterator.remove();
        }
    }

    public static SubmitAction parseAction(String targetActionId, SubmitAction submitAction) {
        if (submitAction == null) {
            return null;
        }
        if (targetActionId.equals(submitAction.getActionId())) {
            return submitAction;
        }
        List attachActions = submitAction.getAttachActions();
        if (CollectionUtils.isNotEmpty((Collection)attachActions)) {
            for (SubmitAction attachAction : attachActions) {
                SubmitAction targetAction = AttachmentActionExecutor.parseAction(targetActionId, attachAction);
                if (null == targetAction) continue;
                return targetAction;
            }
        }
        return null;
    }
}

