/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.lang.Tuple;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.executor.AttachmentActionExecutor;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.action.executor.ManualTaskActionExecutor;
import com.digiwin.athena.atdm.action.impl.MergeActionExecuteService;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitType;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.log.LogRecordDTO;
import com.digiwin.athena.atdm.log.LogRecordEvent;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataSubmissionServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(DataSubmissionServiceWrapper.class);
    public static final String MERGE_WHITE_LIST = "mergeSubmitActivityIdWhiteList";
    public static final Integer MAX_COMMIT_SIZE = 2000;
    public static final String WHITE_LIST = "submitActivityIdWhiteList";
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private DataSubmissionService dataSubmissionService;
    @Autowired
    private ManualTaskActionExecutor manualTaskActionExecutor;
    @Autowired
    private AsyncEventBus asyncEventBus;
    @Autowired
    private MergeActionExecuteService mergeActionExecuteService;

    public ExecuteResult executeAction(HttpServletRequest request, SubmitActionDTO submitAction) {
        try {
            this.actionCheck(request, submitAction);
            AttachmentActionExecutor.preprocessApiAttachment(com.google.common.collect.Lists.newArrayList((Object[])new SubmitActionDTO[]{submitAction}));
            SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
            SubmitAction action = submitAction.getAction();
            Map data = submitAction.getData();
            log.info("actionExecuteService.submit start");
            return this.dataSubmissionService.submit(new ActionExecuteReq(executeContext, null, action, data, submitAction.getWorkItemIdToData()));
        }
        catch (Exception e) {
            this.logRecord(request, submitAction);
            throw e;
        }
    }

    private void actionCheck(HttpServletRequest request, SubmitActionDTO submitAction) {
        SubmitAction action;
        if (submitAction.getAction() == null) {
            throw new IllegalArgumentException("submitAction.action\u4e3anull");
        }
        if (submitAction.getData() == null) {
            throw new IllegalArgumentException("submitAction.data\u4e3anull");
        }
        SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
        if (executeContext == null) {
            executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            submitAction.getAction().setExecuteContext(executeContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        executeContext.setOperateAuthoredUser(submitAction.getOperateAuthoredUser());
        if (CollectionUtils.isNotEmpty((Collection)submitAction.getAction().getAttachActions())) {
            List attachActions = submitAction.getAction().getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                SubmitExecuteContext attachActionExecuteContext = attachAction.getExecuteContext();
                if (attachActionExecuteContext == null) {
                    attachAction.setExecuteContext(executeContext);
                    continue;
                }
                attachActionExecuteContext.appendHttpRequest(request);
            }
        }
        if ((action = submitAction.getAction()) == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        ArrayList<SubmitActionDTO> list = new ArrayList<SubmitActionDTO>();
        list.add(submitAction);
        if (!this.validateSizeOrWhiteList(list)) {
            throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0003.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"submit.task.size.overflow", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
    }

    private boolean validateSizeOrWhiteList(List<SubmitActionDTO> submitActions) {
        if (this.atmcService.operationConfig(submitActions.get(0).getAction().getExecuteContext().getTmActivityId(), Integer.valueOf(0), WHITE_LIST).booleanValue()) {
            return true;
        }
        return submitActions.stream().filter(e -> e.getData() != null).noneMatch(e -> e.getData().values().stream().filter(List.class::isInstance).map(el -> (List)el).anyMatch(el -> el.size() > MAX_COMMIT_SIZE));
    }

    public ExecuteResult executeOpenTaskWindowAction(HttpServletRequest request, SubmitActionDTO submitAction) {
        if (submitAction.getAction() == null) {
            throw new IllegalArgumentException("submitAction.action\u4e3anull");
        }
        if (submitAction.getData() == null) {
            throw new IllegalArgumentException("submitAction.data\u4e3anull");
        }
        SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
        if (executeContext == null) {
            executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(submitAction.getAction().getBusinessUnit());
            submitAction.getAction().setExecuteContext(executeContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        if (CollectionUtils.isNotEmpty((Collection)submitAction.getAction().getAttachActions())) {
            List attachActions = submitAction.getAction().getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                SubmitExecuteContext attachActionExecuteContext = attachAction.getExecuteContext();
                if (attachActionExecuteContext == null) {
                    attachAction.setExecuteContext(executeContext);
                    continue;
                }
                attachActionExecuteContext.appendHttpRequest(request);
            }
        }
        this.preExecute(executeContext, submitAction);
        return this.doExecute(executeContext, submitAction);
    }

    private ExecuteResult doExecute(SubmitExecuteContext executeContext, SubmitActionDTO submitAction) {
        return this.dataSubmissionService.execute(executeContext, submitAction.getAction(), submitAction.getData());
    }

    private void preExecute(SubmitExecuteContext executeContext, SubmitActionDTO submitAction) {
        this.manualTaskActionExecutor.preExecute(executeContext, submitAction.getAction(), submitAction.getData());
    }

    public List<ExecuteResult> executeReturnAction(HttpServletRequest request, List<SubmitActionDTO> submitActionList) throws Throwable {
        List resultList = null;
        if (CollectionUtils.isNotEmpty(submitActionList)) {
            SubmitActionDTO firstAction = submitActionList.get(0);
            if (submitActionList.size() == 1) {
                return this.executeMergeAction(request, submitActionList);
            }
            SubmitAction action = firstAction.getAction();
            this.actionCheck(request, firstAction);
            String category = action.getCategory();
            Map firstData = firstAction.getData();
            boolean isFirstEspApi = "ESP".equals(category);
            if (isFirstEspApi) {
                SubmitType submitType = action.getSubmitType();
                Map cloneData = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)firstData), Map.class);
                String dataSourceName = submitType != null ? submitType.getSchema() : firstData.keySet().toArray()[0].toString();
                List params = (List)cloneData.get(dataSourceName);
                for (int i = 1; i < submitActionList.size(); ++i) {
                    SubmitActionDTO submitActionDto = submitActionList.get(i);
                    Map data = submitActionDto.getData();
                    Object o = data.get(dataSourceName);
                    if (!(o instanceof List)) continue;
                    params.addAll((Collection)o);
                }
                SubmitAction submitAction = firstAction.getAction();
                List attachActions = submitAction.getAttachActions();
                DataSourceDTO checkCompleteAction = submitAction.getCheckCompleteAction();
                submitAction.setAttachActions(null);
                submitAction.setCheckCompleteAction(null);
                submitAction.setExecuteEventPost(true);
                this.dataSubmissionService.submit(firstAction.getAction().getExecuteContext(), action, cloneData);
                submitAction.setAttachActions(attachActions);
                submitAction.setCheckCompleteAction(checkCompleteAction);
                submitAction.setExecuteEventPost(false);
            }
            ArrayList returnActionList = Lists.newArrayList();
            this.mergeReturnTaskAction(returnActionList, submitActionList);
            if (CollectionUtils.isEmpty((Collection)returnActionList)) {
                throw new IllegalArgumentException("actionId:task-return \u4e0d\u5b58\u5728");
            }
            HashMap param = Maps.newHashMapWithExpectedSize((int)1);
            SubmitActionDTO returnActionDto = (SubmitActionDTO)returnActionList.get(0);
            SubmitAction returnAction = (SubmitAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)returnActionDto.getAction()), SubmitAction.class);
            returnAction.setActionParams(null);
            returnAction.setParas(null);
            returnAction.setExecuteEventPost(true);
            param.put("ACTION_RETURN_PARAMS", returnActionList);
            this.dataSubmissionService.submit(returnAction.getExecuteContext(), returnAction, param);
            if (isFirstEspApi) {
                for (SubmitActionDTO actionDTO : submitActionList) {
                    SubmitAction submitAction = actionDTO.getAction();
                    submitAction.setExecuteAction(true);
                }
            }
            Tuple tuple = this.executeSubmitActionList(request, submitActionList);
            resultList = (List)tuple.get(2);
        }
        return resultList;
    }

    private void mergeReturnTaskAction(List<SubmitActionDTO> returnActionList, List<SubmitActionDTO> submitActionList) {
        Iterator<SubmitActionDTO> iterator = submitActionList.iterator();
        block0: while (iterator.hasNext()) {
            SubmitActionDTO actionDTO = iterator.next();
            SubmitAction action = actionDTO.getAction();
            String actionId = action.getActionId();
            if ("task-return".equals(actionId)) {
                returnActionList.add(actionDTO);
                iterator.remove();
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)action.getAttachActions())) continue;
            List attachActions = action.getAttachActions();
            Iterator actionIterator = attachActions.iterator();
            while (actionIterator.hasNext()) {
                SubmitAction next = (SubmitAction)actionIterator.next();
                if (!"task-return".equals(next.getActionId())) continue;
                SubmitActionDTO submitActionDTO = new SubmitActionDTO();
                submitActionDTO.setAction(next);
                submitActionDTO.setData(actionDTO.getData());
                submitActionDTO.setOperateAuthoredUser(actionDTO.getOperateAuthoredUser());
                returnActionList.add(submitActionDTO);
                actionIterator.remove();
                continue block0;
            }
        }
    }

    private Tuple executeSubmitActionList(HttpServletRequest request, List<SubmitActionDTO> submitActionList) {
        ArrayList<ExecuteResult> resultList = new ArrayList<ExecuteResult>();
        String backlogId = "";
        String tenantId = "";
        for (SubmitActionDTO submitActionDTO : submitActionList) {
            SubmitAction taskAction = submitActionDTO.getAction();
            SubmitExecuteContext executeContext = taskAction.getExecuteContext();
            if (executeContext == null) {
                executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            }
            if (StringUtils.hasText((String)executeContext.getProxyToken())) {
                AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
            }
            executeContext.setOperateAuthoredUser(submitActionDTO.getOperateAuthoredUser());
            this.setExecuteContext(request, taskAction, executeContext);
            backlogId = String.valueOf(executeContext.getBacklogId());
            tenantId = submitActionDTO.getOperateAuthoredUser() == null ? "" : submitActionDTO.getOperateAuthoredUser().getTenantId();
            Map data = submitActionDTO.getData();
            LogDto logDto = new LogDto("\u6267\u884c\u6240\u6709\u5408\u5e76\u6570\u636e\u7684\u4efb\u52a1\u4e4b\u5916\u7684action\u5f00\u59cb\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
            log.info(logDto.toString());
            ExecuteResult executeResult = this.dataSubmissionService.submit(executeContext, taskAction, data);
            LogDto logDtoEnd = new LogDto("\u6267\u884c\u6240\u6709\u5408\u5e76\u6570\u636e\u7684\u4efb\u52a1\u4e4b\u5916\u7684action\u7ed3\u675f\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
            log.info(logDtoEnd.toString());
            HashMap<String, Long> extendResult = new HashMap<String, Long>();
            extendResult.put("backlogId", executeContext.getBacklogId());
            executeResult.setExtendResult(extendResult);
            resultList.add(executeResult);
        }
        return new Tuple(new Object[]{backlogId, tenantId, resultList});
    }

    public List<ExecuteResult> executeMergeAction(HttpServletRequest request, List<SubmitActionDTO> submitActionList) throws Throwable {
        if (CollectionUtils.isEmpty(submitActionList)) {
            throw new IllegalArgumentException("submitActionList\u4e3anull\u6216\u4e3a\u7a7a");
        }
        for (SubmitActionDTO submitActionDTO : submitActionList) {
            if (submitActionDTO.getAction() != null) continue;
            throw new IllegalArgumentException("submitActionList.action\u4e3anull");
        }
        if (!this.validateSizeOrWhiteList(submitActionList)) {
            throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0003.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"submit.task.size.overflow", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
        AttachmentActionExecutor.preprocessApiAttachment(submitActionList);
        return this.mergeActionExecuteService.executeMergeActionWapper(request, submitActionList);
    }

    public List<ExecuteResult> executeMergeActionCrossBk(HttpServletRequest request, List<SubmitActionDTO> submitActionList) throws Throwable {
        if (CollectionUtils.isEmpty(submitActionList)) {
            throw new IllegalArgumentException("submitActionList\u4e3anull\u6216\u4e3a\u7a7a");
        }
        for (SubmitActionDTO submitActionDTO : submitActionList) {
            if (submitActionDTO.getAction() != null) continue;
            throw new IllegalArgumentException("submitActionList.action\u4e3anull");
        }
        if (!this.validateSizeOrWhiteList(submitActionList)) {
            throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0003.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"submit.task.size.overflow", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
        if (this.atmcService.operationConfig("mergeSubmitActivityIdWhiteList_" + submitActionList.get(0).getAction().getExecuteContext().getTmActivityId(), Integer.valueOf(0), MERGE_WHITE_LIST).booleanValue()) {
            LogDto logDto = new LogDto("\u6267\u884c\u652f\u6301\u8de8BK\u7684\u5408\u5e76\u4efb\u52a1\u65b0\u903b\u8f91");
            log.info(logDto.toString());
            return this.mergeActionExecuteService.executeMergeActionWapper(request, submitActionList);
        }
        log.info("start to deal find support submit merge data action start");
        ArrayList<SubmitAction> mergeDataActions = new ArrayList<SubmitAction>();
        for (SubmitActionDTO submitActionDTO : submitActionList) {
            SubmitAction taskAction = submitActionDTO.getAction();
            this.findSupportSubmitMergeDataActions(mergeDataActions, taskAction);
        }
        log.info("start to deal find support submit merge data action end");
        Collection<SubmitAction> collection = this.initSubmitMergeDataActions(mergeDataActions);
        log.info("init submit merge data action end");
        Tuple tuple = this.executeSubmitActionList(request, submitActionList);
        String backlogId = (String)tuple.get(0);
        String tenantId = (String)tuple.get(1);
        log.info("execute non-merge action  end");
        LogDto logDto = new LogDto("\u6267\u884c\u6240\u6709\u652f\u6301\u8de8BK\u7684\u5408\u5e76\u6570\u636e\u7684\u4efb\u52a1action\u5f00\u59cb\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
        log.info(logDto.toString());
        this.executeMergeAction(submitActionList.get(0), collection);
        log.info("execute merge action  end");
        LogDto logDtoEnd = new LogDto("\u6267\u884c\u6240\u6709\u652f\u6301\u8de8BK\u7684\u5408\u5e76\u6570\u636e\u7684\u4efb\u52a1action\u7ed3\u675f\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
        log.info(logDtoEnd.toString());
        return (List)tuple.get(2);
    }

    public List<ExecuteResult> executeMergeActionRetry(HttpServletRequest request, MergeSubmitActionDTO mergeSubmitAction) throws Throwable {
        try {
            return this.mergeActionExecuteService.executeMergeAction(request, mergeSubmitAction);
        }
        catch (Throwable e) {
            this.mergeActionExecuteService.logRecord(request, mergeSubmitAction);
            throw e;
        }
    }

    private void setExecuteContext(HttpServletRequest request, SubmitAction taskAction, SubmitExecuteContext parentExecuteContext) {
        SubmitExecuteContext executeContext = taskAction.getExecuteContext();
        if (executeContext == null) {
            executeContext = parentExecuteContext;
            taskAction.setExecuteContext(parentExecuteContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskAction.getAttachActions())) {
            List attachActions = taskAction.getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                this.setExecuteContext(request, attachAction, executeContext);
            }
        }
    }

    private Collection<SubmitAction> initSubmitMergeDataActions(List<SubmitAction> mergeDataActions) {
        if (CollectionUtils.isEmpty(mergeDataActions)) {
            return mergeDataActions;
        }
        LinkedHashMap<String, SubmitAction> firstActions = new LinkedHashMap<String, SubmitAction>();
        for (SubmitAction submitAction : mergeDataActions) {
            if (!firstActions.containsKey(submitAction.getActionId())) {
                firstActions.put(submitAction.getActionId(), submitAction);
            }
            submitAction.setMergeDataAction((SubmitAction)firstActions.get(submitAction.getActionId()));
        }
        return firstActions.values();
    }

    private void findSupportSubmitMergeDataActions(List<SubmitAction> list, SubmitAction taskAction) {
        if (this.dataSubmissionService.isSupportSubmitMergeData(taskAction)) {
            list.add(taskAction);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskAction.getAttachActions())) {
            for (SubmitAction attachAction : taskAction.getAttachActions()) {
                this.findSupportSubmitMergeDataActions(list, attachAction);
            }
        }
    }

    private void executeMergeAction(SubmitActionDTO submitActionDTO, Collection<SubmitAction> needExecuteMergeActions) {
        if (CollectionUtils.isEmpty(needExecuteMergeActions)) {
            return;
        }
        Map startData = submitActionDTO.getData();
        for (SubmitAction needExecuteMergeAction : needExecuteMergeActions) {
            needExecuteMergeAction.setAttachActions(null);
            this.dataSubmissionService.submit(needExecuteMergeAction.getExecuteContext(), needExecuteMergeAction, startData);
        }
    }

    private void logRecord(HttpServletRequest request, SubmitActionDTO submitAction) {
        try {
            LogRecordDTO logRecordDTO = new LogRecordDTO();
            logRecordDTO.setInputValue(JsonUtils.objectToString((Object)submitAction));
            logRecordDTO.setCreateTime(new Date());
            logRecordDTO.setUrl("/api/atdm/v1/action/submit/task");
            LogRecordEvent logRecordEvent = new LogRecordEvent(request, logRecordDTO, submitAction.getOperateAuthoredUser());
            this.asyncEventBus.post((Object)logRecordEvent);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7EventBus\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

