/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.dto.ManualTaskConsistencyResp;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.PropertyPlaceholderHelper;

@Order(value=0)
@Service(value="ManualTaskActionExecutor")
public class ManualTaskActionExecutor
implements ActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ManualTaskActionExecutor.class);
    private static final PropertyPlaceholderHelper PLACEHOLDER_HELPER = new PropertyPlaceholderHelper("${", "}", (String)null, true);
    private static final String ACTION_SUBMIT = "uibot_manual.task.submit";
    private static final String ACTION_DELETE = "uibot_manual.task.delete";
    private static final String ACTION_EDIT = "uibot_manual.task.edit";
    private static final int SOURCE_TYPE_MANUAL = 1;
    private static final int STATE_CLOSE = 3;
    private static final int SUB_STATE_DELETE = 9999;
    private static final List<String> MANUAL_TASK_ACTION_TYPE_LIST = Arrays.asList("manual-task-submit", "manual-task-edit", "manual-task-delete");
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private MessageUtils messageUtils;

    public String supportKey() {
        return "MANUAL_TASK:";
    }

    public void preExecute(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        if (null == action || !MANUAL_TASK_ACTION_TYPE_LIST.contains(action.getActionType())) {
            return;
        }
        if (MapUtils.isEmpty(data) || null == data.get("data")) {
            return;
        }
        Map submitData = (Map)data.get("data");
        if (MapUtils.isEmpty((Map)submitData) || null == submitData.get("executorList")) {
            return;
        }
        List executorList = (List)submitData.get("executorList");
        this.checkManualTaskConsistency(executorList, submitData, executeContext.getBacklogId());
        if (null != executorList) {
            if (1 == executorList.size()) {
                submitData.remove("executorList");
                submitData.putAll((Map)executorList.get(0));
            } else if (2 <= executorList.size()) {
                ArrayList newSubmitData = new ArrayList();
                for (Map executor : executorList) {
                    HashMap subData = new HashMap();
                    subData.putAll(submitData);
                    subData.remove("executorList");
                    subData.putAll(executor);
                    newSubmitData.add(subData);
                }
                data.put("data", newSubmitData);
            }
        }
    }

    private void checkManualTaskConsistency(List<Map<String, String>> executorList, Map<String, Object> submitData, Long backlogId) {
        Long teamId;
        String executorUserId = "executorUserId";
        try {
            teamId = Long.valueOf(submitData.get("teamId").toString());
        }
        catch (Exception e2) {
            log.info(" no teamId");
            return;
        }
        ManualTaskConsistencyResp freshData = this.atmcService.checkConsistency(teamId, backlogId);
        if (!freshData.getItemBelongsToTeam().booleanValue()) {
            throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0004.getErrCode(), (String)this.messageUtils.getMessage("manual.task.invalid.data"));
        }
        executorList.removeIf(e -> !freshData.getTeamMemberUserIds().contains(e.get(executorUserId)));
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (null != data && data.size() > 2) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0013.getErrCode(), (String)this.messageUtils.getMessage("exception.calendar.activity.data.error"));
        }
        if (StringUtils.equals((String)ACTION_SUBMIT, (String)action.getActionId())) {
            Optional<Long> backlogIdOpt = Optional.ofNullable(action.getExecuteContext()).map(SubmitExecuteContext::getBacklogId);
            if (backlogIdOpt.isPresent()) {
                this.updateManualTask(executeContext, action, data);
            } else {
                this.createManualTask(executeContext, action, data);
            }
        } else if (StringUtils.equals((String)ACTION_EDIT, (String)action.getActionId())) {
            this.editManualTask(executeContext, action, data);
        } else if (StringUtils.equals((String)ACTION_DELETE, (String)action.getActionId())) {
            this.deleteManualTask(executeContext, action, data);
        } else {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0014.getErrCode(), (String)"");
        }
        if (parentExecuteResult != null) {
            if (parentExecuteResult.getRequestData() == null) {
                parentExecuteResult.setRequestData((Map)((HashMap)data));
            } else {
                parentExecuteResult.getRequestData().putAll((HashMap)data);
            }
            if (parentExecuteResult.getData() == null) {
                parentExecuteResult.setData((Map)((HashMap)data));
            } else {
                parentExecuteResult.getData().putAll((HashMap)data);
            }
            return ExecuteResult.ok();
        }
        ExecuteResult result = ExecuteResult.withData((HashMap)((HashMap)data));
        if (result.getRequestData() == null) {
            result.setRequestData((Map)((HashMap)data));
        } else {
            result.getRequestData().putAll((HashMap)data);
        }
        return result;
    }

    private void editManualTask(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        String customTaskName = this.parseCustomTaskName(executeContext.getParentAction(), data);
        Map<String, Object> submitDataMap = this.mergeActionResult(data);
        if (StringUtils.isNotBlank((String)customTaskName)) {
            submitDataMap.put("taskName", customTaskName);
        }
        submitDataMap.put("_planEndTime", submitDataMap.get("endTime"));
        submitDataMap.put("tmActivityId", submitDataMap.get("taskId"));
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("data", submitDataMap);
        json.put("createTime", submitDataMap.get("startTime"));
        Object executeState = submitDataMap.get("executeState");
        if (null != executeState && Objects.equals("1", String.valueOf(executeState))) {
            json.put("state", 3);
            json.put("subState", 10);
        } else {
            json.put("state", 1);
            json.put("subState", 0);
        }
        json.put("sourceType", 1);
        json.put("actionId", ACTION_EDIT);
        json.put("teamId", submitDataMap.get("teamId"));
        json.put("workItemId", action.getExecuteContext().getBacklogId());
        json.put("memberUserId", submitDataMap.get("executorUserId"));
        json.put("memberUserName", submitDataMap.get("executorUserName"));
        this.atmcService.manualTaskStateChanged(Collections.singletonList(json));
    }

    private void deleteManualTask(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        Map<String, Object> submitDataMap = this.mergeActionResult(data);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("data", submitDataMap);
        json.put("state", 3);
        json.put("subState", 9999);
        json.put("sourceType", 1);
        json.put("actionId", ACTION_DELETE);
        json.put("teamId", submitDataMap.get("teamId"));
        json.put("workItemId", action.getExecuteContext().getBacklogId());
        json.put("memberUserId", submitDataMap.get("executorUserId"));
        json.put("memberUserName", submitDataMap.get("executorUserName"));
        this.atmcService.manualTaskStateChanged(Collections.singletonList(json));
    }

    private void updateManualTask(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        String customTaskName = this.parseCustomTaskName(executeContext.getParentAction(), data);
        Map<String, Object> submitDataMap = this.mergeActionResult(data);
        if (StringUtils.isNotBlank((String)customTaskName)) {
            submitDataMap.put("taskName", customTaskName);
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("data", submitDataMap);
        json.put("state", 3);
        json.put("subState", 10);
        json.put("sourceType", 1);
        json.put("actionId", ACTION_SUBMIT);
        json.put("teamId", submitDataMap.get("teamId"));
        json.put("workItemId", action.getExecuteContext().getBacklogId());
        json.put("memberUserId", submitDataMap.get("executorUserId"));
        json.put("memberUserName", submitDataMap.get("executorUserName"));
        this.atmcService.manualTaskStateChanged(Collections.singletonList(json));
    }

    private Map<String, Object> mergeActionResult(Map<String, Object> data) {
        Map submitDataMap = (Map)data.get("data");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if ("data".equals(entry.getKey())) continue;
            submitDataMap.put(entry.getKey(), entry.getValue());
        }
        return submitDataMap;
    }

    private String parseCustomTaskName(SubmitAction parentAction, Map<String, Object> data) {
        String taskNameExpression = Optional.ofNullable(parentAction).map(action -> action.getExtendParas()).map(extendParas -> (String)extendParas.get("calendarTaskNameExpression")).orElse("");
        if (StringUtils.isBlank((String)taskNameExpression)) {
            return "";
        }
        return PLACEHOLDER_HELPER.replacePlaceholders(taskNameExpression, placeholderName -> {
            if (StringUtils.isBlank((String)placeholderName)) {
                return "";
            }
            HashMap<String, Object> requestPlanMap = new HashMap<String, Object>();
            this.flatData(requestPlanMap, data.get("data"), "");
            Object placeholderValue = requestPlanMap.get(placeholderName);
            String finalValue = String.valueOf(placeholderValue);
            if (null != placeholderValue && StringUtils.isNotBlank((String)finalValue)) {
                return finalValue;
            }
            HashMap responseMap = new HashMap(data);
            responseMap.remove("data");
            HashMap<String, Object> responsePlanMap = new HashMap<String, Object>();
            this.flatData(responsePlanMap, responseMap, "");
            placeholderValue = responsePlanMap.get(placeholderName);
            finalValue = String.valueOf(placeholderValue);
            if (null != placeholderValue && StringUtils.isNotBlank((String)finalValue)) {
                return String.valueOf(placeholderValue);
            }
            return "";
        });
    }

    private void flatData(Map<String, Object> planMap, Object data, String keyPrefix) {
        if (null == data) {
            return;
        }
        if (data instanceof Map) {
            Map dataMap = (Map)data;
            Set entrySet = dataMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String path = StringUtils.isNotBlank((String)keyPrefix) ? keyPrefix + "." + String.valueOf(entry.getKey()) : String.valueOf(entry.getKey());
                this.flatData(planMap, entry.getValue(), path);
            }
        } else if (data instanceof Collection) {
            Collection collection = (Collection)data;
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                for (Object element : collection) {
                    if (null == element) continue;
                    this.flatData(planMap, element, keyPrefix);
                    break;
                }
            }
        } else if (data.getClass().isArray()) {
            Object[] array = (Object[])data;
            if (ArrayUtils.isNotEmpty((Object[])array)) {
                for (Object element : array) {
                    if (null == element) continue;
                    this.flatData(planMap, element, keyPrefix);
                    break;
                }
            }
        } else {
            planMap.put(keyPrefix, data);
        }
    }

    private void createManualTask(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        if (data.get("data") instanceof List) {
            String parentRespDataKey = null;
            HashMap<String, Map<String, Object>> parentRespDataMap = new HashMap<String, Map<String, Object>>();
            parentRespDataKey = this.flatParentRespByExecutorNo(data, parentRespDataMap);
            List manualTaskDataList = (List)data.get("data");
            ArrayList<Map<String, Object>> manualTaskList = new ArrayList<Map<String, Object>>();
            for (Map manualTaskData : manualTaskDataList) {
                HashMap<String, Object> tmpSubmitAndParentRespData = new HashMap<String, Object>();
                tmpSubmitAndParentRespData.put("data", manualTaskData);
                String executorEmpId = manualTaskData.get("executorEmpId").toString();
                if (StringUtils.isNotBlank((String)parentRespDataKey)) {
                    tmpSubmitAndParentRespData.put(parentRespDataKey, Collections.singletonList(parentRespDataMap.get(executorEmpId)));
                }
                Map<String, Object> manualTask = this.createManualTaskData(executeContext, action, tmpSubmitAndParentRespData);
                manualTaskList.add(manualTask);
            }
            this.atmcService.manualTaskStateChanged(manualTaskList).getResponse();
        } else {
            Map<String, Object> manualTask = this.createManualTaskData(executeContext, action, data);
            Long backlogId = (Long)this.atmcService.manualTaskStateChanged(Collections.singletonList(manualTask)).getResponse();
            ((Map)manualTask.get("data")).put("backlogId", backlogId);
        }
    }

    private String flatParentRespByExecutorNo(Map<String, Object> data, Map<String, Map<String, Object>> parentRespDataMap) {
        if (data.size() <= 1) {
            return null;
        }
        String parentRespDataKey = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (StringUtils.equals((String)entry.getKey(), (String)"data")) continue;
            parentRespDataKey = entry.getKey();
            if (!(entry.getValue() instanceof List)) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0015.getErrCode(), (String)this.messageUtils.getMessage("exception.create.calendar.activity.api.result"));
            }
            List parentRespDataList = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)parentRespDataList)) continue;
            for (Map parentRespData : parentRespDataList) {
                if (null == parentRespData.get("executor_no")) {
                    String errMsg = this.messageUtils.getMessage("manual.task.not.support.multi.executor");
                    throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0001.getErrCode(), (String)errMsg);
                }
                parentRespDataMap.put(parentRespData.get("executor_no").toString(), parentRespData);
            }
        }
        return parentRespDataKey;
    }

    private Map<String, Object> createManualTaskData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        String customTaskName = this.parseCustomTaskName(executeContext.getParentAction(), data);
        Map<String, Object> submitDataMap = this.mergeActionResult(data);
        submitDataMap.put("tmActivityName", submitDataMap.get("taskName"));
        if (StringUtils.isNotBlank((String)customTaskName)) {
            submitDataMap.put("taskName", customTaskName);
        }
        submitDataMap.put("_planEndTime", submitDataMap.get("endTime"));
        submitDataMap.put("tmActivityId", submitDataMap.get("taskId"));
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("data", submitDataMap);
        json.put("createTime", submitDataMap.get("startTime"));
        Object executeState = submitDataMap.get("executeState");
        if (null != executeState && Objects.equals("1", String.valueOf(executeState))) {
            json.put("state", 3);
            json.put("subState", 10);
        } else {
            json.put("state", 1);
            json.put("subState", 0);
        }
        json.put("sourceType", 1);
        json.put("actionId", ACTION_SUBMIT);
        json.put("teamId", submitDataMap.get("teamId"));
        json.put("memberUserId", submitDataMap.get("executorUserId"));
        json.put("memberUserName", submitDataMap.get("executorUserName"));
        return json;
    }
}

