/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NewStartManualProjectActionExecutor
implements ActionExecutor {
    protected static final String SPLIT = ";;";
    protected static final String SUBMIT_DATA_ACTION_ID_KEY = "startActionId";
    public static final String PROJECT_CODE = "projectCode";
    public static final String ADAPTER_TO_START_PROJECT = "adapterToStartProject";
    @Resource
    private CommonTaskEngineService commonTaskEngineService;

    public String supportKey() {
        return "MANUALPROJECT_NEW:";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (MapUtil.isEmpty(data)) {
            return ExecuteResult.empty();
        }
        if (action.getParas() == null) {
            action.setParas(new HashMap());
        }
        Map paraMap = action.getParas();
        String actionId = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getKey().equals("return_request_data")) continue;
            if (SUBMIT_DATA_ACTION_ID_KEY.equals(entry.getKey())) {
                actionId = String.valueOf(entry.getValue());
                continue;
            }
            if (PROJECT_CODE.equals(entry.getKey()) || ADAPTER_TO_START_PROJECT.equals(entry.getKey())) {
                paraMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Collection) {
                paraMap.put("dispatchData", entry.getValue());
                break;
            }
            ArrayList<Object> dispatchData = new ArrayList<Object>();
            dispatchData.add(entry.getValue());
            Map keyMap = (Map)entry.getValue();
            paraMap.putAll(keyMap);
            paraMap.put("dispatchData", dispatchData);
            break;
        }
        if (MapUtil.isEmpty((Map)paraMap)) {
            return ExecuteResult.empty();
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setData(new HashMap());
        List<Object> retList = this.executeSubmitAction(executeContext.getAuthoredUser().getUserId(), actionId, paraMap);
        result.getData().put("projectCardInfo", retList);
        return result;
    }

    private List<Object> executeSubmitAction(String userId, String actionId, Map<String, Object> paraMap) {
        List eocMapList = (List)paraMap.remove("eocInfo");
        String projectCode = (String)paraMap.remove(ADAPTER_TO_START_PROJECT);
        if (StrUtil.isBlank((CharSequence)projectCode)) {
            projectCode = (String)paraMap.remove(PROJECT_CODE);
        }
        List dispatchDataList = new ArrayList();
        if (paraMap.containsKey("dispatchData")) {
            dispatchDataList = (List)paraMap.get("dispatchData");
        }
        if (StrUtil.isBlank((CharSequence)projectCode) && CollectionUtil.isNotEmpty(dispatchDataList)) {
            for (Map dataMap : dispatchDataList) {
                if (MapUtil.isEmpty((Map)dataMap)) continue;
                projectCode = MapUtil.getStr((Map)dataMap, (Object)ADAPTER_TO_START_PROJECT, (String)"");
                if (StrUtil.isBlank((CharSequence)projectCode)) {
                    projectCode = MapUtil.getStr((Map)dataMap, (Object)PROJECT_CODE, (String)"");
                }
                if (!StrUtil.isNotBlank((CharSequence)projectCode)) continue;
                break;
            }
        }
        ArrayList<Object> retList = new ArrayList<Object>();
        if (CollectionUtil.isEmpty((Collection)eocMapList)) {
            Map retMap = this.commonTaskEngineService.startNewProject(userId, projectCode, Collections.emptyMap(), Collections.emptyMap(), dispatchDataList);
            retList.add(retMap);
            return retList;
        }
        for (Map eocMap : eocMapList) {
            Map forEachMap = new HashMap();
            forEachMap = this.commonTaskEngineService.startNewProject(userId, projectCode, eocMap, Collections.emptyMap(), dispatchDataList);
            retList.add(forEachMap);
        }
        return retList;
    }
}

