/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.dto.CacheDto;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.BusinessConfig;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.StatementConfig;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=0)
@Service(value="PrintActionExecutor")
class PrintActionExecutor
implements ActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(PrintActionExecutor.class);
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonUiBotService commonUiBotService;

    PrintActionExecutor() {
    }

    public String supportKey() {
        return "ATMC_PRINT:";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        ExecuteResult executeResult = new ExecuteResult();
        BusinessConfig businessConfig = action.getBusinessConfig();
        if (null == businessConfig) {
            return executeResult;
        }
        data = this.convertData(data);
        StatementConfig statementConfig = this.commonUiBotService.getStatementConfig(businessConfig.getActivityId());
        if (null != statementConfig && CollectionUtils.isNotEmpty((Collection)statementConfig.getSubmitActions()) && MapUtil.isNotEmpty((Map)statementConfig.getExtendedFields())) {
            CacheDto cacheDto = this.atmcService.setBICache((SubmitAction)statementConfig.getSubmitActions().get(0), data);
            cacheDto.setResId(StringUtils.isNotBlank((CharSequence)businessConfig.getBusinessId()) ? businessConfig.getBusinessId() : String.valueOf(statementConfig.getExtendedFields().get("STATEMENT__resid_" + executeContext.getLocale())));
            executeResult.setData(BeanUtil.beanToMap((Object)cacheDto, (String[])new String[0]));
        }
        return executeResult;
    }

    private Map<String, Object> convertData(Map<String, Object> data) {
        HashMap<String, Object> dataNew = new HashMap<String, Object>();
        for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
            if (!(dataEntry.getValue() instanceof Map)) continue;
            ArrayList<Object> o = new ArrayList<Object>();
            o.add(dataEntry.getValue());
            dataNew.put(dataEntry.getKey(), o);
        }
        if (MapUtils.isNotEmpty(dataNew)) {
            data = dataNew;
        }
        return data;
    }
}

