/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Order(value=100)
@Service(value="ptmUpdateBpmDataActionExecutor")
class PtmUpdateBpmDataActionExecutor
extends TaskEngineActionExecutorBase {
    private static final Logger log = LoggerFactory.getLogger(PtmUpdateBpmDataActionExecutor.class);
    @Autowired
    private CommonPtmService commonPtmService;
    @Autowired
    private CommonAtmcService atmcService;

    PtmUpdateBpmDataActionExecutor() {
    }

    public String supportKey() {
        return "TaskEngine:update-data";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        Map bpmData = executeContext.getBpmData();
        this.setUpdateData(action, parameter, bpmData);
        SubmitAction newAction = this.translateAction(executeContext, action, bpmData);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        this.commonPtmService.execute((Action)newAction);
        return result;
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        if (BooleanUtils.isNotTrue((Boolean)executeContext.isMinSplit()) || actionExecuteReq.getWorkItemIdToData() == null) {
            return super.execute(actionExecuteReq);
        }
        Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        Map workItemIdToBpmData = submitExecuteContext.getWorkItemIdToBpmData();
        ArrayList parasData = Lists.newArrayListWithExpectedSize((int)workItemIdToData.size());
        workItemIdToData.forEach((k, v) -> {
            HashMap<String, Object> paras = new HashMap<String, Object>();
            paras.put("id", k);
            Map bpmData = (Map)workItemIdToBpmData.get(k);
            if (bpmData != null) {
                paras.put("data", bpmData);
            }
            parasData.add(paras);
        });
        SubmitAction submitAction = actionExecuteReq.getAction();
        for (Map parasDatum : parasData) {
            SubmitAction action = new SubmitAction();
            action.setParas(parasDatum);
            ActionServiceId serviceId = new ActionServiceId();
            serviceId.setName(submitAction.getServiceId().getName());
            serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
            action.setServiceId(serviceId);
            this.commonPtmService.execute((Action)action);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private void setUpdateData(SubmitAction action, Map<String, Object> parameter, Map<String, Object> bpmData) {
        if (action.getParas() == null) {
            action.setParas(new HashMap());
        }
        if (!CollectionUtils.isEmpty(parameter) && !CollectionUtils.isEmpty((Collection)action.getActionParams())) {
            for (ActionParameterMapping act : action.getActionParams()) {
                if (StringUtils.isEmpty((Object)act.getValue()) || !parameter.containsKey(act.getValue())) continue;
                bpmData.put(act.getValue(), parameter.get(act.getValue()));
                bpmData.put("_in", parameter.get(act.getValue()));
                break;
            }
        }
    }

    private SubmitAction translateAction(SubmitExecuteContext executeContext, SubmitAction submitAction, Map<String, Object> bpmData) {
        SubmitAction action = new SubmitAction();
        Map ptmData = executeContext.getPtmData();
        if (ptmData == null) {
            ptmData = this.atmcService.getPtmData(executeContext.getBacklogId());
        }
        HashMap paras = new HashMap();
        paras.put("id", ptmData.get("ptmWorkItemId"));
        paras.put("data", bpmData);
        action.setParas(paras);
        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(submitAction.getServiceId().getName());
        serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
        action.setServiceId(serviceId);
        return action;
    }
}

