/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.executor.MergeDataActionExecutor;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.util.ActivityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=100)
@Service(value="taskEngineDispatchActionExecutor")
class TaskEngineDispatchActionExecutor
extends MergeDataActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(TaskEngineDispatchActionExecutor.class);
    public static final String DISPATCH_ACTION_ID = "dispatch";
    @Autowired
    private CommonPtmService taskEngineService;

    TaskEngineDispatchActionExecutor() {
    }

    public String supportKey() {
        return "TaskEngine:dispatch";
    }

    public boolean supportRetry() {
        return true;
    }

    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        this.execute(action, parameter);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        ObjectMapper objectMapper = new ObjectMapper();
        SubmitAction cloneAction = null;
        try {
            cloneAction = (SubmitAction)objectMapper.readValue(objectMapper.writeValueAsString((Object)action), SubmitAction.class);
            cloneAction.setMergeDataAction(action.getMergeDataAction());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        SubmitAction mergeAction = action;
        if (action != action.getMergeDataAction()) {
            mergeAction = action.getMergeDataAction();
        }
        List<SubmitAction> combineActions = new ArrayList<SubmitAction>();
        if (mergeAction.getExtendParas() != null && mergeAction.getExtendParas().containsKey("mergedSubmitData")) {
            combineActions = (List)mergeAction.getExtendParas().get("mergedSubmitData");
            combineActions.add(cloneAction);
        } else {
            combineActions.add(cloneAction);
            if (mergeAction.getExtendParas() == null) {
                mergeAction.setExtendParas(new HashMap());
            }
            mergeAction.getExtendParas().put("mergedSubmitData", combineActions);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(false);
        return result;
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        ExecuteResult result = ExecuteResult.ok();
        List combineActions = (List)action.getExtendParas().get("mergedSubmitData");
        if (CollectionUtils.isEmpty((Collection)combineActions)) {
            log.info("[executeMergedData] combine actions is empty ,action is {}", (Object)action);
            return result;
        }
        for (SubmitAction submitAction : combineActions) {
            this.execute(submitAction, parameter);
        }
        result.setCompleted(true);
        return result;
    }

    private void execute(SubmitAction action, Map<String, Object> parameter) {
        this.setProcessVariables(action, parameter);
        if (parameter.size() > 0) {
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (stringObjectEntry.getKey().startsWith("uibot")) continue;
                if (stringObjectEntry.getValue() instanceof Collection) {
                    action.getParas().put("dispatchData", stringObjectEntry.getValue());
                    break;
                }
                ArrayList<Map.Entry<String, Object>> dispatchData = new ArrayList<Map.Entry<String, Object>>();
                dispatchData.add(stringObjectEntry);
                action.getParas().put("dispatchData", dispatchData);
                break;
            }
        }
        this.taskEngineService.execute((Action)action);
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext.isMinSplit()) {
            SubmitAction action = actionExecuteReq.getAction();
            Map paras = action.getParas();
            paras.put("workItemDataIdList", ActivityUtils.getMinSplitWorkItemIds((ActionExecuteReq)actionExecuteReq));
            ActionServiceId serviceId = action.getServiceId();
            if (serviceId != null) {
                serviceId.setServiceUri("api/task/card/min/split/dispatch");
            }
            this.taskEngineService.execute((Action)action);
            ExecuteResult result = ExecuteResult.ok();
            result.setCompleted(true);
            return result;
        }
        return super.execute(actionExecuteReq);
    }
}

