/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.service.BaseActionCreateService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=20)
@Service(value="update-table-field")
class UpdateTableFieldActionExecutor
implements ActionExecutor {
    @Autowired
    private CommonESPService commonEspService;
    @Autowired
    BaseActionCreateService submitBaseActionCreateService;
    @Autowired
    private CommonThemeMapQueryService commonThemeMapQueryService;
    @Autowired
    private MessageUtils messageUtils;

    UpdateTableFieldActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:update-table-field";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        boolean isBatchSubmit;
        Map<String, Object> paras;
        Map extendParas = action.getExtendParas();
        if (!(!MapUtils.isEmpty((Map)extendParas) && extendParas.containsKey("updateValue") && extendParas.containsKey("table") && extendParas.containsKey("dataKeys") && extendParas.containsKey("submitVariableName") && extendParas.containsKey("isBatchSubmit"))) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0010.getErrCode(), (String)this.messageUtils.getMessage("exception.update.field.action.lack.config"));
        }
        String table = extendParas.get("table").toString();
        Object updateValue = extendParas.get("updateValue");
        String dataKeys = extendParas.get("dataKeys").toString();
        String submitVariableName = extendParas.get("submitVariableName").toString();
        if (!parameter.containsKey(submitVariableName)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0010.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data") + submitVariableName + this.messageUtils.getMessage("exception.check.KG.config")));
        }
        List datas = (List)parameter.get(submitVariableName);
        String detailField = null;
        if (extendParas.containsKey("detailField")) {
            detailField = extendParas.get("detailField").toString();
        }
        List conditions = null;
        if (extendParas.containsKey("condition")) {
            conditions = (List)extendParas.get("condition");
        }
        if ((paras = this.createSubmitParas(table, dataKeys, conditions, updateValue, datas, isBatchSubmit = BooleanUtils.toBoolean((String)extendParas.get("isBatchSubmit").toString()), detailField)) == null) {
            return ExecuteResult.ok();
        }
        String tenantId = "";
        tenantId = StringUtils.hasText((String)action.getExecuteContext().getProxyToken()) ? action.getExecuteContext().getTenantId() : action.getExecuteContext().getAuthoredUser().getTenantId();
        TmAction tmAction = this.createTmAction(tenantId);
        SubmitAction submitAction = this.submitBaseActionCreateService.createSubmitAction(tmAction, tenantId, action.getExecuteContext().getBusinessUnit());
        submitAction.setParas(paras);
        this.commonEspService.execute(executeContext, (Action)submitAction);
        return ExecuteResult.ok();
    }

    private TmAction createTmAction(String tenantId) {
        TmAction tmAction = new TmAction();
        tmAction.setServiceName("fields.value.update");
        tmAction.setType("ESP");
        tmAction.setActionId("esp_fields.value.update");
        ActionInfo actionInfo = this.commonThemeMapQueryService.getActionInfo(tenantId, tmAction.getActionId());
        if (actionInfo != null) {
            tmAction.setProductName(actionInfo.getProductName());
            tmAction.setUrl(actionInfo.getUrl());
            tmAction.setServiceName(actionInfo.getServiceName());
        }
        return tmAction;
    }

    private Map<String, Object> createSubmitParas(String table, String dataKeys, List<Map<String, String>> conditions, Object updateValue, List<Map<String, Object>> datas, boolean isBatch, String detailField) {
        ArrayList dataList = new ArrayList();
        String[] dataKeyArray = dataKeys.split(";");
        ArrayList<Object> needUpdateDatas = new ArrayList<Object>();
        if (isBatch) {
            for (Map<String, Object> map : datas) {
                boolean uibotChecked;
                boolean bl = uibotChecked = map.get("uibot_checked") == null ? false : BooleanUtils.toBoolean((String)map.get("uibot_checked").toString());
                if (uibotChecked) {
                    needUpdateDatas.add(map);
                }
                if (detailField == null || map.get(detailField) == null) continue;
                List detail = (List)map.get(detailField);
                Iterator iterator = detail.iterator();
                while (iterator.hasNext()) {
                    Map map2 = (Map)iterator.next();
                    boolean targetDetailFieldValueUibotChecked = map2.get("uibot_checked") == null ? false : BooleanUtils.toBoolean((String)map2.get("uibot_checked").toString());
                    if (!targetDetailFieldValueUibotChecked) continue;
                    needUpdateDatas.add(map2);
                }
            }
        } else {
            for (Map<String, Object> map : datas) {
                needUpdateDatas.add(map);
                if (detailField == null || map.get(detailField) == null) continue;
                List detail = (List)map.get(detailField);
                for (Object detailItem : detail) {
                    needUpdateDatas.add(detailItem);
                }
            }
        }
        for (Map<String, Object> map : needUpdateDatas) {
            int i;
            HashMap<String, Object> update = new HashMap<String, Object>();
            update.put("doc_table", table);
            if (conditions != null && conditions.size() > 0) {
                i = 1;
                for (Map map3 : conditions) {
                    if (!map3.containsKey("field") || !map3.containsKey("value")) {
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0009.getErrCode(), (String)this.messageUtils.getMessage("exception.condition.need.field.value"));
                    }
                    String field = (String)map3.get("field");
                    String value = (String)map3.get("value");
                    String type = map3.getOrDefault("type", "DATA_ROW");
                    if ("DATA_ROW".equals(type)) {
                        if (map.containsKey(value)) {
                            String keyValue = map.get(value) == null ? "" : map.get(value).toString();
                            update.put("condition" + i + "_field", field);
                            update.put("condition" + i + "_field_value", keyValue);
                        }
                    } else if ("CONSTANT".equals(type)) {
                        update.put("condition" + i + "_field", field);
                        update.put("condition" + i + "_field_value", value);
                    }
                    ++i;
                }
            } else {
                for (i = 0; i < dataKeyArray.length; ++i) {
                    String key = dataKeyArray[i];
                    if (!map.containsKey(key)) continue;
                    String string = map.get(key) == null ? "" : map.get(key).toString();
                    update.put("condition" + (i + 1) + "_field", key);
                    update.put("condition" + (i + 1) + "_field_value", string);
                }
            }
            update.put("update_detail", updateValue);
            dataList.add(update);
        }
        if (dataList.size() == 0) {
            return null;
        }
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("doc_data", dataList);
        return paras;
    }
}

