/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=50)
@Service(value="update-task-trace-state")
class UpdateTaskTraceStateActionExecutor
implements ActionExecutor {
    @Autowired
    CommonAtmcService atmcService;
    @Autowired
    MessageUtils messageUtils;

    UpdateTaskTraceStateActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:update-task-trace-state";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        JSONObject stateData;
        Map extendParas = action.getExtendParas();
        this.check(extendParas);
        String detailField = null;
        if (extendParas.containsKey("detailField")) {
            detailField = extendParas.get("detailField").toString();
        }
        if ((stateData = this.createParas(parameter, MapUtils.getString((Map)extendParas, (Object)"processVariableName"), MapUtils.getString((Map)extendParas, (Object)"submitVariableName"), detailField, MapUtils.getString((Map)extendParas, (Object)"dataKeys"))) == null) {
            return ExecuteResult.ok();
        }
        String backlogId = action.getExecuteContext().getBacklogId().toString();
        this.atmcService.setBpmActivityStateData(backlogId, (Map)stateData);
        return ExecuteResult.ok();
    }

    private void check(Map<String, Object> extendParas) {
        if (MapUtils.isEmpty(extendParas) || !extendParas.containsKey("dataKeys") || !extendParas.containsKey("processVariableName") || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0025.getErrCode(), (String)this.messageUtils.getMessage("exception.update.field.action.lack.config2"));
        }
    }

    private JSONObject createParas(Map<String, Object> parameter, String processVariableName, String submitVariableName, String detailField, String dataKeys) {
        if (!parameter.containsKey(submitVariableName)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0026.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data") + submitVariableName + this.messageUtils.getMessage("exception.check.KG.config")));
        }
        List datas = (List)parameter.get(submitVariableName);
        if (datas.size() == 0) {
            return null;
        }
        ArrayList<Map> needUpdateDatas = new ArrayList<Map>();
        for (Map data : datas) {
            boolean hasDetail = false;
            if (detailField != null && data.get(detailField) != null) {
                List detail = (List)data.get(detailField);
                for (Map detailItem : detail) {
                    needUpdateDatas.add(detailItem);
                    hasDetail = true;
                }
            }
            if (hasDetail) continue;
            needUpdateDatas.add(data);
        }
        JSONObject stateData = new JSONObject();
        JSONArray processVariableValue = new JSONArray();
        stateData.put((Object)"dataKeys", (Object)dataKeys);
        stateData.put((Object)"originalQueryVariableName", (Object)processVariableName);
        String[] dataKeyList = dataKeys.split(";");
        for (Map needUpdateData : needUpdateDatas) {
            JSONObject item = new JSONObject();
            for (String key : dataKeyList) {
                item.put((Object)key, needUpdateData.get(key));
            }
            item.put((Object)"state", (Object)0);
            processVariableValue.add((Object)item);
        }
        stateData.put((Object)processVariableName, (Object)processVariableValue);
        return stateData;
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext.isMinSplit()) {
            // empty if block
        }
        return super.execute(actionExecuteReq);
    }
}

