/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.seata.JaGlobalTransactionalTemplate;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEvent;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEventDTO;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.log.LogRecordDTO;
import com.digiwin.athena.atdm.log.LogRecordEvent;
import com.google.common.eventbus.AsyncEventBus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class MergeActionExecuteService {
    private static final Logger log = LoggerFactory.getLogger(MergeActionExecuteService.class);
    private static final List<String> ACTION_LIST = Arrays.asList("submit-data", "dispatch", "reexecute", "agree", "disagree", "reassign", "reapprove", "add-task", "terminate-task", "filter-selected-data-action", "submit-data", "recycle.delete", "recycle.deleteAll", "commit-data-to-fi", "update-activity-query-variable-value", "update-task-trace-state", "terminate-process", "manual-reassign", "update-data");
    private static final String MERGE_TASK_URL = "/api/atdm/v1/action/submit/mergeTask";
    private static final ThreadLocal<Boolean> SEATA_TM_ACTIVITY_ID_HOLDER = new ThreadLocal();
    @Autowired
    DataSubmissionService dataSubmissionService;
    @Autowired
    private AsyncEventBus asyncEventBus;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    CommonAtmcService atmcService;

    public List<ExecuteResult> submit(int maxDepath, List<SubmitExecuteContext> executeContext, SubmitAction action, List<Map<String, Object>> data) throws Throwable {
        ArrayList<ExecuteResult> executeResultList = new ArrayList<ExecuteResult>();
        List actionList = action.getActionList();
        LogDto logDto = new LogDto("\u6267\u884ccore action\u5f00\u59cb\uff0cactionId\uff1a" + ((SubmitAction)actionList.get(0)).getActionId(), executeContext.get(0).getTenantId() + ";" + executeContext.get(0).getBacklogId());
        log.info(logDto.toString());
        JaGlobalTransactionalTemplate.handleGlobalTransaction(null, () -> this.recurrentAction(maxDepath, executeContext, data, actionList, executeResultList), () -> this.checkActionIsExecuteSeata(((SubmitAction)actionList.get(0)).getCategory(), ((SubmitExecuteContext)executeContext.get(0)).getTmActivityId()));
        if (action.getActionList().stream().anyMatch(this.dataSubmissionService::isSupportSubmitMergeData) && CollectionUtils.isNotEmpty(executeResultList) && !((ExecuteResult)executeResultList.get(0)).getExecuteState().booleanValue()) {
            this.dataSubmissionService.executeCoreWapper(executeContext.get(0), null, (SubmitAction)actionList.get(0), data.get(0));
        }
        LogDto logDtoEnd = new LogDto("\u6267\u884ccore action\u7ed3\u675f\uff0cactionId\uff1a" + ((SubmitAction)actionList.get(0)).getActionId(), executeContext.get(0).getTenantId() + ";" + executeContext.get(0).getBacklogId());
        log.info(logDtoEnd.toString());
        if (CollectionUtils.isNotEmpty((Collection)action.getAttachActions())) {
            ArrayList taskEngineAction = new ArrayList();
            ArrayList afterCheckCompletedActions = new ArrayList();
            action.getAttachActions().forEach(t -> {
                if (t.getActionList().stream().anyMatch(SubmitAction::isDispatchAction)) {
                    taskEngineAction.add(t);
                }
                if (t.getActionList().stream().anyMatch(n -> Boolean.TRUE.equals(n.getExecuteAfterCheckCompleted()))) {
                    afterCheckCompletedActions.add(t);
                }
            });
            for (SubmitAction attachAction : action.getAttachActions()) {
                if (((SubmitAction)attachAction.getActionList().get(0)).isDispatchAction() || Boolean.TRUE.equals(((SubmitAction)attachAction.getActionList().get(0)).getExecuteAfterCheckCompleted())) continue;
                LogDto logDtoAttach = new LogDto("\u6267\u884cattach action\u5f00\u59cb\uff0cbacklogId\uff1a" + executeContext.get(0).getBacklogId(), executeContext.get(0).getTenantId() + ";" + executeContext.get(0).getBacklogId());
                log.info(logDtoAttach.toString());
                this.executeAttachAction(maxDepath, null, executeContext, action, executeResultList, attachAction, data);
                LogDto logDtoAttachEnd = new LogDto("\u6267\u884cattach action\u7ed3\u675f\uff0cbacklogId\uff1a" + executeContext.get(0).getBacklogId(), executeContext.get(0).getTenantId() + ";" + executeContext.get(0).getBacklogId());
                log.info(logDtoAttachEnd.toString());
            }
            if (!taskEngineAction.isEmpty()) {
                this.setIsCompleted(executeContext, action, executeResultList);
                HashSet<Integer> excludeList = new HashSet<Integer>(executeResultList.size());
                for (int i = 0; i < executeResultList.size(); ++i) {
                    if (((ExecuteResult)executeResultList.get(i)).isCompleted()) continue;
                    excludeList.add(i);
                }
                if (CollectionUtils.isNotEmpty(afterCheckCompletedActions)) {
                    for (SubmitAction attachAction : afterCheckCompletedActions) {
                        this.executeAttachAction(maxDepath, excludeList, executeContext, action, executeResultList, attachAction, data);
                    }
                }
                this.executeAttachAction(maxDepath, excludeList, executeContext, action, executeResultList, (SubmitAction)taskEngineAction.get(0), data);
            }
        } else if (action.getActionList().stream().anyMatch(SubmitAction::isDispatchAction)) {
            this.setIsCompleted(executeContext, action, executeResultList);
        }
        try {
            for (int i = 0; i < maxDepath; ++i) {
                if (null != executeContext.get(i).getTaskType() && executeContext.get(i).getTaskType() == 89) continue;
                DataUniformityEventDTO dataUniformityEventDTO = new DataUniformityEventDTO();
                dataUniformityEventDTO.setBacklogId(executeContext.get(i).getBacklogId());
                dataUniformityEventDTO.setRequestData(((ExecuteResult)executeResultList.get(i)).getRequestData());
                dataUniformityEventDTO.setTmActivityId(executeContext.get(i).getTmActivityId());
                DataUniformityEvent dataUniformityEvent = new DataUniformityEvent(dataUniformityEventDTO, executeContext.get(i).getOperateAuthoredUser());
                this.asyncEventBus.post((Object)dataUniformityEvent);
            }
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u6570\u636e\u6bd4\u5bf9\u4ee5\u53ca\u5220\u9664\u4fa6\u6d4bEventBus\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return executeResultList;
    }

    private Boolean checkActionIsExecuteSeata(String category, String tmActivityId) {
        Boolean isSeataActivityCode = SEATA_TM_ACTIVITY_ID_HOLDER.get();
        if (null == isSeataActivityCode) {
            isSeataActivityCode = this.atmcService.operationConfig("SEATA_WHITE_LIST_" + tmActivityId, Integer.valueOf(0), "SEATA_WHITE_LIST");
            SEATA_TM_ACTIVITY_ID_HOLDER.set(isSeataActivityCode);
        }
        return "ESP".equals(category) && isSeataActivityCode != false;
    }

    private int recurrentAction(int maxDepath, List<SubmitExecuteContext> executeContext, List<Map<String, Object>> data, List<SubmitAction> actionList, List<ExecuteResult> executeResultList) {
        for (int i = 0; i < maxDepath; ++i) {
            ExecuteResult executeResult = this.dataSubmissionService.executeCoreWapper(executeContext.get(i), null, actionList.get(i), data.get(i));
            HashMap<String, Long> extendResult = new HashMap<String, Long>();
            extendResult.put("backlogId", executeContext.get(i).getBacklogId());
            executeResult.setExtendResult(extendResult);
            executeResultList.add(MergeActionExecuteService.deepCopy(executeResult, ExecuteResult.class));
            executeContext.get(i).setParentAction(actionList.get(i));
        }
        return 1;
    }

    private void setIsCompleted(List<SubmitExecuteContext> executeContext, SubmitAction action, List<ExecuteResult> executeResult) {
        List actionList = action.getActionList();
        for (int i = 0; i < actionList.size(); ++i) {
            DataSourceBase dataSourceBase;
            QueryResult queryResult;
            if (((SubmitAction)actionList.get(i)).getCheckCompleteAction() == null) {
                executeResult.get(i).setCompleted(true);
                continue;
            }
            executeResult.get(i).setCompleted((queryResult = (dataSourceBase = DataSourceConverter.convert((DataSourceDTO)((SubmitAction)actionList.get(i)).getCheckCompleteAction(), (boolean)false)).query(ExecuteContext.fromSubmitExecuteContent((SubmitExecuteContext)executeContext.get(i)), null, null, null, null)).size() == 0);
        }
    }

    private void executeAttachAction(int maxDepath, Set<Integer> index, List<SubmitExecuteContext> executeContext, SubmitAction parentAction, List<ExecuteResult> parentExecuteResult, SubmitAction attachAction, List<Map<String, Object>> submitData) throws Throwable {
        ArrayList<ExecuteResult> attachActionExecuteResultList = new ArrayList<ExecuteResult>();
        List parentActionList = parentAction.getActionList();
        JaGlobalTransactionalTemplate.handleGlobalTransaction(null, () -> this.recurrentAttachAction(maxDepath, index, executeContext, parentExecuteResult, attachAction, submitData, parentActionList, attachActionExecuteResultList), () -> this.checkActionIsExecuteSeata(((SubmitAction)attachAction.getActionList().get(0)).getCategory(), ((SubmitExecuteContext)executeContext.get(0)).getTmActivityId()));
        if (attachAction.getActionList().stream().anyMatch(this.dataSubmissionService::isSupportSubmitMergeData) && CollectionUtils.isNotEmpty(attachActionExecuteResultList) && !((ExecuteResult)attachActionExecuteResultList.get(0)).getExecuteState().booleanValue()) {
            this.dataSubmissionService.executeCoreWapper(executeContext.get(0), null, (SubmitAction)attachAction.getActionList().get(0), submitData.get(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)attachAction.getAttachActions())) {
            for (SubmitAction attachAttachAction : attachAction.getAttachActions()) {
                if (attachAction.getActionList().stream().anyMatch(t -> "WF".equals(t.getCategory()) || "TaskEngine".equals(t.getCategory()))) continue;
                this.executeAttachAction(maxDepath, index, executeContext, attachAction, attachActionExecuteResultList, attachAttachAction, submitData);
            }
        }
    }

    private int recurrentAttachAction(int maxDepath, Set<Integer> index, List<SubmitExecuteContext> executeContext, List<ExecuteResult> parentExecuteResult, SubmitAction attachAction, List<Map<String, Object>> submitData, List<SubmitAction> parentActionList, List<ExecuteResult> attachActionExecuteResultList) {
        for (int i = 0; i < maxDepath; ++i) {
            if (CollectionUtils.isNotEmpty(index) && index.contains(i)) continue;
            Map<String, Object> parentConvertedData = parentExecuteResult.get(i).getRequestData();
            Map parentResponseData = parentExecuteResult.get(i).getData();
            ((SubmitAction)attachAction.getActionList().get(i)).setBusinessUnit(parentActionList.get(i).getBusinessUnit());
            if (null != parentActionList.get(i).getServiceId()) {
                ((SubmitAction)attachAction.getActionList().get(i)).getServiceId().setProxyToken(parentActionList.get(i).getServiceId().getProxyToken());
            }
            String dataFrom = "";
            if (((SubmitAction)attachAction.getActionList().get(i)).getExtendParas() != null && ((SubmitAction)attachAction.getActionList().get(i)).getExtendParas().containsKey("dataSource")) {
                dataFrom = ((SubmitAction)attachAction.getActionList().get(i)).getExtendParas().get("dataSource").toString();
            }
            Map<String, Object> convertedData = null;
            switch (dataFrom) {
                case "parent": 
                case "parentRequest": {
                    convertedData = parentConvertedData;
                    break;
                }
                case "submit": {
                    convertedData = submitData.get(i);
                    break;
                }
                case "parentAndParentResponse": {
                    convertedData = parentConvertedData;
                    if (parentResponseData == null) break;
                    for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                        convertedData.put((String)stringListEntry.getKey(), stringListEntry.getValue());
                    }
                    break;
                }
                case "submitWithParentResponse": 
                case "parentResponse": {
                    convertedData = submitData.get(i);
                    if (parentResponseData == null) break;
                    for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                        convertedData.put((String)stringListEntry.getKey(), stringListEntry.getValue());
                    }
                    break;
                }
                default: {
                    convertedData = submitData.get(i);
                }
            }
            executeContext.get(i).setParentAction(parentActionList.get(i));
            ExecuteResult attachActionExecuteResult = this.dataSubmissionService.executeCoreWapper(executeContext.get(i), parentExecuteResult.get(i), (SubmitAction)attachAction.getActionList().get(i), convertedData);
            attachActionExecuteResultList.add(attachActionExecuteResult);
        }
        return 1;
    }

    private void setExecuteContext(int depath, HttpServletRequest request, SubmitAction taskAction, SubmitExecuteContext parentExecuteContext) {
        SubmitAction submitAction = (SubmitAction)taskAction.getActionList().get(depath);
        SubmitExecuteContext executeContext = submitAction.getExecuteContext();
        if (executeContext == null) {
            executeContext = parentExecuteContext;
            submitAction.setExecuteContext(parentExecuteContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskAction.getAttachActions())) {
            List attachActions = taskAction.getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                this.setExecuteContext(depath, request, attachAction, executeContext);
            }
        }
    }

    private void findSupportSubmitMergeDataActions(List<SubmitAction> list, SubmitAction taskAction) {
        if (taskAction.getActionList().stream().anyMatch(t -> this.dataSubmissionService.isSupportSubmitMergeData((SubmitAction)t))) {
            list.add(taskAction);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskAction.getAttachActions())) {
            for (SubmitAction attachAction : taskAction.getAttachActions()) {
                this.findSupportSubmitMergeDataActions(list, attachAction);
            }
        }
    }

    private Collection<SubmitAction> initSubmitMergeDataActions(List<SubmitAction> mergeDataActions) {
        if (CollectionUtils.isEmpty(mergeDataActions)) {
            return mergeDataActions;
        }
        LinkedHashMap<String, SubmitAction> firstActions = new LinkedHashMap<String, SubmitAction>();
        for (SubmitAction action : mergeDataActions) {
            for (SubmitAction submitAction : action.getActionList()) {
                if (!firstActions.containsKey(submitAction.getActionId())) {
                    firstActions.put(submitAction.getActionId(), submitAction);
                }
                submitAction.setMergeDataAction((SubmitAction)firstActions.get(submitAction.getActionId()));
            }
        }
        return firstActions.values();
    }

    public List<ExecuteResult> executeMergeActionWapper(HttpServletRequest request, List<SubmitActionDTO> submitActionList) throws Throwable {
        MergeSubmitActionDTO mergeSubmitAction = null;
        try {
            mergeSubmitAction = MergeActionExecuteService.getMergeSubmitAction(submitActionList);
            List<ExecuteResult> list = this.executeMergeAction(request, mergeSubmitAction);
            return list;
        }
        catch (Throwable e) {
            if (mergeSubmitAction != null && MergeActionExecuteService.checkMergeExecute(submitActionList.get(0).getAction())) {
                this.logRecord(request, mergeSubmitAction);
            }
            throw e;
        }
        finally {
            SEATA_TM_ACTIVITY_ID_HOLDER.remove();
        }
    }

    public List<ExecuteResult> executeMergeAction(HttpServletRequest request, MergeSubmitActionDTO mergeSubmitAction) throws Throwable {
        ArrayList<ExecuteResult> resultList = new ArrayList();
        log.info("start to deal find support submit merge data action start");
        ArrayList<SubmitAction> mergeDataActions = new ArrayList<SubmitAction>();
        SubmitAction actionMerge = mergeSubmitAction.getActionMerge();
        List dataMerge = mergeSubmitAction.getDataMerge();
        this.findSupportSubmitMergeDataActions(mergeDataActions, actionMerge);
        log.info("start to deal find support submit merge data action end");
        this.initSubmitMergeDataActions(mergeDataActions);
        log.info("init submit merge data action end");
        int maxDepath = actionMerge.getActionList().size();
        ArrayList<SubmitExecuteContext> submitExecuteContextList = new ArrayList<SubmitExecuteContext>();
        String backlogId = "";
        String tenantId = "";
        for (int i = 0; i < maxDepath; ++i) {
            SubmitAction taskAction = (SubmitAction)actionMerge.getActionList().get(i);
            SubmitExecuteContext executeContext = taskAction.getExecuteContext();
            if (executeContext == null) {
                executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            }
            if (StringUtils.hasText((String)executeContext.getProxyToken())) {
                AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
            }
            executeContext.setOperateAuthoredUser(mergeSubmitAction.getOperateAuthoredUser());
            this.setExecuteContext(i, request, actionMerge, executeContext);
            submitExecuteContextList.add(executeContext);
            backlogId = String.valueOf(executeContext.getBacklogId());
            tenantId = mergeSubmitAction.getOperateAuthoredUser() == null ? "" : mergeSubmitAction.getOperateAuthoredUser().getTenantId();
        }
        LogDto logDto = new LogDto("\u6267\u884caction\u5f00\u59cb\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
        log.info(logDto.toString());
        resultList = this.submit(maxDepath, submitExecuteContextList, actionMerge, dataMerge);
        LogDto logDtoEnd = new LogDto("\u6267\u884caction\u7ed3\u675f\uff0cbacklogId\uff1a" + backlogId, tenantId + ";" + backlogId);
        log.info(logDtoEnd.toString());
        return resultList;
    }

    public static MergeSubmitActionDTO getMergeSubmitAction(List<SubmitActionDTO> submitActionDTOS) {
        SubmitAction mergedTree = MergeActionExecuteService.mergeMultipleTrees(submitActionDTOS.stream().map(SubmitActionDTO::getAction).collect(Collectors.toList()));
        MergeSubmitActionDTO mergeSubmitActionDTO = new MergeSubmitActionDTO();
        mergeSubmitActionDTO.setActionMerge(mergedTree);
        mergeSubmitActionDTO.setDataMerge(submitActionDTOS.stream().map(SubmitActionDTO::getData).collect(Collectors.toList()));
        mergeSubmitActionDTO.setOperateAuthoredUser(submitActionDTOS.get(0).getOperateAuthoredUser());
        return mergeSubmitActionDTO;
    }

    private static <T extends Serializable> T deepCopy(T value, Class<T> valueType) {
        try {
            return (T)SerializationUtils.clone(value);
        }
        catch (Exception e) {
            try {
                return (T)((Serializable)JsonUtils.jsonToObject((String)JsonUtils.objectToString(value), valueType));
            }
            catch (Exception exception) {
                throw BusinessException.create((String)"\u53c2\u6570\u62f7\u8d1d\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static SubmitAction mergeMultipleTrees(List<SubmitAction> treesToMerge) {
        SubmitAction mergedTree = new SubmitAction();
        ArrayList<SubmitAction> actionList = new ArrayList<SubmitAction>();
        for (SubmitAction tree : treesToMerge) {
            SubmitAction submitAction = MergeActionExecuteService.deepCopy(tree, SubmitAction.class);
            submitAction.setAttachActions(null);
            actionList.add(submitAction);
        }
        mergedTree.setActionList(actionList);
        ArrayList<SubmitAction> mergedAttachActions = new ArrayList<SubmitAction>();
        int maxDepth = 0;
        if (CollectionUtils.isNotEmpty((Collection)treesToMerge.get(0).getAttachActions())) {
            maxDepth = treesToMerge.get(0).getAttachActions().size();
        }
        for (int i = 0; i < maxDepth; ++i) {
            ArrayList<SubmitAction> subtreeList = new ArrayList<SubmitAction>();
            for (SubmitAction tree : treesToMerge) {
                if (!CollectionUtils.isNotEmpty((Collection)tree.getAttachActions()) || tree.getAttachActions().size() <= i) continue;
                subtreeList.add((SubmitAction)tree.getAttachActions().get(i));
            }
            mergedAttachActions.add(MergeActionExecuteService.mergeMultipleTrees(subtreeList));
        }
        mergedTree.setAttachActions(mergedAttachActions);
        return mergedTree;
    }

    public static boolean checkMergeExecute(SubmitAction submitAction) {
        if (!submitAction.getCategory().equals("ESP") && !ACTION_LIST.contains(submitAction.getActionId())) {
            return false;
        }
        return MergeActionExecuteService.recursiveCheckMergeExecute(submitAction.getAttachActions());
    }

    public static boolean recursiveCheckMergeExecute(List<SubmitAction> attachActions) {
        for (SubmitAction submitAction : attachActions) {
            if (!submitAction.getCategory().equals("ESP") && !ACTION_LIST.contains(submitAction.getActionId())) {
                return false;
            }
            if (!CollectionUtils.isNotEmpty((Collection)submitAction.getAttachActions())) continue;
            return MergeActionExecuteService.recursiveCheckMergeExecute(submitAction.getAttachActions());
        }
        return true;
    }

    public void logRecord(HttpServletRequest request, MergeSubmitActionDTO submitAction) {
        try {
            LogRecordDTO logRecordDTO = new LogRecordDTO();
            logRecordDTO.setInputValue(JsonUtils.objectToString((Object)submitAction));
            logRecordDTO.setCreateTime(new Date());
            logRecordDTO.setUrl(MERGE_TASK_URL);
            LogRecordEvent logRecordEvent = new LogRecordEvent(request, logRecordDTO, submitAction.getOperateAuthoredUser());
            this.asyncEventBus.post((Object)logRecordEvent);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7EventBus\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

