/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.action.executor.AttachmentActionExecutor;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.action.util.ActionUtils;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DataSubmissionServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(DataSubmissionServiceWrapper.class);
    public static final Integer MAX_COMMIT_SIZE = 2000;
    public static final String WHITE_LIST = "submitActivityIdWhiteList";
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private DataSubmissionService dataSubmissionService;
    @Autowired
    private AsyncEventBus asyncEventBus;

    public ExecuteResult executeActionSubmit(HttpServletRequest request, SubmitActionDTO submitAction) {
        this.actionCheck(request, submitAction);
        AttachmentActionExecutor.preprocessApiAttachment(Lists.newArrayList((Object[])new SubmitActionDTO[]{submitAction}));
        SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
        SubmitAction action = submitAction.getAction();
        Map data = submitAction.getData();
        log.info("actionExecuteService.submit start");
        return this.dataSubmissionService.submit(new ActionExecuteReq(executeContext, null, action, data, submitAction.getWorkItemIdToData()));
    }

    private void actionCheck(HttpServletRequest request, SubmitActionDTO submitAction) {
        SubmitAction action;
        if (submitAction.getAction() == null) {
            throw new IllegalArgumentException("submitAction.action\u4e3anull");
        }
        if (submitAction.getData() == null) {
            throw new IllegalArgumentException("submitAction.data\u4e3anull");
        }
        SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
        if (executeContext == null) {
            executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            submitAction.getAction().setExecuteContext(executeContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        executeContext.setOperateAuthoredUser(submitAction.getOperateAuthoredUser());
        if (CollectionUtils.isNotEmpty((Collection)submitAction.getAction().getAttachActions())) {
            List attachActions = submitAction.getAction().getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                SubmitExecuteContext attachActionExecuteContext = attachAction.getExecuteContext();
                if (attachActionExecuteContext == null) {
                    attachAction.setExecuteContext(executeContext);
                    continue;
                }
                attachActionExecuteContext.appendHttpRequest(request);
            }
        }
        if ((action = submitAction.getAction()) == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        ArrayList<SubmitActionDTO> list = new ArrayList<SubmitActionDTO>();
        list.add(submitAction);
        if (!this.validateSizeOrWhiteList(list)) {
            throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0003.getErrCode(), (String)MessageUtil.getMessageByLocale((String)"submit.task.size.overflow", (String)LocaleContextHolder.getLocale().toString(), (Object[])new Object[0]));
        }
    }

    private boolean validateSizeOrWhiteList(List<SubmitActionDTO> submitActions) {
        if (this.atmcService.operationConfig(submitActions.get(0).getAction().getExecuteContext().getTmActivityId(), Integer.valueOf(0), WHITE_LIST).booleanValue()) {
            return true;
        }
        return submitActions.stream().filter(e -> e.getData() != null).noneMatch(e -> e.getData().values().stream().filter(List.class::isInstance).map(el -> (List)el).anyMatch(el -> el.size() > MAX_COMMIT_SIZE));
    }

    public ExecuteResult executeAction(HttpServletRequest request, SubmitActionDTO submitAction) {
        if (submitAction.getAction() == null) {
            throw new IllegalArgumentException("submitAction.action\u4e3anull");
        }
        if (submitAction.getData() == null) {
            throw new IllegalArgumentException("submitAction.data\u4e3anull");
        }
        if (ActionUtils.isCalendarSubmitAction(submitAction.getAction())) {
            return this.atmcService.executeCalendarAction(submitAction);
        }
        if (ActionUtils.notCommonSubmitAction(submitAction.getAction())) {
            return this.atmcService.executeAction(submitAction);
        }
        SubmitExecuteContext executeContext = submitAction.getAction().getExecuteContext();
        if (executeContext == null) {
            executeContext = SubmitExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(submitAction.getAction().getBusinessUnit());
            submitAction.getAction().setExecuteContext(executeContext);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        if (CollectionUtils.isNotEmpty((Collection)submitAction.getAction().getAttachActions())) {
            List attachActions = submitAction.getAction().getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                SubmitExecuteContext attachActionExecuteContext = attachAction.getExecuteContext();
                if (attachActionExecuteContext == null) {
                    attachAction.setExecuteContext(executeContext);
                    continue;
                }
                attachActionExecuteContext.appendHttpRequest(request);
            }
        }
        this.preExecute(executeContext, submitAction);
        return this.doExecute(executeContext, submitAction);
    }

    private ExecuteResult doExecute(SubmitExecuteContext executeContext, SubmitActionDTO submitAction) {
        return this.dataSubmissionService.execute(executeContext, submitAction.getAction(), submitAction.getData());
    }

    private void preExecute(SubmitExecuteContext executeContext, SubmitActionDTO submitAction) {
    }
}

