/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecycleSaveExecutor
implements ActionExecutor {
    @Autowired
    private CommonRecycleService commonRecycleService;

    public String supportKey() {
        return "RECYCLE:recycle.save";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        String submitVariableName = Optional.ofNullable(action.getExtendParas()).map(extendParas -> (String)extendParas.get("submitVariableName")).orElse("");
        List<Map<String, Object>> submitDataList = this.getSubmitDataList(submitVariableName, data);
        if (CollectionUtils.isEmpty(submitDataList)) {
            return ExecuteResult.ok();
        }
        for (Map<String, Object> submitData : submitDataList) {
            if (submitData.containsKey("__DATA_KEY")) continue;
            submitData.put("RECYCLE__DATA_KEY", UUID.randomUUID().toString());
        }
        this.commonRecycleService.insertRecycle(executeContext.getAuthoredUser(), executeContext.getTmActivityId(), submitDataList);
        return ExecuteResult.ok();
    }

    private List<Map<String, Object>> getSubmitDataList(String submitVariableName, Map<String, Object> data) {
        if (MapUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        Optional<Object> dataOptional = StringUtils.isNotBlank((String)submitVariableName) ? Optional.ofNullable(data.get(submitVariableName)) : data.values().stream().findFirst();
        if (dataOptional.isPresent()) {
            Object submitData = dataOptional.get();
            if (submitData instanceof Map) {
                return Collections.singletonList((Map)submitData);
            }
            return (List)submitData;
        }
        return Collections.emptyList();
    }
}

