/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.subscriber.event.ApiErrorEvent;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitType;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=0)
@Service(value="EspActionExecutor")
class EspActionExecutor
implements ActionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EspActionExecutor.class);
    @Autowired
    CommonESPService commonEspService;
    @Autowired
    private AsyncEventBus localEventBus;

    EspActionExecutor() {
    }

    public String supportKey() {
        return "ESP:";
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (action.getParas() == null) {
            action.setParas(new HashMap());
        }
        Map paras = action.getParas();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            paras.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        HashMap result = this.commonEspService.executeReturnAll(executeContext, (Action)action);
        HashMap dataMap = null;
        if (MapUtils.isNotEmpty((Map)result) && result.containsKey("data") && null != result.get("data")) {
            String schema;
            dataMap = (HashMap)result.get("data");
            SubmitType submitType = action.getSubmitType();
            if (submitType != null && StringUtils.isNotBlank((String)(schema = submitType.getSchema())) && !dataMap.containsKey(schema)) {
                for (Map.Entry returnInfo : dataMap.entrySet()) {
                    if ("error_info".equals(returnInfo.getKey()) || "success_info".equals(returnInfo.getKey())) continue;
                    dataMap.put(schema, returnInfo.getValue());
                    break;
                }
            }
        }
        ExecuteResult executeResult = ExecuteResult.withData(dataMap);
        executeResult.setCompleted(false);
        ApiErrorEvent apiErrorEvent = new ApiErrorEvent();
        apiErrorEvent.setExecuteContext(executeContext);
        apiErrorEvent.setAction(action);
        apiErrorEvent.setResult(result);
        apiErrorEvent.setDataMap(dataMap);
        this.localEventBus.post((Object)apiErrorEvent);
        AsaEvent asaEvent = new AsaEvent();
        asaEvent.setExecuteContext(executeContext);
        asaEvent.setAction(action);
        asaEvent.setResult(result);
        asaEvent.setDataMap(data);
        this.localEventBus.post((Object)asaEvent);
        return executeResult;
    }
}

