/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.activity.domain.TmDataState;
import com.digiwin.athena.atdm.activity.service.BaseActionCreateService;
import com.digiwin.athena.atdm.activity.service.BaseBpmTaskParser;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=120)
@Service(value="abort-task")
public class AbortTaskExecutor
implements ActionExecutor {
    @Autowired
    @Qualifier(value="BpmActionExecutor")
    ActionExecutor bpmDispatchAction;
    @Autowired
    @Qualifier(value="update-table-field")
    ActionExecutor updateTableFieldAction;
    @Autowired
    CommonThemeMapQueryService commonThemeMapQueryService;
    @Autowired
    BaseActionCreateService submitBaseActionCreateService;
    @Autowired
    CommonAtmcService atmcService;
    @Autowired
    @Qualifier(value="baseBpmUserTaskParser")
    private BaseBpmTaskParser bpmUserTaskParser;
    @Autowired
    @Qualifier(value="taskEngineTerminateProcessActionExecutor")
    ActionExecutor taskEngineTerminateProcessActionExecutor;

    public String supportKey() {
        return "UIBOT:abort-task";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        this.notifyAtmcAbortTask(action);
        this.executeUpdateFields(executeContext, parentExecuteResult, action, data);
        this.executeAbortTaskAction(executeContext, parentExecuteResult, action, data);
        return ExecuteResult.ok();
    }

    private void executeAbortTaskAction(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        Map processParameter = (Map)action.getExtendParas().get("processParameter");
        if (this.isFlowEngine(processParameter)) {
            SubmitAction bpmAction = new SubmitAction();
            bpmAction.setTitle(action.getTitle());
            bpmAction.setActionId(action.getActionId());
            bpmAction.setCategory("WF");
            bpmAction.setServiceId(action.getServiceId());
            bpmAction.getServiceId().setServiceUri(this.bpmUserTaskParser.getRelativeUrl(BpmServiceInvokeType.TerminateProcess));
            bpmAction.setParas((Map)action.getExtendParas().get("processParameter"));
            bpmAction.setExecuteContext(action.getExecuteContext());
            this.bpmDispatchAction.execute(executeContext, parentExecuteResult, bpmAction, data);
        } else {
            SubmitAction bpmAction = new SubmitAction();
            bpmAction.setTitle(action.getTitle());
            bpmAction.setActionId(action.getActionId());
            bpmAction.setCategory("TaskEngine");
            bpmAction.setServiceId(action.getServiceId());
            bpmAction.getServiceId().setServiceUri("api/project/terminate");
            bpmAction.setParas(processParameter);
            bpmAction.setExecuteContext(action.getExecuteContext());
            this.taskEngineTerminateProcessActionExecutor.execute(executeContext, parentExecuteResult, bpmAction, data);
        }
    }

    private void executeUpdateFields(SubmitExecuteContext submitExecuteContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        ExecuteContext executeContext;
        TmActivity tmActivity;
        TmAction tmAction;
        String detailField = null;
        if (action.getExtendParas().containsKey("detailField") && action.getExtendParas().get("detailField") != null) {
            detailField = action.getExtendParas().get("detailField").toString();
        }
        if ((tmAction = (tmActivity = this.commonThemeMapQueryService.getActivityAction(executeContext = ExecuteContext.builder().tmProjectId(action.getExecuteContext().getTmProjectId()).tmActivityId(action.getExecuteContext().getTmActivityId()).authoredUser(submitExecuteContext.getAuthoredUser()).proxyToken(submitExecuteContext.getProxyToken()).pageCode(action.getExecuteContext().getPageCode()).build())).getPages().getAbortTaskAction()) == null && CollectionUtils.isNotEmpty((Collection)tmActivity.getPages().getDataStates())) {
            for (TmDataState dataState : tmActivity.getPages().getDataStates()) {
                if (dataState == null || dataState.getAbortTaskAction() == null) continue;
                tmAction = dataState.getAbortTaskAction();
                break;
            }
        }
        if (tmAction == null) {
            return;
        }
        String[] keys = tmAction.getExtendParas().get("dataKeys").toString().split(";");
        List submitDatas = (List)data.get(tmAction.getExtendParas().get("submitVariableName").toString());
        List allDataKeys = (List)action.getExtendParas().get("allKey");
        for (int i = submitDatas.size() - 1; i >= 0; --i) {
            Map sd = (Map)submitDatas.get(i);
            if (detailField != null && sd.containsKey(detailField) && CollectionUtils.isNotEmpty((Collection)((List)sd.get(detailField)))) {
                List subDatas = (List)sd.get(detailField);
                for (int j = subDatas.size() - 1; j >= 0; --j) {
                    Map subData = (Map)subDatas.get(j);
                    boolean hasFound = this.findData(allDataKeys, keys, subData);
                    if (hasFound) continue;
                    subDatas.remove(j);
                }
                if (subDatas.size() != 0) continue;
                submitDatas.remove(i);
                continue;
            }
            boolean hasFound = this.findData(allDataKeys, keys, sd);
            if (hasFound) continue;
            submitDatas.remove(i);
        }
        SubmitAction submitAction = this.submitBaseActionCreateService.createSubmitAction(tmAction, action.getExecuteContext().getTenantId(), action.getBusinessUnit());
        submitAction.setExecuteContext(action.getExecuteContext());
        this.updateTableFieldAction.execute(submitExecuteContext, parentExecuteResult, submitAction, data);
    }

    private boolean findData(List<Map<String, Object>> allDataKeys, String[] keys, Map<String, Object> sd) {
        boolean hasFound = true;
        for (Map<String, Object> dk : allDataKeys) {
            hasFound = true;
            for (String key : keys) {
                if (Objects.equals(sd.get(key), dk.get(key))) continue;
                hasFound = false;
                break;
            }
            if (!hasFound) continue;
            break;
        }
        return hasFound;
    }

    private void notifyAtmcAbortTask(SubmitAction action) {
        Long originalBacklogId = action.getExecuteContext().getBacklogId();
        Map paras = (Map)action.getExtendParas().get("processParameter");
        if (this.isFlowEngine(paras)) {
            String processSerialNumber = paras.get("processSerialNumber").toString();
            String workitemId = paras.get("workitemId").toString();
            this.atmcService.abortTask(originalBacklogId, processSerialNumber, workitemId);
        }
    }

    private boolean isFlowEngine(Map<String, Object> processParameter) {
        return processParameter.containsKey("processSerialNumber");
    }
}

