/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ApiExecuteErrorActionExecutor
implements ActionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiExecuteErrorActionExecutor.class);
    private static final String SUPPORT_KEY = "ATMC_API_EXECUTE_ERROR:";
    @Resource
    private CommonAtmcService atmcService;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private MessageUtils messageUtils;

    public String supportKey() {
        return SUPPORT_KEY;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if ("atmc.api.execute.error.notify.maintainer".equals(action.getActionId())) {
            this.notifyMaintainer(executeContext, action);
            return ExecuteResult.ok();
        }
        if ("atmc.api.execute.error.solved".equals(action.getActionId())) {
            this.notifySolved(executeContext, action);
            return ExecuteResult.ok();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0037.getErrCode(), (String)(this.messageUtils.getMessage("exception.unsupport.actionId") + action.getActionId()));
    }

    private void notifySolved(SubmitExecuteContext executeContext, SubmitAction action) {
        if (this.isNotifySolvedByReExecute()) {
            this.notifySolvedByReExecute(executeContext, action);
        } else {
            this.notifySolvedBySendingEmail(executeContext, action);
        }
    }

    private void notifySolvedByReExecute(SubmitExecuteContext executeContext, SubmitAction action) {
        this.closeWorkItem(executeContext, action);
        this.reExecute(executeContext, action);
    }

    private void reExecute(SubmitExecuteContext executeContext, SubmitAction action) {
        Map reExecuteApi = Optional.ofNullable(executeContext.getBpmData()).map(bpmData -> (Map)bpmData.get("reExecute")).orElse(new HashMap());
        if (MapUtils.isEmpty((Map)reExecuteApi)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0038.getErrCode(), (String)this.messageUtils.getMessage("exception.lack.restart.interface.info"));
        }
        String url = String.valueOf(reExecuteApi.get("url"));
        Map headerMap = (Map)reExecuteApi.get("headers");
        HttpHeaders headers = new HttpHeaders();
        if (MapUtils.isNotEmpty((Map)headerMap)) {
            for (Map.Entry entry : headerMap.entrySet()) {
                headers.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        HttpEntity httpEntity = new HttpEntity(reExecuteApi.get("request"), (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(reExecuteApi.get("request")), (Object)ex);
            throw ex;
        }
    }

    private void closeWorkItem(SubmitExecuteContext executeContext, SubmitAction action) {
        this.atmcService.closeApiExecuteErrorWorkItem(executeContext.getProcessSerialNumber());
    }

    private void notifySolvedBySendingEmail(SubmitExecuteContext executeContext, SubmitAction action) {
        Object emailData = this.getEmailDataWithException(executeContext);
        this.atmcService.sendEmailToHandleApiExecuteError("notifySolved", emailData);
    }

    private boolean isNotifySolvedByReExecute() {
        List configs = this.atmcService.getConfig(Collections.singletonList("notifySolvedByReExecute"));
        if (CollectionUtils.isEmpty((Collection)configs) || null == configs.get(0)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((String)"true", (String)String.valueOf(((Map)configs.get(0)).get("value")));
    }

    private void notifyMaintainer(SubmitExecuteContext executeContext, SubmitAction action) {
        Object emailData = this.getEmailDataWithException(executeContext);
        this.atmcService.sendEmailToHandleApiExecuteError("notifyMaintainer", emailData);
    }

    private Object getEmailDataWithException(SubmitExecuteContext executeContext) {
        Optional<Object> emailData = Optional.ofNullable(executeContext.getBpmData()).map(bpmData -> bpmData.get("data")).map(data -> ((Map)data).get("emailData"));
        if (emailData.isPresent()) {
            return emailData.get();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0039.getErrCode(), (String)this.messageUtils.getMessage("exception.lack.email.param"));
    }
}

