/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.bpm.CommonBpmService;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=100)
@Service(value="BpmActionExecutor")
class BpmActionExecutor
implements ActionExecutor {
    @Autowired
    CommonBpmService commonBpmService;

    BpmActionExecutor() {
    }

    public String supportKey() {
        return "WF:";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (Objects.equals("UIBOT_WF_ACTION_CONTAINER", action.getActionId())) {
            if (!CollectionUtils.isEmpty((Collection)action.getAttachActions())) {
                for (SubmitAction attachAction : action.getAttachActions()) {
                    attachAction.setExtendParas(action.getExtendParas());
                    this.executeInternal(executeContext, attachAction, parameter);
                }
                action.setAttachActions(null);
            }
        } else {
            this.executeInternal(executeContext, action, parameter);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private ExecuteResult executeInternal(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        if (!CollectionUtils.isEmpty(parameter) && !CollectionUtils.isEmpty((Map)action.getExtendParas()) && action.getExtendParas().containsKey("submitVariableName")) {
            if (action.getParas() == null) {
                action.setParas(new HashMap());
            }
            String processVariableName = action.getExtendParas().get("submitVariableName").toString();
            Map para = action.getParas();
            HashMap<String, Object> processVariable = new HashMap<String, Object>();
            para.put("processVariable", processVariable);
            if ("SUBMIT_DATA".equals(processVariableName)) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    processVariable.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else if (parameter.containsKey(processVariableName)) {
                processVariable.put(processVariableName, parameter.get(processVariableName));
            }
        }
        if (action.getServiceId() != null && Objects.equals("reassign", action.getServiceId().getName())) {
            Map para = action.getParas();
            Map processVariable = null;
            if (para.containsKey("processVariable")) {
                processVariable = (Map)para.get("processVariable");
            } else {
                processVariable = new HashMap();
                para.put("processVariable", processVariable);
            }
            String taskId = (String)para.get("taskId");
            taskId = MessageFormat.format("{0}_performerId", taskId);
            processVariable.put(taskId, para.get("newPerformerId"));
        }
        this.commonBpmService.execute((Action)action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }
}

