/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.MergeDataActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Order(value=40)
@Service(value="data-reassignment")
class DataReassignmentActionExecutor
extends MergeDataActionExecutor
implements ActionExecutor {
    @Autowired
    @Qualifier(value="BpmActionExecutor")
    ActionExecutor bpmDispatchAction;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private MessageUtils messageUtils;

    DataReassignmentActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:data-reassignment-action";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        String actionId = submitParameter.getActionId();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();
        HashMap<String, String> extendedFields = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)executeContext.getTraceId())) {
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        this.commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, action.getBusinessUnit(), extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        this.mockSubmitData(action, submitParameter);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private void mockSubmitData(SubmitAction action, SubmitParameter submitParameter) {
        for (Object key : submitParameter.paras.keySet()) {
            if (Objects.equals(key, submitParameter.newProcessVariableName)) continue;
            for (Map submitPara : submitParameter.submitParas) {
                submitPara.put(key.toString(), submitParameter.paras.get(key));
            }
        }
        if (action != action.getMergeDataAction()) {
            Map mergedData = (Map)action.getMergeDataAction().getExtendParas().get("mergedSubmitData");
            Map mergedParas = (Map)mergedData.get("paras");
            List mergedSubmitParas = (List)mergedParas.get(submitParameter.newProcessVariableName);
            mergedSubmitParas.addAll((List)submitParameter.paras.get(submitParameter.newProcessVariableName));
        } else {
            Map extendParas = action.getExtendParas();
            HashMap<String, Object> startNewProcessMap = new HashMap<String, Object>();
            startNewProcessMap.put("tenantId", submitParameter.tenantId);
            startNewProcessMap.put("actionId", submitParameter.actionId);
            startNewProcessMap.put("paras", submitParameter.paras);
            startNewProcessMap.put("eoc", action.getBusinessUnit());
            extendParas.put("mergedSubmitData", startNewProcessMap);
        }
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        Map startNewProcessMap = (Map)action.getExtendParas().get("mergedSubmitData");
        String tenantId = startNewProcessMap.get("tenantId").toString();
        String actionId = startNewProcessMap.get("actionId").toString();
        Map paras = (Map)startNewProcessMap.get("paras");
        Map eoc = (Map)startNewProcessMap.get("eoc");
        HashMap<String, String> extendedFields = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)executeContext.getTraceId())) {
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        this.commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, eoc, extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private List<SubmitParameter> invokeMinSplit(ActionExecuteReq actionExecuteReq) {
        SubmitAction submitAction = actionExecuteReq.getAction();
        if (submitAction == null) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0011.getErrCode(), (String)this.messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
        Map extendParas = submitAction.getExtendParas();
        if (MapUtils.isEmpty((Map)extendParas)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0011.getErrCode(), (String)this.messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext == null) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0011.getErrCode(), (String)this.messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
        Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        Map workItemToBpmParas = submitAction.getWorkItemToBpmParas();
        Map workItemIdToBpmData = submitExecuteContext.getWorkItemIdToBpmData();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String tenantId = authoredUser.getTenantId();
        if (StringUtils.isEmpty((Object)tenantId) && !StringUtils.isEmpty((Object)AppAuthContextHolder.getContext().getProxyToken())) {
            authoredUser = this.tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
            tenantId = authoredUser.getTenantId();
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)workItemIdToData.size());
        for (Map.Entry entry : workItemIdToData.entrySet()) {
            Long workItemId = (Long)entry.getKey();
            Map paras = (Map)workItemToBpmParas.get(workItemId);
            Map bpmData = (Map)workItemIdToBpmData.get(workItemId);
            Map parameter = (Map)entry.getValue();
            if (MapUtils.isEmpty((Map)paras) || bpmData == null) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0011.getErrCode(), (String)this.messageUtils.getMessage("exception.data.reassignment.action.error"));
            }
            String actionId = null;
            if (bpmData.containsKey("actionId")) {
                actionId = bpmData.get("actionId").toString();
            }
            String newProcessVariableName = "";
            String submitVariableName = "";
            List submitParas = null;
            String newProcessFields = null;
            for (Map.Entry stringObjectEntry : extendParas.entrySet()) {
                switch ((String[])stringObjectEntry.getKey()) {
                    case "actionId": {
                        actionId = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "newProcessVariableName": {
                        newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "submitVariableName": {
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (parameter.containsKey(submitVariableName)) {
                            submitParas = (List)parameter.get(submitVariableName);
                            break;
                        }
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0012.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                    }
                    case "newProcessFields": {
                        newProcessFields = stringObjectEntry.getValue().toString();
                    }
                }
            }
            if (StringUtils.isEmpty((Object)actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty((Object)newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }
            String[] newProcessFieldList = newProcessFields.split(";");
            HashMap newParas = Maps.newHashMap();
            for (String key : newProcessFieldList) {
                if (parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)) {
                        newParas.put(newProcessVariableName, submitParas);
                        continue;
                    }
                    newParas.put(newProcessVariableName, parameter.get(key));
                    continue;
                }
                newParas.put(key, bpmData.get(key));
            }
            newParas.put("backlogId", workItemId);
            newParas.putAll(paras);
            newParas.put("activityId", submitExecuteContext.getTmActivityId());
            newParas.put("performerId", submitExecuteContext.getAuthoredUser().getUserId());
            list.add(new SubmitParameter(actionId, newParas, tenantId));
        }
        return list;
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext.isMinSplit() && actionExecuteReq.getWorkItemIdToData() != null) {
            List<SubmitParameter> list = this.invokeMinSplit(actionExecuteReq);
            SubmitAction action = actionExecuteReq.getAction();
            for (SubmitParameter submitParameter : list) {
                HashMap<String, String> extendedFields = new HashMap<String, String>();
                if (!StringUtils.isEmpty((Object)submitExecuteContext.getTraceId())) {
                    extendedFields.put("traceId", submitExecuteContext.getTraceId());
                }
                extendedFields.put("application", submitExecuteContext.getApplication());
                extendedFields.put("pageCode", submitExecuteContext.getPageCode());
                extendedFields.put("tmActivityId", submitExecuteContext.getTmActivityId());
                this.commonSmartDataService.executeWithParas(submitParameter.getTenantId(), submitParameter.getActionId(), new Map[]{submitParameter.getParas()}, action.getBusinessUnit(), extendedFields);
            }
            ExecuteResult executeResult = ExecuteResult.ok();
            executeResult.setAsync(true);
            return executeResult;
        }
        return super.execute(actionExecuteReq);
    }

    private class SubmitParameter {
        private SubmitExecuteContext executeContext;
        private SubmitAction action;
        private Map<String, Object> parameter;
        private String actionId;
        private List<Map<String, Object>> submitParas;
        private String newProcessVariableName;
        private String[] newProcessFieldList;
        private HashMap paras;
        private String tenantId;

        public SubmitParameter(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
            this.executeContext = executeContext;
            this.action = action;
            this.parameter = parameter;
        }

        public SubmitParameter(String actionId, HashMap paras, String tenantId) {
            this.actionId = actionId;
            this.paras = paras;
            this.tenantId = tenantId;
        }

        public String getActionId() {
            return this.actionId;
        }

        public List<Map<String, Object>> getSubmitParas() {
            return this.submitParas;
        }

        public String getNewProcessVariableName() {
            return this.newProcessVariableName;
        }

        public String[] getNewProcessFieldList() {
            return this.newProcessFieldList;
        }

        public HashMap getParas() {
            return this.paras;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public SubmitParameter invoke() {
            if (this.action == null || this.parameter == null || this.executeContext == null || this.executeContext.getBacklogId() == null || this.executeContext.getBpmData() == null || this.action.getParas() == null || this.action.getParas().size() == 0 || this.action.getExtendParas() == null || this.action.getExtendParas().size() == 0) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0011.getErrCode(), (String)DataReassignmentActionExecutor.this.messageUtils.getMessage("exception.data.reassignment.action.error"));
            }
            Map bpmParas = this.executeContext.getBpmData();
            this.actionId = null;
            if (bpmParas.containsKey("actionId")) {
                this.actionId = bpmParas.get("actionId").toString();
            }
            this.submitParas = null;
            String newProcessFields = null;
            String submitVariableName = "";
            this.newProcessVariableName = "";
            for (Map.Entry stringObjectEntry : this.action.getExtendParas().entrySet()) {
                switch ((String)stringObjectEntry.getKey()) {
                    case "actionId": {
                        this.actionId = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "newProcessVariableName": {
                        this.newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "submitVariableName": {
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (this.parameter.containsKey(submitVariableName)) {
                            this.submitParas = (List)this.parameter.get(submitVariableName);
                            break;
                        }
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0012.getErrCode(), (String)String.format(DataReassignmentActionExecutor.this.messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                    }
                    case "newProcessFields": {
                        newProcessFields = stringObjectEntry.getValue().toString();
                    }
                }
            }
            if (StringUtils.isEmpty((Object)this.actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty((Object)this.newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }
            this.newProcessFieldList = newProcessFields.split(";");
            this.paras = new HashMap();
            for (String key : this.newProcessFieldList) {
                if (this.parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)) {
                        this.paras.put(this.newProcessVariableName, this.submitParas);
                        continue;
                    }
                    this.paras.put(this.newProcessVariableName, this.parameter.get(key));
                    continue;
                }
                this.paras.put(key, bpmParas.get(key));
            }
            String backlogId = this.action.getExecuteContext().getBacklogId().toString();
            this.paras.put("backlogId", backlogId);
            this.paras.putAll(this.action.getParas());
            this.paras.put("activityId", this.executeContext.getTmActivityId());
            this.paras.put("performerId", this.executeContext.getAuthoredUser().getUserId());
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            this.tenantId = authoredUser.getTenantId();
            if (StringUtils.isEmpty((Object)this.tenantId) && !StringUtils.isEmpty((Object)AppAuthContextHolder.getContext().getProxyToken())) {
                authoredUser = DataReassignmentActionExecutor.this.tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
                this.tenantId = authoredUser.getTenantId();
            }
            return this;
        }
    }
}

