/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.TerminateDataExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=100)
@Service(value="dataUniformityExecutor")
public class DataUniformityExecutor
implements ActionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataUniformityExecutor.class);
    @Autowired
    private DataUniformityMongodbService mongodbService;
    @Autowired
    private TerminateDataExecutor terminateDataExecutor;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private MessageUtils messageUtils;
    private static String ACTION_ID = "atmc_data_uniformity_submit";

    public String supportKey() {
        return "UIBOT:" + ACTION_ID;
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        String schema = action.getSubmitType().getSchema();
        if (StringUtils.isEmpty((String)schema)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0040.getErrCode(), (String)("schema" + this.messageUtils.getMessage("exception.param.empty")));
        }
        Map extendParas = action.getExtendParas();
        List<Map<String, Object>> submitDataList = this.getSubmitPageDataList(data, schema);
        List endDataList = submitDataList.stream().filter(x -> "end".equals(x.get("data_uniformity_dealType"))).collect(Collectors.toList());
        ArrayList giveupList = new ArrayList();
        ArrayList recoverList = new ArrayList();
        if (CollectionUtils.isNotEmpty(endDataList)) {
            this.checkExtendParas(extendParas, schema, ((Map)endDataList.get(0)).get("bkKeys"));
        }
        if (CollectionUtils.isNotEmpty(endDataList)) {
            Map endData = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data), Map.class);
            Iterator submitVariableName = extendParas.get("submitVariableName").toString();
            endData.put(submitVariableName, endDataList);
            this.terminateDataExecutor.execute(executeContext, parentExecuteResult, action, endData);
        }
        String collection = executeContext.getAuthoredUser().getTenantId();
        for (Map map : submitDataList) {
            String dealType = map.get("data_uniformity_dealType").toString();
            map.put("dealType", dealType);
            Long workitemId = Long.valueOf(map.get("workitemId").toString());
            HashMap<String, String> sdMap = new HashMap<String, String>();
            sdMap.put("tenantId", collection);
            sdMap.put("tempId", executeContext.getTmActivityId());
            sdMap.put("type", "activity");
            sdMap.put("entityName", (String)map.get("entityName"));
            sdMap.put("bk", (String)map.get("bk"));
            if ("end".equals(dealType)) {
                Map workitemMap = this.atmcService.getBpmWorkItemById(workitemId);
                sdMap.put("instanceId", workitemMap.get("activityStepId").toString());
                giveupList.add(sdMap);
                continue;
            }
            recoverList.add(sdMap);
        }
        this.mongodbService.updateDealType(collection, submitDataList);
        this.mongodbService.recordSubmittedData(collection, executeContext.getAbnormalWorkitemId(), data);
        for (Map map : giveupList) {
            this.commonSmartDataService.giveupComparisonData(map);
        }
        for (Map map : recoverList) {
            this.commonSmartDataService.recoverComparisonData(map);
        }
        this.atmcService.closeDataUniformityBacklog(executeContext.getAbnormalWorkitemId(), ACTION_ID, executeContext.getDataFrom());
        ExecuteResult executeResult = new ExecuteResult();
        executeResult.setCompleted(true);
        return executeResult;
    }

    private void checkExtendParas(Map<String, Object> extendParas, String schema, Object bkKeys) {
        if (MapUtils.isEmpty(extendParas) || !extendParas.containsKey("dataKeys") || !extendParas.containsKey("processVariableName") || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0039.getErrCode(), (String)this.messageUtils.getMessage("exception.dataUniformity.attachAction.lack.config"));
        }
        if (null == extendParas.get("submitVariableName")) {
            extendParas.put("submitVariableName", schema);
        }
        extendParas.put("dataKeys", bkKeys);
    }

    private List<Map<String, Object>> getSubmitPageDataList(Map<String, Object> data, String submitVariableName) {
        if (MapUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return (List)data.get(submitVariableName);
    }
}

