/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.atdm.action.dto.UserDTO;
import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=100)
@Service(value="ptmManualReassignActionExecutor")
class PtmManualReassignActionExecutor
extends TaskEngineActionExecutorBase {
    @Autowired
    private CommonPtmService commonPtmService;
    @Autowired
    private CommonUserService commonUserService;

    PtmManualReassignActionExecutor() {
    }

    public String supportKey() {
        return "PTM:manual-reassign";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        this.setProcessVariables(action, parameter);
        SubmitAction newAction = this.translateAction(executeContext, action);
        this.commonPtmService.execute((Action)newAction);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private SubmitAction translateAction(SubmitExecuteContext executeContext, SubmitAction submitAction) {
        SubmitAction action = new SubmitAction();
        Map oldParas = submitAction.getParas();
        Map ptmData = executeContext.getPtmData();
        HashMap paras = new HashMap();
        paras.put("backlogId", ptmData.get("ptmBacklogId"));
        paras.put("performerType", oldParas.get("performerType"));
        paras.put("newPerformerId", oldParas.get("performerId"));
        paras.put("newPerformerName", oldParas.get("performerId"));
        UserDTO userDTO = this.commonUserService.query(MapUtils.getString((Map)oldParas, (Object)"performerId"), AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        if (userDTO != null) {
            paras.put("newPerformerName", userDTO.getName());
        }
        if (oldParas.containsKey("comment")) {
            paras.put("comment", oldParas.get("comment"));
        }
        action.setParas(paras);
        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(submitAction.getServiceId().getName());
        serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
        action.setServiceId(serviceId);
        return action;
    }
}

