/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.action.util.EspParameterConverterUtils;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=100)
@Service
class TaskEngineReturnActionExecutor
extends TaskEngineActionExecutorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskEngineReturnActionExecutor.class);
    @Autowired
    private CommonPtmService commonPtmService;

    TaskEngineReturnActionExecutor() {
    }

    public String supportKey() {
        return "TaskEngine:task-return";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        HashMap paras = Maps.newHashMapWithExpectedSize((int)1);
        ArrayList paramList = Lists.newArrayList();
        if (parameter.containsKey("ACTION_RETURN_PARAMS")) {
            Object params = parameter.get("ACTION_RETURN_PARAMS");
            if (params instanceof List) {
                List submitActionDTOList = (List)params;
                for (SubmitActionDTO actionDTO : submitActionDTOList) {
                    Map comData;
                    SubmitAction returnAction = actionDTO.getAction();
                    Map convertedData = actionDTO.getData();
                    if (returnAction.getActionParams() != null) {
                        convertedData = EspParameterConverterUtils.convert(convertedData, returnAction.getActionParams(), returnAction);
                    }
                    if (MapUtils.isNotEmpty((Map)returnAction.getParas()) && MapUtils.isNotEmpty((Map)(comData = EspParameterConverterUtils.combine(convertedData, returnAction.getParas())))) {
                        convertedData = comData;
                    }
                    paramList.add(this.createReturnParam(executeContext, returnAction, convertedData));
                }
            }
        } else {
            paramList.add(this.createReturnParam(executeContext, action, parameter));
        }
        paras.put("params", paramList);
        action.setParas((Map)paras);
        log.info("[task-return] {}", (Object)action);
        this.commonPtmService.execute((Action)action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private Map<String, Object> createReturnParam(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        this.setProcessVariables(action, parameter);
        HashMap dispatchData = Maps.newHashMapWithExpectedSize((int)2);
        if (parameter.size() > 0) {
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("uibot")) continue;
                dispatchData.put(key, entry.getValue());
                break;
            }
        }
        this.parsePerformerType(action.getParas(), executeContext.getPageCode());
        Map rowParas = action.getParas();
        Object activityId = rowParas.remove("activity_id");
        Object targetActivityId = rowParas.remove("target_activity_id");
        Object targetSchema = rowParas.remove("targetSchema");
        rowParas.put("activityId", activityId);
        rowParas.put("targetActivityId", targetActivityId);
        if (targetSchema != null) {
            Object remove = rowParas.remove(String.valueOf(targetSchema));
            dispatchData.put("individual_data_info", remove);
        }
        rowParas.put("dispatchData", dispatchData);
        return rowParas;
    }

    private Integer parsePerformerType(Map<String, Object> actionParas, String pageCode) {
        if ("project-detail".equals(pageCode)) {
            return 999;
        }
        if (MapUtils.isEmpty(actionParas)) {
            return 0;
        }
        Object performerType = actionParas.get("performerType");
        if (null == performerType) {
            return 0;
        }
        return Integer.valueOf(performerType.toString());
    }
}

