/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceSet;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawRespDTO;
import com.digiwin.athena.atdm.retrieveData.CommonRetrieveDataService;
import com.digiwin.athena.atdm.retrieveData.dto.RetrieveDataDTO;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.smartdata.dto.RetractCompareReqDTO;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.uibot.dto.UiBotTaskWithdrawReqDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=101)
@Service(value="uibot_task_withdraw")
public class TaskWithdrawExecutor
implements ActionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskWithdrawExecutor.class);
    @Autowired
    private CommonPtmService commonPtmService;
    @Autowired
    private CommonUiBotService commonUiBotService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private CommonRetrieveDataService commonRetrieveDataService;
    @Autowired
    private DataSubmissionService dataSubmissionService;

    public String supportKey() {
        return "UIBOT:" + BpmServiceInvokeType.TaskWithdraw.getName();
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        this.checkWithdrawAction(action);
        String submitVarName = action.getExtendParas().get("submitVariableName").toString();
        String[] dataKeys = StringUtils.split((String)action.getExtendParas().get("dataKeys").toString(), (String)";");
        List<Map<String, Object>> submitPageDataList = this.parseSubmitData(submitVarName, parameter);
        Map<Long, List<Map<String, Object>>> workItemSubmitDataMap = this.classifySubmitDataByWorkItemId(submitPageDataList);
        Long backlogId = this.parseBacklogId(workItemSubmitDataMap);
        List<PtmWithdrawRespDTO> relativeWithdrawTaskList = this.queryRelativeWithdrawTask(executeContext.getTenantId(), backlogId, dataKeys, workItemSubmitDataMap);
        if (CollectionUtils.isEmpty(relativeWithdrawTaskList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0032.getErrCode(), (String)this.messageUtils.getMessage("exception.task.withdraw.failed.to.query.relative.task"));
        }
        AuthoredUser authoredUser = executeContext.getAuthoredUser();
        this.saveRelativeWithdrawnData(authoredUser, backlogId, relativeWithdrawTaskList, dataKeys, workItemSubmitDataMap);
        List<Map<String, Object>> bkList = this.parseBK(dataKeys, submitPageDataList);
        this.retractComparisonData(authoredUser, backlogId, relativeWithdrawTaskList, executeContext.getTmActivityId(), executeContext.getBusinessUnit(), bkList);
        String performerId = this.parsePerformerId(action.getParas(), authoredUser);
        Integer performerType = this.parsePerformerType(action.getParas(), executeContext.getPageCode());
        String processVarName = action.getExtendParas().get("processVariableName").toString();
        this.executeRelativeTaskWithdraw(performerId, performerType, relativeWithdrawTaskList, processVarName, dataKeys, backlogId, workItemSubmitDataMap);
        return ExecuteResult.ok();
    }

    private void retractComparisonData(AuthoredUser authoredUser, Long backlogId, List<PtmWithdrawRespDTO> relativeWithdrawTaskList, String tmActivityId, Map<String, Object> eocMap, List<Map<String, Object>> bkList) {
        String bkListJson = JsonUtils.objectToString(bkList);
        List tmpBkList = JsonUtils.jsonToListObject((String)bkListJson, Map.class);
        List cardBKInfoList = this.atmcService.queryCardListByBk("workitem", backlogId, tmpBkList, true);
        if (CollectionUtils.isEmpty((Collection)cardBKInfoList)) {
            log.warn("[ptm-task-withdraw-{}] \u672a\u80fd\u83b7\u53d6\u5230BK\u4fe1\u606f: tmActivityId: {}, bkList: {}", new Object[]{backlogId, tmActivityId, bkListJson});
            return;
        }
        for (PtmWithdrawRespDTO relativeWithdrawTask : relativeWithdrawTaskList) {
            if (!CollectionUtils.isNotEmpty((Collection)relativeWithdrawTask.getNextWorkItems())) continue;
            for (PtmWithdrawRespDTO.Task nextWorkItem : relativeWithdrawTask.getNextWorkItems()) {
                Optional<Map> cardBkOpt = cardBKInfoList.stream().filter(MapUtils::isNotEmpty).filter(cardBKInfo -> Objects.equals(backlogId, cardBKInfo.get("backlogId")) && Objects.equals(nextWorkItem.getWorkItemId(), cardBKInfo.get("workItemId")) && null != cardBKInfo.get("entityName")).findFirst();
                if (!cardBkOpt.isPresent() || MapUtils.isEmpty((Map)cardBkOpt.get())) continue;
                Map cardBKInfo2 = cardBkOpt.get();
                RetractCompareReqDTO retractCompareReqDTO = new RetractCompareReqDTO();
                retractCompareReqDTO.setTenantId(authoredUser.getTenantId());
                retractCompareReqDTO.setInstanceId(String.valueOf(cardBKInfo2.get("workItemId")));
                retractCompareReqDTO.setTempId(String.valueOf(cardBKInfo2.get("tmActivityId")));
                retractCompareReqDTO.setEocMap(eocMap);
                retractCompareReqDTO.setBks((List)cardBKInfo2.get("bkList"));
                retractCompareReqDTO.setEntityName(String.valueOf(cardBKInfo2.get("entityName")));
                this.commonSmartDataService.retractComparisonData(retractCompareReqDTO);
            }
        }
    }

    private Long parseBacklogId(Map<Long, List<Map<String, Object>>> workItemSubmitDataMap) {
        Map.Entry<Long, List<Map<String, Object>>> workItemSubmitData;
        Map<String, Object> submitData;
        Map backlogData;
        Long backlogId = null;
        Iterator<Map.Entry<Long, List<Map<String, Object>>>> iterator = workItemSubmitDataMap.entrySet().iterator();
        while (iterator.hasNext() && (backlogId = (Long)(backlogData = (Map)(submitData = (workItemSubmitData = iterator.next()).getValue().get(0)).get("activity__backLog__data")).get("ptmBacklogId")) == null) {
        }
        return backlogId;
    }

    private Map<Long, List<Map<String, Object>>> classifySubmitDataByWorkItemId(List<Map<String, Object>> submitDataList) {
        HashMap<Long, List<Map<String, Object>>> workItemSubmitDataMap = new HashMap<Long, List<Map<String, Object>>>();
        for (Map<String, Object> submitData : submitDataList) {
            if (submitData.containsKey("activity__backLog__data")) {
                Map backlogData = (Map)submitData.get("activity__backLog__data");
                if (null != backlogData && null != backlogData.get("ptmBacklogId") && null != backlogData.get("ptmWorkItemId")) {
                    List workItemList = workItemSubmitDataMap.computeIfAbsent((Long)backlogData.get("ptmWorkItemId"), workItemId -> new ArrayList());
                    workItemList.add(submitData);
                    continue;
                }
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0033.getErrCode(), (String)this.messageUtils.getMessage("exception.task.withdraw.data.lack.necessary.config"));
            }
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0033.getErrCode(), (String)this.messageUtils.getMessage("exception.task.withdraw.data.lack.necessary.config"));
        }
        return workItemSubmitDataMap;
    }

    private void saveRelativeWithdrawnData(AuthoredUser authoredUser, Long backlogId, List<PtmWithdrawRespDTO> relativeTaskList, String[] dataKeys, Map<Long, List<Map<String, Object>>> workItemSubmitDataMap) {
        Map<Long, List<Map<String, Object>>> workItemBKMap = this.parseWorkItemBK(dataKeys, workItemSubmitDataMap);
        List<PtmWithdrawRespDTO> needParseRelativeTaskList = this.parsePostRelativeTask(relativeTaskList, workItemBKMap);
        LocalDateTime withdrawDateTime = LocalDateTime.now();
        this.parseAndSavePostRelativeTaskWithdrawData(authoredUser, withdrawDateTime, backlogId, dataKeys, workItemBKMap, needParseRelativeTaskList);
        for (Map.Entry<Long, List<Map<String, Object>>> workItemSubmitData : workItemSubmitDataMap.entrySet()) {
            this.saveRetrievedData(authoredUser, withdrawDateTime, backlogId, workItemSubmitData.getKey(), dataKeys, workItemSubmitData.getValue());
        }
    }

    private List<PtmWithdrawRespDTO> parsePostRelativeTask(List<PtmWithdrawRespDTO> relativeTaskList, Map<Long, List<Map<String, Object>>> workItemBKMap) {
        ArrayList<PtmWithdrawRespDTO> needParseRelativeTaskList = new ArrayList<PtmWithdrawRespDTO>();
        ArrayList rowCurrentWorkTaskIds = new ArrayList(relativeTaskList.size());
        for (PtmWithdrawRespDTO relativeTask : relativeTaskList) {
            ArrayList<Long> currWorkTaskId = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)relativeTask.getNextWorkItems())) {
                for (Object nextWorkItem : relativeTask.getNextWorkItems()) {
                    if (!workItemBKMap.containsKey(nextWorkItem.getWorkItemId())) continue;
                    currWorkTaskId.add(nextWorkItem.getTaskId());
                }
            }
            rowCurrentWorkTaskIds.add(currWorkTaskId);
        }
        for (int idx = 0; idx < relativeTaskList.size(); ++idx) {
            PtmWithdrawRespDTO relativeTask;
            relativeTask = relativeTaskList.get(idx);
            if (CollectionUtils.isEmpty((Collection)relativeTask.getNextWorkItems())) continue;
            ArrayList<PtmWithdrawRespDTO.Task> needParseNextWorkItems = new ArrayList<PtmWithdrawRespDTO.Task>();
            List currentWorkTaskId = (List)rowCurrentWorkTaskIds.get(idx);
            for (PtmWithdrawRespDTO.Task nextWorkItem : relativeTask.getNextWorkItems()) {
                if (workItemBKMap.containsKey(nextWorkItem.getWorkItemId())) continue;
                nextWorkItem.setInSameTask(Boolean.valueOf(currentWorkTaskId.contains(nextWorkItem.getTaskId())));
                needParseNextWorkItems.add(nextWorkItem);
            }
            if (!CollectionUtils.isNotEmpty(needParseNextWorkItems)) continue;
            PtmWithdrawRespDTO needParseRelativeTask = new PtmWithdrawRespDTO();
            needParseRelativeTask.setWorkItemId(relativeTask.getWorkItemId());
            needParseRelativeTask.setState(relativeTask.getState());
            needParseRelativeTask.setNextWorkItems(needParseNextWorkItems);
            needParseRelativeTaskList.add(needParseRelativeTask);
        }
        return needParseRelativeTaskList;
    }

    private void parseAndSavePostRelativeTaskWithdrawData(AuthoredUser authoredUser, LocalDateTime withdrawDateTime, Long backlogId, String[] dataKeys, Map<Long, List<Map<String, Object>>> workItemBKMap, List<PtmWithdrawRespDTO> needParseRelativeTaskList) {
        if (CollectionUtils.isEmpty(needParseRelativeTaskList)) {
            return;
        }
        Map<Long, List<Map>> workItemPageDefineMap = this.parseRelativeWithdrawTaskPageDefine(backlogId, needParseRelativeTaskList, workItemBKMap);
        if (MapUtils.isEmpty(workItemPageDefineMap)) {
            return;
        }
        for (Map.Entry<Long, List<Map>> workItemPageDefine : workItemPageDefineMap.entrySet()) {
            Long workItemId = workItemPageDefine.getKey();
            List<Map> pageDefines = workItemPageDefine.getValue();
            if (CollectionUtils.isEmpty(pageDefines)) continue;
            SubmitAction terminateTaskAction = null;
            for (Map pageDefine : pageDefines) {
                if (null == pageDefine || null == pageDefine.get("executeContext") || null == pageDefine.get("dataSourceSet")) {
                    log.error("[ptm-task-withdraw-{}-{}] \u672a\u80fd\u6210\u529f\u89e3\u6790\u51fa\u9875\u7b7e\u5b9a\u4e49", (Object)backlogId, (Object)workItemId);
                    continue;
                }
                ExecuteContext executeContext = this.convertJson(pageDefine.get("executeContext"), ExecuteContext.class);
                executeContext.setAuthoredUser(authoredUser);
                if (StringUtils.isBlank((String)executeContext.getTenantId())) {
                    executeContext.setTenantId(executeContext.getAuthoredUser().getTenantId());
                }
                DataSourceSetDTO dataSourceSet = this.convertJson(pageDefine.get("dataSourceSet"), DataSourceSetDTO.class);
                HashMap<String, Object> parameter = null != pageDefine.get("parameter") ? (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(pageDefine.get("parameter")), (TypeReference)new TypeReference<Map<String, Object>>(){}) : new HashMap<String, Object>();
                QueryResultSet queryResultSet = this.executeDataSource(executeContext, dataSourceSet, parameter);
                Optional<String> taskSubmitVarName = Optional.ofNullable((Map)pageDefine.get("extendedFields")).map(extendedFields -> extendedFields.get("submitVariableName")).map(submitVariableName -> submitVariableName.toString());
                List<Map<String, Object>> submitDataList = this.parseSubmitData(taskSubmitVarName.isPresent() ? taskSubmitVarName.get() : "", queryResultSet.getPageData());
                if (CollectionUtils.isNotEmpty(submitDataList)) {
                    this.saveRetrievedData(authoredUser, withdrawDateTime, backlogId, workItemId, dataKeys, submitDataList);
                }
                if (null == pageDefine.get("submitActions") || !CollectionUtils.isNotEmpty((Collection)((List)pageDefine.get("submitActions")))) continue;
                terminateTaskAction = (SubmitAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString(((List)pageDefine.get("submitActions")).get(0)), SubmitAction.class);
            }
            if (null == terminateTaskAction) continue;
            if (null == terminateTaskAction.getExecuteContext().getAuthoredUser()) {
                terminateTaskAction.getExecuteContext().setAuthoredUser(authoredUser);
            }
            if (StringUtils.isBlank((String)terminateTaskAction.getExecuteContext().getTenantId())) {
                terminateTaskAction.getExecuteContext().setTenantId(authoredUser.getTenantId());
            }
            this.dataSubmissionService.submit(terminateTaskAction.getExecuteContext(), terminateTaskAction, null);
        }
    }

    private <T> T convertJson(Object param, Class<T> clz) {
        return (T)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)param), clz);
    }

    private void saveRetrievedData(AuthoredUser authoredUser, LocalDateTime withdrawDateTime, Long backlogId, Long workItemId, String[] dataKeys, List<Map<String, Object>> submitDataList) {
        RetrieveDataDTO retrieveData = new RetrieveDataDTO();
        retrieveData.setUserId(authoredUser.getUserId());
        retrieveData.setUserName(authoredUser.getUserName());
        retrieveData.setTenantId(authoredUser.getTenantId());
        retrieveData.setActivityId(String.valueOf(workItemId));
        retrieveData.setInitiateActivityId(String.valueOf(backlogId));
        retrieveData.setBkList(Arrays.asList(dataKeys));
        retrieveData.setBkDataList(this.parseBK(dataKeys, submitDataList));
        retrieveData.setTerminateTime(withdrawDateTime);
        retrieveData.setPageData(submitDataList);
        retrieveData.setPageDataSize(Integer.valueOf(submitDataList.size()));
        this.commonRetrieveDataService.saveRetrieveData(retrieveData);
    }

    private Map<Long, List<Map>> parseRelativeWithdrawTaskPageDefine(Long backlogId, List<PtmWithdrawRespDTO> relativeTaskList, Map<Long, List<Map<String, Object>>> workItemBKMap) {
        ArrayList<UiBotTaskWithdrawReqDTO> uiBotTaskWithdrawReqList = new ArrayList<UiBotTaskWithdrawReqDTO>();
        for (PtmWithdrawRespDTO ptmWithdrawRespDTO : relativeTaskList) {
            for (PtmWithdrawRespDTO.Task nextTask : ptmWithdrawRespDTO.getNextWorkItems()) {
                UiBotTaskWithdrawReqDTO uiBotTaskWithdrawReqDTO = new UiBotTaskWithdrawReqDTO();
                uiBotTaskWithdrawReqDTO.setBacklogId(backlogId);
                uiBotTaskWithdrawReqDTO.setWorkItemId(nextTask.getWorkItemId());
                uiBotTaskWithdrawReqDTO.setTaskDefCode(nextTask.getTaskDefCode());
                uiBotTaskWithdrawReqDTO.setProjectDefCode(nextTask.getProjectDefCode());
                uiBotTaskWithdrawReqDTO.setBkList(workItemBKMap.get(ptmWithdrawRespDTO.getWorkItemId()));
                uiBotTaskWithdrawReqDTO.setState(nextTask.getState());
                uiBotTaskWithdrawReqDTO.setCheckCompleted(BooleanUtils.isFalse((Boolean)nextTask.getInSameTask()));
                uiBotTaskWithdrawReqList.add(uiBotTaskWithdrawReqDTO);
            }
        }
        Map taskPageDefineMap = this.commonUiBotService.queryTaskWithdrawPageDefine(uiBotTaskWithdrawReqList);
        return taskPageDefineMap;
    }

    private QueryResultSet executeDataSource(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter) {
        if (dataSourceSetDTO == null) {
            return QueryResultSet.empty();
        }
        DataSourceSet dataSourceSet = DataSourceConverter.convert((DataSourceSetDTO)dataSourceSetDTO);
        if (dataSourceSet == null) {
            return QueryResultSet.empty();
        }
        return dataSourceSet.query(executeContext, parameter, null, null, null);
    }

    private Map<Long, List<Map<String, Object>>> parseWorkItemBK(String[] dataKeys, Map<Long, List<Map<String, Object>>> workItemSubmitDataMap) {
        HashMap<Long, List<Map<String, Object>>> workItemBKMap = new HashMap<Long, List<Map<String, Object>>>();
        for (Map.Entry<Long, List<Map<String, Object>>> workItemSubmitData : workItemSubmitDataMap.entrySet()) {
            Long workItemId = workItemSubmitData.getKey();
            List<Map<String, Object>> bkList = this.parseBK(dataKeys, workItemSubmitData.getValue());
            workItemBKMap.put(workItemId, bkList);
        }
        return workItemBKMap;
    }

    private List<Map<String, Object>> parseBK(String[] dataKeys, List<Map<String, Object>> submitDataList) {
        ArrayList<Map<String, Object>> bkList = new ArrayList<Map<String, Object>>(submitDataList.size());
        for (Map<String, Object> submitData : submitDataList) {
            HashMap<String, Object> BK = new HashMap<String, Object>();
            for (String key : dataKeys) {
                BK.put(key, submitData.get(key));
            }
            bkList.add(BK);
        }
        return bkList;
    }

    private Integer parsePerformerType(Map<String, Object> actionParas, String pageCode) {
        if ("project-detail".equals(pageCode)) {
            return 999;
        }
        if (MapUtils.isEmpty(actionParas)) {
            return 0;
        }
        Object performerType = actionParas.get("performerType");
        if (null == performerType) {
            return 0;
        }
        return Integer.valueOf(performerType.toString());
    }

    private String parsePerformerId(Map<String, Object> actionParas, AuthoredUser authoredUser) {
        if (MapUtils.isEmpty(actionParas)) {
            return authoredUser.getUserId();
        }
        Object performerId = actionParas.get("agentPerformerId");
        if (null == performerId) {
            return authoredUser.getUserId();
        }
        return performerId.toString();
    }

    private void executeRelativeTaskWithdraw(String performerId, Integer performerType, List<PtmWithdrawRespDTO> relativeWithdrawTaskList, String processVarName, String[] dataKeys, Long backlogId, Map<Long, List<Map<String, Object>>> workItemDataMap) {
        Map<Long, Set> workItemTaskMap = relativeWithdrawTaskList.stream().collect(Collectors.toMap(PtmWithdrawRespDTO::getWorkItemId, ptmWithdrawRespDTO -> {
            if (CollectionUtils.isNotEmpty((Collection)ptmWithdrawRespDTO.getTaskIds())) {
                return ptmWithdrawRespDTO.getTaskIds();
            }
            if (CollectionUtils.isNotEmpty((Collection)ptmWithdrawRespDTO.getNextWorkItems())) {
                return ptmWithdrawRespDTO.getNextWorkItems().stream().map(PtmWithdrawRespDTO.Task::getWorkItemId).collect(Collectors.toSet());
            }
            return new HashSet();
        }, (newValue, oldValue) -> newValue));
        PtmWithdrawReqDTO withdrawReqDTO = new PtmWithdrawReqDTO();
        withdrawReqDTO.setBacklogId(backlogId);
        withdrawReqDTO.setUniKeys(Arrays.asList(dataKeys));
        withdrawReqDTO.setParameter(new ArrayList());
        withdrawReqDTO.setPerformerId(performerId);
        withdrawReqDTO.setPerformerType(performerType);
        withdrawReqDTO.setComment("\u6570\u636e\u64a4\u56de");
        workItemDataMap.forEach((workItemId, submitData) -> {
            PtmWithdrawReqDTO.ParamReqDTO paramReqDTO = new PtmWithdrawReqDTO.ParamReqDTO();
            paramReqDTO.setWorkItemId(workItemId);
            paramReqDTO.setNextWorkItemIdList((Set)workItemTaskMap.get(workItemId));
            paramReqDTO.setData(submitData);
            withdrawReqDTO.getParameter().add(paramReqDTO);
        });
        withdrawReqDTO.setDataVariableKey(processVarName);
        this.commonPtmService.executeRelativeTaskWithdraw(withdrawReqDTO);
    }

    private List<PtmWithdrawRespDTO> queryRelativeWithdrawTask(String tenantId, Long backlogId, String[] dataKeys, Map<Long, List<Map<String, Object>>> workItemDataMap) {
        PtmWithdrawReqDTO withdrawReqDTO = new PtmWithdrawReqDTO();
        withdrawReqDTO.setBacklogId(backlogId);
        withdrawReqDTO.setUniKeys(Arrays.asList(dataKeys));
        withdrawReqDTO.setParameter(new ArrayList());
        workItemDataMap.forEach((workItemId, submitData) -> {
            PtmWithdrawReqDTO.ParamReqDTO paramReqDTO = new PtmWithdrawReqDTO.ParamReqDTO();
            paramReqDTO.setWorkItemId(workItemId);
            paramReqDTO.setData(submitData);
            withdrawReqDTO.getParameter().add(paramReqDTO);
        });
        LogDto logDto = new LogDto("\u6267\u884cptm-task-withdraw\uff1a" + backlogId + ",\u8bf7\u6c42\u53c2\u6570\u53c2\u6570:" + JsonUtils.objectToString((Object)withdrawReqDTO), tenantId + ";" + backlogId);
        log.info(logDto.toString());
        List ptmWithdrawRespDTOS = this.commonPtmService.queryRelativeWithdrawTask(withdrawReqDTO);
        LogDto resDto = new LogDto("\u6267\u884cptm-task-withdraw\uff1a" + backlogId + ",\u67e5\u8be2\u6240\u6709\u9700\u5173\u8054\u64a4\u56de\u7684\u4efb\u52a1, \u54cd\u5e94\u5185\u5bb9:" + JsonUtils.objectToString((Object)ptmWithdrawRespDTOS), tenantId + ";" + backlogId);
        log.info(resDto.toString());
        return ptmWithdrawRespDTOS;
    }

    private List<Map<String, Object>> parseSubmitData(String submitVarName, Map<String, Object> data) {
        if (MapUtils.isEmpty(data) || null == data.get(submitVarName)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> submitDataList = new ArrayList<Map<String, Object>>();
        Object submitDataObj = data.get(submitVarName);
        if (submitDataObj instanceof Collection) {
            submitDataList.addAll((List)submitDataObj);
        } else {
            submitDataList.add((Map)submitDataObj);
        }
        return submitDataList;
    }

    private void checkWithdrawAction(SubmitAction action) {
        if (MapUtils.isEmpty((Map)action.getExtendParas()) || null == action.getExtendParas().get("dataKeys") || null == action.getExtendParas().get("processVariableName") || null == action.getExtendParas().get("submitVariableName")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0033.getErrCode(), (String)this.messageUtils.getMessage("exception.task.withdraw.lack.necessary.config"));
        }
    }
}

