/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.action.executor.DeleteActivityBpmVariableActionExecutor;
import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceSet;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.terminateData.CommonTerminateDataService;
import com.digiwin.athena.atdm.terminateData.dto.TerminateDataDTO;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.util.ActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=100)
@Service(value="terminateDataExecutor")
public class TerminateDataExecutor
extends TaskEngineActionExecutorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminateDataExecutor.class);
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonUiBotService commonUiBotService;
    @Autowired
    private CommonTerminateDataService commonTerminateDataService;
    @Autowired
    private DataSubmissionService dataSubmissionService;
    @Autowired
    private DeleteActivityBpmVariableActionExecutor deleteActivityBpmVariableActionExecutor;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    @Qualifier(value="asyncServiceExecutor")
    private ExecutorService executorService;
    private static final String TERMINATE_EXTEND_DATA_KEY = "uibot__terminateData_card_bk";
    private static final String TERMINATE_EXTEND_TERMINATE_DATE_TIME = "uibot__terminateDateTime";
    private static final String TERMINATE_EXTEND_INITIATE_DATE_KEY = "uibot__terminateData_initiate_card_bk";
    private static final String TERMINATE_EXTEND_TERMINATE_COMMENT = "uibot__terminateDate_comment";

    public String supportKey() {
        return "UIBOT:" + BpmServiceInvokeType.TerminateData.getName();
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        Map cardBKInfo;
        Map extendParas = action.getExtendParas();
        this.checkExtendParas(extendParas);
        List<Map<String, Object>> pageDataList = this.getSubmitParas(Lists.newArrayList((Object[])new Map[]{data}), extendParas.get("submitVariableName").toString());
        List<Map> bkList = null;
        if (null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)) {
            Map cardBKInfo2 = (Map)extendParas.get(TERMINATE_EXTEND_DATA_KEY);
            bkList = (List<Map>)cardBKInfo2.get("bkList");
        } else {
            String dataKeys = extendParas.get("dataKeys").toString();
            String detailField = StrUtil.toStringOrNull(extendParas.get("detailField"));
            bkList = this.parseBK(dataKeys, detailField, pageDataList);
        }
        if (CollectionUtils.isNotEmpty(pageDataList)) {
            this.deleteActivityBpmVariableActionExecutor.execute(executeContext, parentExecuteResult, action, data);
        } else {
            pageDataList = this.convertBkToPageData(bkList);
            HashMap<String, Object> newData = new HashMap<String, Object>();
            newData.put(extendParas.get("submitVariableName").toString(), pageDataList);
            this.deleteActivityBpmVariableActionExecutor.execute(executeContext, parentExecuteResult, action, newData);
        }
        if (null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)) {
            AuthoredUser operateAuthoredUser = (AuthoredUser)extendParas.get("operateAuthoredUser");
            cardBKInfo = (Map)extendParas.get(TERMINATE_EXTEND_DATA_KEY);
            LocalDateTime terminateDateTime = (LocalDateTime)extendParas.get(TERMINATE_EXTEND_TERMINATE_DATE_TIME);
            String comment = extendParas.get(TERMINATE_EXTEND_TERMINATE_COMMENT) != null ? (String)extendParas.get(TERMINATE_EXTEND_TERMINATE_COMMENT) : "";
            TerminateDataDTO terminateData = this.buildToSaveTerminateData(executeContext, operateAuthoredUser, bkList, pageDataList, terminateDateTime, comment);
            terminateData.setActivityName(null != cardBKInfo.get("tmActivityName") ? cardBKInfo.get("tmActivityName").toString() : "");
            Map initiateCardBKInfo = (Map)extendParas.get(TERMINATE_EXTEND_INITIATE_DATE_KEY);
            if (null != initiateCardBKInfo) {
                terminateData.setInitiateActivityId(initiateCardBKInfo.get("workItemId").toString());
                terminateData.setInitiateActivityCode(initiateCardBKInfo.get("tmActivityId").toString());
                terminateData.setInitiateActivityName(null != initiateCardBKInfo.get("tmActivityName") ? initiateCardBKInfo.get("tmActivityName").toString() : "");
            }
            this.commonTerminateDataService.saveTerminateData(operateAuthoredUser, terminateData);
            this.clearSmartDataFootprintAndComparisonData(executeContext.getTmActivityId(), operateAuthoredUser, executeContext.getBusinessUnit(), cardBKInfo);
        } else {
            List cardBKInfoList = this.atmcService.queryCardListByBk("workitem", executeContext.getBacklogId(), bkList, true);
            cardBKInfo = Maps.newHashMap();
            ArrayList<Map> otherCardBKInfoList = new ArrayList<Map>();
            if (CollectionUtils.isNotEmpty((Collection)cardBKInfoList)) {
                for (Map tmpCardBKInfo : cardBKInfoList) {
                    if (StringUtils.equals((String)String.valueOf(executeContext.getBacklogId()), (String)String.valueOf(tmpCardBKInfo.get("workItemId")))) {
                        cardBKInfo = tmpCardBKInfo;
                        continue;
                    }
                    otherCardBKInfoList.add(tmpCardBKInfo);
                }
            }
            AuthoredUser authoredUser = this.getOperateUser(executeContext);
            LocalDateTime terminateDateTime = LocalDateTime.now();
            String comment = "";
            Map paras = action.getParas();
            if (MapUtils.isNotEmpty((Map)paras)) {
                comment = paras.get("comment") != null ? (String)paras.get("comment") : "";
            }
            TerminateDataDTO terminateData = this.buildToSaveTerminateData(executeContext, null, bkList, pageDataList, terminateDateTime, comment);
            if (MapUtils.isNotEmpty((Map)cardBKInfo)) {
                terminateData.setActivityName(null != cardBKInfo.get("tmActivityName") ? cardBKInfo.get("tmActivityName").toString() : "");
            }
            this.commonTerminateDataService.saveTerminateData(authoredUser, terminateData);
            if (MapUtils.isNotEmpty((Map)cardBKInfo)) {
                this.clearSmartDataFootprintAndComparisonData(executeContext.getTmActivityId(), authoredUser, executeContext.getBusinessUnit(), cardBKInfo);
            }
            if (CollectionUtils.isNotEmpty(otherCardBKInfoList)) {
                this.terminateOtherTaskDataAsync(executeContext, action, cardBKInfo, otherCardBKInfoList, terminateDateTime, comment);
            }
        }
        return ExecuteResult.ok();
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext.isMinSplit()) {
            Map workItemIdToData = ActivityUtils.getMinSplitWorkItemToData((ActionExecuteReq)actionExecuteReq);
            SubmitAction action = actionExecuteReq.getAction();
            Map extendParas = action.getExtendParas();
            this.checkExtendParas(extendParas);
            if (null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)) {
                return super.execute(actionExecuteReq);
            }
            String dataKeys = extendParas.get("dataKeys").toString();
            String detailField = StrUtil.toStringOrNull(extendParas.get("detailField"));
            String submitVariableName = extendParas.get("submitVariableName").toString();
            HashMap workItemIdToBk = Maps.newHashMapWithExpectedSize((int)workItemIdToData.size());
            HashMap workItemIdToPageData = Maps.newHashMapWithExpectedSize((int)workItemIdToData.size());
            workItemIdToData.forEach((k, v) -> {
                List<Map<String, Object>> pageDataList = this.getSubmitParas(Arrays.asList(v), submitVariableName);
                if (!pageDataList.isEmpty()) {
                    workItemIdToPageData.put(k, pageDataList);
                }
                workItemIdToBk.put(k, this.parseBK(dataKeys, detailField, pageDataList));
            });
            ActionExecuteReq cp = (ActionExecuteReq)JaBeanCopy.cp((Object)actionExecuteReq, ActionExecuteReq.class);
            if (!workItemIdToPageData.isEmpty()) {
                this.deleteActivityBpmVariableActionExecutor.execute(actionExecuteReq);
            } else {
                HashMap workItemIdToNewData = Maps.newHashMapWithExpectedSize((int)workItemIdToBk.size());
                workItemIdToBk.forEach((k, v) -> {
                    HashMap newData = Maps.newHashMapWithExpectedSize((int)1);
                    newData.put(submitVariableName, v);
                    workItemIdToNewData.put(k, newData);
                });
                cp.setWorkItemIdToData((Map)workItemIdToNewData);
                this.deleteActivityBpmVariableActionExecutor.execute(cp);
            }
            AuthoredUser authoredUser = this.getOperateUser(submitExecuteContext);
            ArrayList terminateDataList = Lists.newArrayListWithExpectedSize((int)workItemIdToPageData.size());
            String comment = MapUtils.getString((Map)action.getParas(), (Object)"comment", (String)"");
            ArrayList otherCardList = Lists.newArrayList();
            HashMap currentBkMap = Maps.newHashMapWithExpectedSize((int)workItemIdToPageData.size());
            LocalDateTime terminateDateTime = LocalDateTime.now();
            for (Map.Entry entry : workItemIdToPageData.entrySet()) {
                Long key = (Long)entry.getKey();
                List cardBKInfoList = this.atmcService.queryCardListByBk("workitem", key, (List)workItemIdToBk.get(key), true);
                Map cardBKInfo = Maps.newHashMap();
                ArrayList<Map> otherCardBKInfoList = new ArrayList<Map>();
                if (CollectionUtils.isNotEmpty((Collection)cardBKInfoList)) {
                    for (Map tmpCardBKInfo : cardBKInfoList) {
                        if (StringUtils.equals((String)String.valueOf(key), (String)String.valueOf(tmpCardBKInfo.get("workItemId")))) {
                            cardBKInfo = tmpCardBKInfo;
                            continue;
                        }
                        otherCardBKInfoList.add(tmpCardBKInfo);
                    }
                }
                otherCardList.add(new Tuple(new Object[]{key, cardBKInfo, otherCardBKInfoList}));
                TerminateDataDTO terminateData = this.buildToSaveTerminateData(String.valueOf(key), submitExecuteContext.getTmActivityId(), authoredUser, (List)workItemIdToBk.get(key), (List)entry.getValue(), terminateDateTime, comment);
                if (MapUtils.isNotEmpty((Map)cardBKInfo)) {
                    terminateData.setActivityName(MapUtils.getString((Map)cardBKInfo, (Object)"tmActivityName", (String)""));
                }
                terminateDataList.add(terminateData);
                if (cardBKInfo.isEmpty()) continue;
                currentBkMap.put(key, cardBKInfo);
            }
            this.commonTerminateDataService.saveTerminateData(authoredUser, (List)terminateDataList);
            if (!currentBkMap.isEmpty()) {
                currentBkMap.forEach((k, v) -> this.clearSmartDataFootprintAndComparisonData(submitExecuteContext.getTmActivityId(), authoredUser, submitExecuteContext.getBusinessUnit(), (Map)v));
            }
            this.terminateOtherTaskDataAsync(authoredUser, comment, submitExecuteContext.getTmActivityId(), otherCardList, terminateDateTime);
            return ExecuteResult.ok();
        }
        return super.execute(actionExecuteReq);
    }

    private List<Map<String, Object>> convertBkToPageData(List<Map> bkList) {
        ArrayList<Map<String, Object>> pageDataList = new ArrayList<Map<String, Object>>();
        for (Map bkInfo : bkList) {
            HashMap pageData = new HashMap();
            Set entries = bkInfo.entrySet();
            for (Map.Entry entry : entries) {
                pageData.put(entry.getKey().toString(), entry.getValue());
            }
            pageDataList.add(pageData);
        }
        return pageDataList;
    }

    private TerminateDataDTO buildToSaveTerminateData(String workItemId, String tmActivityId, AuthoredUser authoredUser, List<Map> bkList, List<Map<String, Object>> pageDataList, LocalDateTime terminateDateTime, String comment) {
        TerminateDataDTO terminateData = new TerminateDataDTO();
        terminateData.setTenantId(authoredUser.getTenantId());
        terminateData.setUserId(authoredUser.getUserId());
        terminateData.setUserName(authoredUser.getUserName());
        terminateData.setActivityId(workItemId);
        terminateData.setActivityCode(tmActivityId);
        terminateData.setTerminateTime(terminateDateTime);
        terminateData.setComment(comment);
        terminateData.setBkList(bkList);
        terminateData.setPageData(pageDataList);
        terminateData.setPageDataSize(Integer.valueOf(pageDataList.size()));
        return terminateData;
    }

    private TerminateDataDTO buildToSaveTerminateData(SubmitExecuteContext executeContext, AuthoredUser operatorAuthoredUser, List<Map> bkList, List<Map<String, Object>> pageDataList, LocalDateTime terminateDateTime, String comment) {
        AuthoredUser authoredUser = null != operatorAuthoredUser ? operatorAuthoredUser : this.getOperateUser(executeContext);
        return this.buildToSaveTerminateData(String.valueOf(executeContext.getBacklogId()), executeContext.getTmActivityId(), authoredUser, bkList, pageDataList, terminateDateTime, comment);
    }

    private void terminateOtherTaskDataAsync(SubmitExecuteContext executeContext, SubmitAction action, Map cardBKInfo, List<Map> cardBKInfoList, LocalDateTime terminateDateTime, String comment) {
        HashMap<String, Object> initiateCardBKInfo = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)cardBKInfo)) {
            initiateCardBKInfo.putAll(cardBKInfo);
        } else {
            initiateCardBKInfo.put("workItemId", executeContext.getBacklogId());
            initiateCardBKInfo.put("tmActivityId", executeContext.getTmActivityId());
        }
        for (Map taskBKInfo : cardBKInfoList) {
            TerminateDataTask terminateDataTask = new TerminateDataTask(taskBKInfo, executeContext.getBacklogId(), this.commonUiBotService, this.dataSubmissionService);
            terminateDataTask.setInitiateTaskBKInfo(initiateCardBKInfo);
            terminateDataTask.setTerminateDateTime(terminateDateTime.plusHours(0L));
            terminateDataTask.setOperateAuthoredUser(this.getOperateUser(executeContext));
            terminateDataTask.setComment(comment);
            this.executorService.submit(terminateDataTask);
        }
    }

    private void terminateOtherTaskDataAsync(AuthoredUser authoredUser, String comment, String tmActivityId, List<Tuple> otherCardList, LocalDateTime terminateDateTime) {
        if (CollectionUtils.isNotEmpty(otherCardList)) {
            for (Tuple tuple : otherCardList) {
                List cardBKInfoList = (List)tuple.get(2);
                if (!CollectionUtils.isNotEmpty((Collection)cardBKInfoList)) continue;
                Map cardBKInfo = (Map)tuple.get(1);
                Long workItemId = (Long)tuple.get(0);
                HashMap<String, String> initiateCardBKInfo = new HashMap<String, String>();
                if (MapUtils.isNotEmpty((Map)cardBKInfo)) {
                    initiateCardBKInfo.putAll(cardBKInfo);
                } else {
                    initiateCardBKInfo.put("workItemId", String.valueOf(workItemId));
                    initiateCardBKInfo.put("tmActivityId", tmActivityId);
                }
                for (Map taskBKInfo : cardBKInfoList) {
                    TerminateDataTask terminateDataTask = new TerminateDataTask(taskBKInfo, workItemId, this.commonUiBotService, this.dataSubmissionService);
                    terminateDataTask.setInitiateTaskBKInfo(initiateCardBKInfo);
                    terminateDataTask.setTerminateDateTime(terminateDateTime.plusHours(0L));
                    terminateDataTask.setOperateAuthoredUser(authoredUser);
                    terminateDataTask.setComment(comment);
                    this.executorService.submit(terminateDataTask);
                }
            }
        }
    }

    private void checkExtendParas(Map<String, Object> extendParas) {
        if (MapUtils.isEmpty(extendParas) || !extendParas.containsKey("dataKeys") || !extendParas.containsKey("processVariableName") || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0030.getErrCode(), (String)this.messageUtils.getMessage("exception.terminate.attachAction.lack.config"));
        }
    }

    private void clearSmartDataFootprintAndComparisonData(String tmActivityId, AuthoredUser authoredUser, Map<String, Object> eocMap, Map cardBkInfo) {
        if (MapUtils.isEmpty((Map)cardBkInfo)) {
            return;
        }
        String backlogId = Optional.ofNullable(cardBkInfo.get("backlogId")).map(value -> value.toString()).orElse("");
        String entityName = Optional.ofNullable(cardBkInfo.get("entityName")).map(value -> value.toString()).orElse("");
        if (StringUtils.isBlank((String)backlogId) || StringUtils.isBlank((String)entityName)) {
            return;
        }
        List bkList = (List)cardBkInfo.get("bkList");
        this.commonSmartDataService.clearComparisonData(authoredUser, backlogId, tmActivityId, entityName, eocMap, bkList);
        this.commonSmartDataService.clearFootprintData(authoredUser, backlogId, tmActivityId, entityName, eocMap, bkList);
    }

    private List<Map> parseBK(String dataKeys, String detailField, List<Map<String, Object>> pageDataList) {
        String[] dataKeyList = StringUtils.split((String)dataKeys, (char)';');
        ArrayList<Map> BKList = new ArrayList<Map>(pageDataList.size());
        List<Map<String, Object>> tmpPageDataList = pageDataList;
        if (StringUtils.isNotBlank((String)detailField)) {
            tmpPageDataList = this.getSubmitParas(pageDataList, detailField);
        }
        for (Map<String, Object> pageData : tmpPageDataList) {
            HashMap<String, Object> BK = new HashMap<String, Object>();
            for (String key : dataKeyList) {
                BK.put(key, pageData.get(key));
            }
            BKList.add(BK);
        }
        return BKList;
    }

    private List<Map<String, Object>> getSubmitParas(List<Map<String, Object>> paramList, String field) {
        if (StringUtils.isBlank((String)field)) {
            return paramList;
        }
        log.info("TerminateDataExecutor.getSubmitParas:{}", (Object)JsonUtils.objectToString(paramList));
        ArrayList submitParas = Lists.newArrayList();
        for (Map<String, Object> param : paramList) {
            Object paramValueObj = param.get(field);
            if (paramValueObj instanceof Map) {
                submitParas.add((Map)paramValueObj);
                continue;
            }
            if (paramValueObj instanceof Collection) {
                submitParas.addAll((List)paramValueObj);
                continue;
            }
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0020.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data2") + field + this.messageUtils.getMessage("exception.data.type.error")));
        }
        return submitParas;
    }

    private AuthoredUser getOperateUser(SubmitExecuteContext executeContext) {
        return null != executeContext.getOperateAuthoredUser() ? executeContext.getOperateAuthoredUser() : executeContext.getAuthoredUser();
    }

    protected static class TerminateDataTask
    implements Runnable {
        private Map taskBkInfo;
        private Map initiateTaskBKInfo;
        private CommonUiBotService commonUiBotService;
        private DataSubmissionService dataSubmissionService;
        private AuthoredUser authoredUser;
        private AuthoredUser operateAuthoredUser;
        private Locale locale;
        private Long origWorkItemId;
        private String comment;
        private LocalDateTime terminateDateTime;

        public TerminateDataTask(Map taskBkInfo, Long origWorkItemId, CommonUiBotService commonUiBotService, DataSubmissionService dataSubmissionService) {
            this.taskBkInfo = taskBkInfo;
            this.commonUiBotService = commonUiBotService;
            this.origWorkItemId = origWorkItemId;
            this.dataSubmissionService = dataSubmissionService;
            this.authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            this.locale = LocaleContextHolder.getLocale();
        }

        @Override
        public void run() {
            AppAuthContextHolder.getContext().setAuthoredUser(this.authoredUser);
            LocaleContextHolder.setLocale((Locale)this.locale);
            Long workItemId = (Long)this.taskBkInfo.get("workItemId");
            try {
                this.execute(workItemId);
            }
            catch (Exception ex) {
                log.error("terminateData-{}-{}, error: {}", new Object[]{this.origWorkItemId, workItemId, ex});
            }
            finally {
                LocaleContextHolder.resetLocaleContext();
                AppAuthContextHolder.clearContext();
            }
        }

        private void execute(Long workItemId) {
            List bkList = (List)this.taskBkInfo.get("bkList");
            String tmProjectId = this.taskBkInfo.get("tmProjectId").toString();
            String tmActivityId = this.taskBkInfo.get("tmActivityId").toString();
            log.info("terminateData-{}-{}-{}-{}-relative task.", new Object[]{this.origWorkItemId, workItemId, tmActivityId, tmProjectId});
            Map pageDefine = this.commonUiBotService.queryTerminateDataPageDefine(tmProjectId, tmActivityId, workItemId, bkList);
            if (null == pageDefine || null == pageDefine.get("executeContext") || null == pageDefine.get("dataSourceSet") || CollectionUtils.isEmpty((Collection)((List)pageDefine.get("submitActions")))) {
                log.warn("terminateData-{}-{}-{}-{}'s pageDefine invalid", new Object[]{this.origWorkItemId, workItemId, tmActivityId, tmProjectId});
                return;
            }
            log.info("submitActions:{}", (Object)JsonUtils.objectToString(pageDefine.get("submitActions")));
            ExecuteContext executeContext = this.parsePageDefineExecuteContext(pageDefine);
            DataSourceSetDTO dataSourceSet = (DataSourceSetDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(pageDefine.get("dataSourceSet")), DataSourceSetDTO.class);
            HashMap<String, Object> parameter = null != pageDefine.get("parameter") ? (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(pageDefine.get("parameter")), (TypeReference)new TypeReference<Map<String, Object>>(){}) : new HashMap<String, Object>();
            QueryResultSet queryResultSet = this.queryPageData(executeContext, dataSourceSet, parameter);
            SubmitAction terminateDataAction = this.buildTerminateAction(pageDefine);
            this.executeTerminateDataAction(terminateDataAction, queryResultSet.getPageData());
        }

        private SubmitAction buildTerminateAction(Map pageDefine) {
            SubmitAction terminateDataAction = this.parseTerminateAction((List)pageDefine.get("submitActions"));
            if (null != terminateDataAction.getExecuteContext()) {
                terminateDataAction.getExecuteContext().setAuthoredUser(this.authoredUser);
                if (StringUtils.isBlank((String)terminateDataAction.getExecuteContext().getTenantId())) {
                    terminateDataAction.getExecuteContext().setTenantId(this.authoredUser.getTenantId());
                }
            }
            terminateDataAction.getExtendParas().put(TerminateDataExecutor.TERMINATE_EXTEND_DATA_KEY, this.taskBkInfo);
            terminateDataAction.getExtendParas().put(TerminateDataExecutor.TERMINATE_EXTEND_INITIATE_DATE_KEY, this.initiateTaskBKInfo);
            terminateDataAction.getExtendParas().put(TerminateDataExecutor.TERMINATE_EXTEND_TERMINATE_DATE_TIME, this.terminateDateTime);
            terminateDataAction.getExtendParas().put(TerminateDataExecutor.TERMINATE_EXTEND_TERMINATE_COMMENT, this.comment);
            terminateDataAction.getExtendParas().put("operateAuthoredUser", this.getOperateAuthoredUser());
            this.changeDispatchActionParas(terminateDataAction);
            return terminateDataAction;
        }

        private void changeDispatchActionParas(SubmitAction terminateDataAction) {
            if (CollectionUtils.isEmpty((Collection)terminateDataAction.getAttachActions())) {
                return;
            }
            terminateDataAction.getAttachActions().stream().filter(attachAction -> this.isDispatchAction((SubmitAction)attachAction)).filter(attachAction -> MapUtils.isNotEmpty((Map)attachAction.getParas())).forEach(attachAction -> attachAction.getParas().put("performerType", 999));
        }

        private boolean isDispatchAction(SubmitAction submitAction) {
            if (null == submitAction || null == submitAction.getServiceId()) {
                return false;
            }
            return StringUtils.equals((String)submitAction.getCategory(), (String)"TaskEngine") && StringUtils.equals((String)submitAction.getServiceId().getName(), (String)"dispatch");
        }

        private SubmitAction parseTerminateAction(List<Map<String, Object>> submitActions) {
            Map<String, Object> submitAction = submitActions.get(0);
            this.removeActionField(submitAction);
            return (SubmitAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString(submitAction), SubmitAction.class);
        }

        private void removeActionField(Map<String, Object> action) {
            if (null != action) {
                action.remove("action_LIST");
            }
            if (null != action && null != action.get("attachActions")) {
                List attachActions = (List)action.get("attachActions");
                for (Map attachAction : attachActions) {
                    this.removeActionField(attachAction);
                }
            }
        }

        private ExecuteContext parsePageDefineExecuteContext(Map pageDefine) {
            ExecuteContext executeContext = (ExecuteContext)JsonUtils.jsonToObject((String)JsonUtils.objectToString(pageDefine.get("executeContext")), ExecuteContext.class);
            executeContext.setAuthoredUser(this.authoredUser);
            if (StringUtils.isBlank((String)executeContext.getTenantId())) {
                executeContext.setTenantId(this.authoredUser.getTenantId());
            }
            return executeContext;
        }

        private QueryResultSet queryPageData(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter) {
            if (dataSourceSetDTO == null) {
                return QueryResultSet.empty();
            }
            DataSourceSet dataSourceSet = DataSourceConverter.convert((DataSourceSetDTO)dataSourceSetDTO);
            if (dataSourceSet == null) {
                return QueryResultSet.empty();
            }
            return dataSourceSet.query(executeContext, parameter, null, null, null);
        }

        private void executeTerminateDataAction(SubmitAction terminateDataAction, Map submitPageData) {
            this.dataSubmissionService.submit(terminateDataAction.getExecuteContext(), terminateDataAction, submitPageData);
        }

        @Generated
        public Map getInitiateTaskBKInfo() {
            return this.initiateTaskBKInfo;
        }

        @Generated
        public void setInitiateTaskBKInfo(Map initiateTaskBKInfo) {
            this.initiateTaskBKInfo = initiateTaskBKInfo;
        }

        @Generated
        public void setOperateAuthoredUser(AuthoredUser operateAuthoredUser) {
            this.operateAuthoredUser = operateAuthoredUser;
        }

        @Generated
        public AuthoredUser getOperateAuthoredUser() {
            return this.operateAuthoredUser;
        }

        @Generated
        public void setComment(String comment) {
            this.comment = comment;
        }

        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public void setTerminateDateTime(LocalDateTime terminateDateTime) {
            this.terminateDateTime = terminateDateTime;
        }
    }
}

