/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.log;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.log.LogRecordDTO;
import com.digiwin.athena.atdm.log.LogRecordEvent;
import com.digiwin.athena.atdm.log.LogRecordUtils;
import com.google.common.eventbus.Subscribe;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogRecordSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogRecordSubscriber.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    public static final String MQ_ROUTING_NAME = "athena.troubleshoot.log";
    public static final String MQ_EXCHANGE_NAME = "athena.troubleshoot";
    public static final String APP_ID = "atdm";
    public static final String URL = "/api/atdm/v1/action/submit/task";
    public static final String MERGE_TASK_URL = "/api/atdm/v1/action/submit/mergeTask";
    public static final String PTX_ID = "troubleshoot:PtxId";
    public static final String NOT_SUPPORT_RETRY = "notSupportRetry";

    @Subscribe
    public void logRecord(LogRecordEvent logRecordEvent) {
        log.info(PTX_ID);
        AuthoredUser authoredUser = logRecordEvent.getAuthoredUser();
        LogRecordDTO content = (LogRecordDTO)logRecordEvent.getContent();
        HttpServletRequest request = logRecordEvent.getRequest();
        try {
            SubmitAction submitAction;
            SubmitActionDTO submitActionDTO;
            LogRecordDTO logRecordDTO = (LogRecordDTO)logRecordEvent.getContent();
            if (URL.equals(logRecordDTO.getUrl())) {
                submitActionDTO = (SubmitActionDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)content.getInputValue()), SubmitActionDTO.class);
                submitAction = LogRecordUtils.getSupportRetry(submitActionDTO);
            } else {
                submitActionDTO = (MergeSubmitActionDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)content.getInputValue()), MergeSubmitActionDTO.class);
                submitAction = LogRecordUtils.getMergeSupportRetry(submitActionDTO.getActionMerge());
            }
            content.setOperateType((String)(submitAction != null && submitAction.getSupportRetry() != false ? null : NOT_SUPPORT_RETRY));
            content.setOperateDesc(submitAction != null ? submitAction.getActionId() : null);
            content.setAppid(APP_ID);
            content.setCreateName(authoredUser.getUserName());
            content.setTenantsid(authoredUser.getTenantSid());
            content.setTenantid(authoredUser.getTenantId());
            content.setUserid(authoredUser.getUserId());
            content.setTraceid(MDC.get((String)"PtxId"));
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                headers.put(headerName, headerValue);
            }
            content.setHeader(JsonUtils.objectToString(headers));
            this.rabbitTemplate.convertAndSend(MQ_EXCHANGE_NAME, MQ_ROUTING_NAME, (Object)JsonUtils.objectToString((Object)content));
        }
        catch (Exception e) {
            log.error("deal logRecord error{}", (Throwable)e);
        }
    }
}

