package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @description: 将数据从回收站删除，还原到基础录入列表
 */
@Service
public class RecycleDeleteExecutor implements ActionExecutor {
    @Autowired
    private CommonRecycleService commonRecycleService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_RECYCLE + ActionConstants.SPLIT + "recycle.delete";
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        List<Map<String, Object>> submitDataList = getSubmitDataList(data);
        if(CollectionUtils.isEmpty(submitDataList)) {
            return ExecuteResult.ok();
        }

        commonRecycleService.deleteRecycle(executeContext.getAuthoredUser(), executeContext.getTmActivityId(), submitDataList);
        return ExecuteResult.ok();
    }

    private List<Map<String, Object>> getSubmitDataList(Map<String, Object> data) {
        if (MapUtils.isEmpty(data)) {
            return Collections.emptyList();
        }

        Optional<Object> dataOptional = data.values().stream().findFirst();
        if (dataOptional.isPresent()) {
            return (List<Map<String, Object>>) dataOptional.get();
        }
        return Collections.emptyList();
    }
}
