package com.digiwin.athena.atdm.action.util;

import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EspParameterConverterUtils {

    private static final String DATA_STATUS_FLAG = "plat_data_flag";

    private static DefaultConversionService defaultConversionService = new DefaultConversionService();

    public static Map<String, Object> convert(Map<String, Object> data, List<ActionParameterMapping> parameterMappings, SubmitAction action) {
        Map<String, Object> para = new HashMap<>();

        //暂时只处理简单的方式：1、平铺转主从结构；2、平铺转平铺
        if (data.size() == 0 || CollectionUtils.isEmpty(parameterMappings)) {
            return para;
        }

        //1、先构建目标的结构
        Map<String, Entity> targetStruct = new HashMap<>();
        parameterMappings.stream()
                .sorted(
                        (t0, t1) -> {
                            //节点数据最长的放在前面 -排序
                            String[] t0NamePaths = t0.getName().split(".");
                            String[] t1NamePaths = t1.getName().split(".");
                            return t0NamePaths.length - t1NamePaths.length;
                        }
                ).forEach(actionParameterMapping -> {
                    String[] namePaths = actionParameterMapping.getName().split("\\.");
                    if (namePaths.length == 1) {
                        Entity entity = null;
                        if (!targetStruct.containsKey(namePaths[0])) {
                            entity = new Entity();
                            entity.setName(namePaths[0]);
                            targetStruct.put(namePaths[0], entity);
                        } else {
                            entity = targetStruct.get(namePaths[0]);
                        }
                        if (entity != null) {
                            if ("GET_ACTION_RESPONSE".equals(actionParameterMapping.getType())
                                    || "DATA_ROW".equals(actionParameterMapping.getType())) {
                                entity.setTypeConverter(actionParameterMapping.getTypeConverter());
                                entity.setSourceEntity(actionParameterMapping.getValue());
                            } else if ("CONSTANT".equals(actionParameterMapping.getType())
                                    || "TM_VARIABLE".equals(actionParameterMapping.getType())) {
                                entity.setValue(actionParameterMapping.getValue());
                                if("[]".equals(actionParameterMapping.getValue())){
                                    entity.setValue(new ArrayList<>());
                                }
                            }
                        }
                    } else if (namePaths.length > 1) {
                        Entity entity = null;
                        for (int i = 0; i < namePaths.length; i++) {
                            if (i == 0) {
                                if (!targetStruct.containsKey(namePaths[0])) {
                                    entity = new Entity();
                                    entity.setName(namePaths[0]);
                                    targetStruct.put(namePaths[0], entity);
                                } else {
                                    entity = targetStruct.get(namePaths[0]);
                                }
                            } else if (i < namePaths.length - 1) {
                                if (!entity.detail.containsKey(namePaths[i])) {
                                    Entity detailEntity = new Entity();
                                    detailEntity.setName(namePaths[i]);
                                    entity.detail.put(namePaths[i], detailEntity);
                                    entity = detailEntity;
                                } else {
                                    entity = entity.detail.get(namePaths[i]);
                                }
                            }
                            if (entity != null) {
                                if ("GET_ACTION_RESPONSE".equals(actionParameterMapping.getType())
                                        || "DATA_ROW".equals(actionParameterMapping.getType())
                                        || "ACTIVE_ROW".equals(actionParameterMapping.getType())
                                        || "TM_VARIABLE".equals(actionParameterMapping.getType())) {
                                    entity.setSourceEntity(actionParameterMapping.getValue().split("\\.")[0]);
                                }
                                if (i == namePaths.length - 1) {
                                    Field field = new Field();
                                    field.setActionParameterMapping(actionParameterMapping);
                                    field.setName(namePaths[i]);

                                    entity.getFields().add(field);
                                }
                            }
                        }
                    }
                }
        );
        //2、把数据转换成符合结构的数据
        // 暂时只处理平铺结构的转换
        return convert(data, null, targetStruct, action);

    }

    private static Map<String, Object> convert(Map<String, Object> data, Entity parent, Map<String, Entity> targetStruct,SubmitAction action) {
        Map<String, Object> paras = new HashMap<>();
        targetStruct.entrySet().stream()
                .forEach(
                        stringEntityEntry -> {
                            Entity entity = stringEntityEntry.getValue();
                            if (entity.getValue() != null) {
                                if ("true".equals(entity.getValue())
                                        || "false".equals(entity.getValue())) {
                                    paras.put(entity.getName(), Boolean.valueOf(String.valueOf(entity.getValue())));
                                } else {
                                    paras.put(entity.getName(), entity.getValue());
                                }

                                return;
                            }
                            String[] valuePaths = entity.getSourceEntity().split("\\.");
                            Map<String, Object> objectMap = data;
                            List<Map<String, Object>> dataList = new ArrayList<>();
                            boolean isArray = false;
                            for (String valuePath : valuePaths) {
                                if (objectMap.get(valuePath) instanceof List) {
                                    dataList = (List<Map<String, Object>>) objectMap.get(valuePath);
                                    isArray = true;
                                } else {
                                    objectMap = (Map<String, Object>) objectMap.get(valuePath);
                                    isArray = false;
                                }
                            }
                            if (entity.getFields().size() == 0) {
                                if (isArray) {
                                    paras.put(entity.getName(), dataList);
                                } else {
                                    if("objectToArrayConverter".equals(entity.getTypeConverter())){
                                        dataList.add(objectMap);
                                        paras.put(entity.getName(), dataList);
                                    }else{
                                        paras.put(entity.getName(), objectMap);
                                    }
                                }
                            } else {
                                //todo:需要判单是否为list
                                //如果dataList没有数据且objectMap不为null
                                if (!isArray && CollectionUtils.isEmpty(dataList) && MapUtils.isNotEmpty(objectMap)) {
                                    dataList.add(objectMap);
                                }
                                List<Map<String, Object>> paraItemValue = new ArrayList<>();
                                paras.put(entity.getName(), paraItemValue);
                                //如果没有明细，不需要做分组
                                if (entity.detail.size() == 0) {
                                    for (Map<String, Object> stringObjectMap : dataList) {
                                        Map<String, Object> paraItemRowValue = new HashMap<>();
                                        for (Field field : entity.getFields()) {
                                            setFieldValue(field, stringObjectMap, paraItemRowValue);
                                        }
                                        if (stringObjectMap.containsKey(DATA_STATUS_FLAG) && Boolean.TRUE.equals(action.getEnableCombinedPost())) {
                                            paraItemRowValue.put(DATA_STATUS_FLAG, stringObjectMap.get(DATA_STATUS_FLAG));
                                        }
                                        paraItemValue.add(paraItemRowValue);
                                    }

                                } else {
                                    //根据结构定义对平铺做分组
                                    Map<String, List<Map<String, Object>>> groupData = dataList.stream().collect(Collectors.groupingBy(item -> {
                                        String key = "";
                                        if (parent != null) {
                                            key += parent.getGroupKey();
                                        }
                                        for (Field field : entity.getFields()) {
                                            if ("GET_ACTION_RESPONSE".equals(field.getActionParameterMapping().getType())) {
                                                String[] namePaths = field.getActionParameterMapping().getValue().split("\\.");
                                                if (item.containsKey(namePaths[namePaths.length - 1])) {
                                                    key += item.get(namePaths[namePaths.length - 1]) + "~~~~~";
                                                }
                                            }
                                            if ("CONSTANT".equals(field.getActionParameterMapping().getType())) {
                                                key += field.getActionParameterMapping().getValue() + "~~~~~";
                                            }
                                        }
                                        return key;
                                    }));

                                    groupData.forEach((key, groupItem) -> {
                                        Map<String, Object> paraItemRowValue = new HashMap<>();
                                        Map<String, Object> item = groupItem.get(0);
                                        for (Field field : entity.getFields()) {
                                            setFieldValue(field, item, paraItemRowValue);
                                        }
                                        paraItemValue.add(paraItemRowValue);
                                        entity.setGroupKey(key);
                                        Map<String, Object> detailPara = convert(groupItem, entity, entity.detail);
                                        detailPara.forEach((itemKey, itemValue) -> {
                                            paraItemRowValue.put(itemKey, itemValue);
                                        });
                                    });
                                }
                            }
                        }
                );
        return paras;
    }

    private static void setFieldValue(Field field, Map<String, Object> stringObjectMap, Map<String, Object> paraItemRowValue) {
        if ("GET_ACTION_RESPONSE".equals(field.getActionParameterMapping().getType())
                || "DATA_ROW".equals(field.getActionParameterMapping().getType())
                || "ACTIVE_ROW".equals(field.getActionParameterMapping().getType())) {
             String[] namePaths = field.getActionParameterMapping().getValue().split("\\.");
             
            // 支持三层及以上结构解析
            paraItemRowValue.put(field.getName(), parseActionParamValue(stringObjectMap, namePaths));
        } else if ("CONSTANT".equals(field.getActionParameterMapping().getType())
                || "ACTIVE_ROW_CONSTANT".equals(field.getActionParameterMapping().getType())) {
            if ("true".equals(field.getActionParameterMapping().getValue())
                    || "false".equals(field.getActionParameterMapping().getValue())) {
                paraItemRowValue.put(field.getName(), Boolean.valueOf(field.getActionParameterMapping().getValue()));
            } else {
                Object paramValue = field.getActionParameterMapping().getValue();
                if(field.getActionParameterMapping().getTypeConverter() != null){
                    if("stringToBooleanConverter".equals(field.getActionParameterMapping().getTypeConverter())){
                        paramValue =  defaultConversionService.convert(paramValue.toString(),Boolean.TYPE);
                    }else if("stringToNumberConverter".equals(field.getActionParameterMapping().getTypeConverter())){
                        paramValue =  defaultConversionService.convert(paramValue.toString(),Integer.TYPE);
                    }
                }
                if(paramValue != null && "[]".equals(paramValue.toString())){
                    paramValue = new ArrayList<>();
                }
                paraItemRowValue.put(field.getName(), paramValue);
            }
        }
    }

    private static Object parseActionParamValue(Map map, String[] paths) {
        if (paths.length <= 2) {
            return map.get(paths[paths.length - 1]);
        }
            // 递归获取
        return parseActionParamValue(map, paths, 1);
    }

    private static Object parseActionParamValue(Map map, String[] paths, int pathIndex) {
        // 递归获取
        if (pathIndex >= paths.length - 1) {
            return map.get(paths[pathIndex]);
        } else {
            Object value = map.get(paths[pathIndex]);
            // 只支持 Map类型
            if(null == value){
                return  null;
            }
            if (value instanceof Map) {
                return parseActionParamValue((Map) value, paths, ++pathIndex);
            }else{
                return  null;
            }
        }
    }

    private static Map<String, Object> convert(List<Map<String, Object>> dataList, Entity parent, Map<String, Entity> targetStruct) {
        Map<String, Object> paras = new HashMap<>();
        targetStruct.entrySet().stream()
                .forEach(
                        stringEntityEntry -> {
                            Entity entity = stringEntityEntry.getValue();
                            List<Map<String, Object>> paraItemValue = new ArrayList<>();
                            paras.put(entity.getName(), paraItemValue);
                            //如果没有明细，不需要做分组
                            if (entity.detail.size() == 0) {
                                for (Map<String, Object> stringObjectMap : dataList) {
                                    Map<String, Object> paraItemRowValue = new HashMap<>();
                                    for (Field field : entity.getFields()) {
                                        setFieldValue(field, stringObjectMap, paraItemRowValue);
                                    }
                                    paraItemValue.add(paraItemRowValue);
                                }

                            } else {
                                //根据结构定义对平铺做分组
                                Map<String, List<Map<String, Object>>> groupData = dataList.stream().collect(Collectors.groupingBy(item -> {
                                    String key = "";
                                    if (parent != null) {
                                        key += parent.getGroupKey();
                                    }
                                    for (Field field : entity.getFields()) {
                                        if ("GET_ACTION_RESPONSE".equals(field.getActionParameterMapping().getType())
                                                || "DATA_ROW".equals(field.getActionParameterMapping().getType())) {
                                            String[] namePaths = field.getActionParameterMapping().getValue().split("\\.");
                                            if (item.containsKey(namePaths[namePaths.length - 1])) {
                                                key += item.get(namePaths[namePaths.length - 1]) + "~~~~~";
                                            }
                                        }
                                        if ("CONSTANT".equals(field.getActionParameterMapping().getType())) {
                                            key += field.getActionParameterMapping().getValue() + "~~~~~";
                                        }
                                    }
                                    return key;
                                }));

                                groupData.forEach((key, groupItem) -> {
                                    Map<String, Object> paraItemRowValue = new HashMap<>();
                                    Map<String, Object> item = groupItem.get(0);
                                    for (Field field : entity.getFields()) {
                                        setFieldValue(field, item, paraItemRowValue);
                                    }
                                    paraItemValue.add(paraItemRowValue);
                                    entity.setGroupKey(key);
                                    Map<String, Object> detailPara = convert(groupItem, entity, entity.detail);
                                    detailPara.forEach((itemKey, itemValue) -> {
                                        paraItemRowValue.put(itemKey, itemValue);
                                    });
                                });
                            }
                        }
                );
        return paras;
    }

    /**
     * 将两个map中key相同的value合并起来
     * @param map1------data
     * @param map2------paras
     * @return
     */
    public static Map combine(Map map1, Map map2) {
        try {
            Set set = map1.keySet();
            Iterator iterator = set.iterator();
            Object key = null;
            for (int index = 0; index < set.size(); index++) {
                key = iterator.next();
                Object valueTemp1 = map1.get(key);
                Object valueTemp2 = map2.get(key);
                if (null == valueTemp1 || null == valueTemp2) {
                    continue;
                }
                //合并对象常量
                if(valueTemp1 instanceof Map && valueTemp2 instanceof Map) {
                    Map value = new HashMap();
                    if (valueTemp1 instanceof Map) {
                        Map value1 = (Map) valueTemp1;
                        value.putAll(value1);
                    }
                    if (valueTemp2 instanceof Map) {
                        Map value2 = (Map) valueTemp2;
                        value.putAll(value2);
                    }
                    map1.put(key, value);
                }
                //合并数组常量
                if(valueTemp1 instanceof List && valueTemp2 instanceof List) {
                    //取出get(0)常量的值
                    if (valueTemp2 instanceof List && (((List<?>) valueTemp2).size() > 0)) {
                        Map value2 = (Map) ((List<?>) valueTemp2).get(0);
                        //获取data数组值
                        if (valueTemp1 instanceof List) {
                            List value1 = (List) valueTemp1;
                            for (Object rowData : value1) {
                                Map rowDataMap = (Map) rowData;
                                rowDataMap.putAll(value2);
                            }
                            map1.put(key, value1);
                        }
                    }
                }
            }
        }catch (Exception e){
        }
        return map1;
    }

    static class Entity {
        String Name;
        String groupKey;
        String sourceEntity;
        Object value;
        /**
         * value的类型转换器
         */
        private String typeConverter;
        List<Field> fields;
        Map<String, Entity> detail;

        public Entity() {

            detail = new HashMap<>();
            fields = new ArrayList<>();

        }

        public Object getValue() {
            return value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return Name;
        }

        public void setName(String name) {
            Name = name;
        }

        public String getGroupKey() {
            return groupKey;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public List<Field> getFields() {
            return fields;
        }

        public Map<String, Entity> getDetail() {
            return detail;
        }

        public String getSourceEntity() {
            return sourceEntity;
        }

        public void setSourceEntity(String sourceEntity) {
            this.sourceEntity = sourceEntity;
        }

        public String getTypeConverter() {
            return typeConverter;
        }

        public void setTypeConverter(String typeConverter) {
            this.typeConverter = typeConverter;
        }
    }

    static class Field {
        String name;

        Object value;
        ActionParameterMapping actionParameterMapping;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ActionParameterMapping getActionParameterMapping() {
            return actionParameterMapping;
        }

        public void setActionParameterMapping(ActionParameterMapping actionParameterMapping) {
            this.actionParameterMapping = actionParameterMapping;
        }
    }
}
