/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.datasource.process.ActivityUtils;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.workflow.CommonWorkflowService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowActionExecutor
implements ActionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowActionExecutor.class);
    @Autowired
    private CommonWorkflowService commonWorkflowService;

    public boolean hasActionMetadata() {
        return false;
    }

    public String supportKey() {
        return "workflow:";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        log.info("\u53d1\u8d77\u5de5\u4f5c\u6d41\u6d41\u7a0b:{}", (Object)JsonUtils.objectToString((Object)action));
        ExecuteResult ok = ExecuteResult.ok();
        ok.setCompleted(true);
        ActionServiceId serviceId = action.getServiceId();
        String name = serviceId.getName();
        Map paras = action.getParas();
        switch (name) {
            case "workflow-act-submit": 
            case "workflow-act-agree": 
            case "workflow-act-disagree": 
            case "workflow-act-add": 
            case "workflow-act-return": 
            case "workflow-act-dispatch": {
                ActivityUtils.addDispatchData((Map)paras, data);
                break;
            }
            case "workflow-abort": {
                serviceId.setServiceUri("api/process/abort");
                break;
            }
            case "workflow-invoke": {
                List mapList = ActivityUtils.addDispatchData((Map)paras, data);
                HashMap processEOC = Maps.newHashMapWithExpectedSize((int)2);
                processEOC.put("eoc_company_id", "");
                HashMap variables = Maps.newHashMapWithExpectedSize((int)2);
                Map map = null;
                if (mapList != null) {
                    map = (Map)mapList.get(0);
                    processEOC.put("eoc_company_id", MapUtils.getObject((Map)map, (Object)"eoc_company_id", (Object)""));
                    processEOC.put("eoc_site_id", map.get("eoc_site_id"));
                    if (map.containsKey("operation_unit_v2")) {
                        processEOC.put("operation_unit_v2", map.get("operation_unit_v2"));
                    }
                    variables.put("sourceIds", map.get("__DATA_KEY"));
                }
                serviceId.setServiceUri("api/process/invoke");
                paras.put("processEoc", processEOC);
                AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
                paras.put("initiatorId", authoredUser.getUserId());
                paras.put("initiatorName", authoredUser.getUserName());
                if (!paras.containsKey("emergency")) {
                    paras.put("emergency", 50);
                }
                paras.put("variables", variables);
                Map execute = this.commonWorkflowService.execute((Action)action);
                Map dataMap = MapUtils.getMap((Map)execute, (Object)"data");
                if (dataMap != null) {
                    Object serialNumber = dataMap.get("serialNumber");
                    log.info("\u53d1\u8d77\u9001\u5ba1\u83b7\u53d6\u6d41\u7a0b\u5e8f\u53f7:{}", serialNumber);
                    if (map != null) {
                        map.put("serial_number", serialNumber);
                    }
                }
                ok.setData(map);
                return ok;
            }
        }
        this.commonWorkflowService.execute((Action)action);
        return ok;
    }
}

