/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.subscriber;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsaSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsaSubscriber.class);
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private ApiErrorInfoService apiErrorInfoService;

    @Subscribe
    public void subscriber(AsaEvent event) {
        try {
            log.info("ApiErrorEvent:{}", (Object)JsonUtils.objectToString((Object)event));
            this.processEvent(event);
        }
        catch (Exception e) {
            log.error("asa api\u63d0\u4ea4\u62a5\u9519\u8bf7\u6c42\u548c\u4efb\u52a1\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff1aevent:{},error:{}", (Object)JsonUtils.objectToString((Object)event), (Object)e.getMessage());
        }
    }

    private void processEvent(AsaEvent event) {
        this.saveCallRecord(event.getExecuteContext(), event.getAction(), event.getResult(), event.getDataMap());
    }

    private void saveCallRecord(SubmitExecuteContext executeContext, SubmitAction action, HashMap result, Map dataMap) {
        log.info("EspActionExecutor-sendErrorInfo-executeContext:{}", (Object)JsonUtils.objectToString((Object)executeContext));
        log.info("EspActionExecutor-sendErrorInfo-dataMap:{}", (Object)JsonUtils.objectToString((Object)dataMap));
        if (null == executeContext || null == executeContext.getPtmData() || null == executeContext.getPtmData().get("ptmWorkItemId")) {
            log.error("EspActionExecutor-sendErrorInfo:ptmWorkItemId is null");
            return;
        }
        HashMap<String, Object> insertMap = new HashMap<String, Object>();
        insertMap.put("ptmBacklogId", executeContext.getPtmData().get("ptmBacklogId"));
        insertMap.put("ptmWorkItemId", executeContext.getPtmData().get("ptmWorkItemId"));
        insertMap.put("apiName", action.getServiceId().getName());
        insertMap.put("reqId", result.get("reqId"));
        insertMap.put("product", action.getServiceId().getProd());
        insertMap.put("taskDefCode", executeContext.getTmActivityId());
        insertMap.put("projectDefCode", executeContext.getTmProjectId());
        insertMap.put("tenantId", dataMap.get("tenant_id"));
        insertMap.put("targetTenantId", dataMap.get("target_tenant_id"));
        log.info("AsaSubscriber-insertMap:{}", (Object)JsonUtils.objectToString(insertMap));
        this.apiErrorInfoService.insertRequestWorkItem(executeContext.getTenantId(), insertMap);
    }
}

