/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=0)
@Service(value="filter-selected-data-action")
class FilterSelectedDataActionExecutor
implements ActionExecutor {
    @Autowired
    private MessageUtils messageUtils;

    FilterSelectedDataActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:filter-selected-data-action";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        Map extendParas = action.getExtendParas();
        if (MapUtils.isEmpty((Map)extendParas) || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0027.getErrCode(), (String)this.messageUtils.getMessage("exception.KG.action.submitVariableName"));
        }
        String submitVariableName = extendParas.get("submitVariableName").toString();
        if (!parameter.containsKey(submitVariableName)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0028.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data") + submitVariableName + this.messageUtils.getMessage("exception.check.KG.config")));
        }
        Object submitDataObj = parameter.get(submitVariableName);
        ArrayList<Map> datas = new ArrayList<Map>();
        if (null != submitDataObj) {
            if (submitDataObj instanceof Map) {
                datas.add((Map)submitDataObj);
            } else if (submitDataObj instanceof Collection) {
                datas.addAll((List)parameter.get(submitVariableName));
            } else {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0029.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data2") + submitVariableName + this.messageUtils.getMessage("exception.data.type.error")));
            }
        }
        if (0 == datas.size()) {
            return ExecuteResult.ok();
        }
        String detailField = null;
        if (extendParas.containsKey("detailField")) {
            detailField = extendParas.get("detailField").toString();
        }
        ArrayList<Map> selectedRows = new ArrayList<Map>();
        for (Map data : datas) {
            if (data.containsKey("uibot_checked")) {
                ArrayList<Map> selectedDetail;
                List detail;
                if (this.isChecked(data)) {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)MapUtil.get((Map)data, (Object)detailField, List.class)))) {
                        detail = (List)data.get(detailField);
                        selectedDetail = new ArrayList<Map>();
                        for (Map detailItem : detail) {
                            if (!this.isChecked(detailItem)) continue;
                            selectedDetail.add(detailItem);
                        }
                        if (selectedDetail.isEmpty()) continue;
                        data.put(detailField, selectedDetail);
                        selectedRows.add(data);
                        continue;
                    }
                    selectedRows.add(data);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)MapUtil.get((Map)data, (Object)detailField, List.class)))) continue;
                detail = (List)data.get(detailField);
                selectedDetail = new ArrayList();
                for (Map detailItem : detail) {
                    if (!this.isChecked(detailItem)) continue;
                    selectedDetail.add(detailItem);
                }
                if (selectedDetail.isEmpty()) continue;
                data.put(detailField, selectedDetail);
                selectedRows.add(data);
                continue;
            }
            selectedRows = datas;
            break;
        }
        parameter.put(submitVariableName, selectedRows);
        return ExecuteResult.ok();
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (submitExecuteContext.isMinSplit() && actionExecuteReq.getWorkItemIdToData() != null) {
            Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
            workItemIdToData.forEach((k, v) -> this.execute(submitExecuteContext, actionExecuteReq.getParentExecuteResult(), actionExecuteReq.getAction(), (Map<String, Object>)v));
        }
        return super.execute(actionExecuteReq);
    }

    boolean isChecked(Map<String, Object> data) {
        Object checkedValue;
        if (data.containsKey("uibot_checked") && (checkedValue = data.get("uibot_checked")) != null && checkedValue instanceof Boolean) {
            return (Boolean)checkedValue;
        }
        return false;
    }
}

