/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecycleDeleteExecutor
implements ActionExecutor {
    @Autowired
    private CommonRecycleService commonRecycleService;

    public String supportKey() {
        return "RECYCLE:recycle.delete";
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        List<Map<String, Object>> submitDataList = this.getSubmitDataList(data);
        if (CollectionUtils.isEmpty(submitDataList)) {
            return ExecuteResult.ok();
        }
        this.commonRecycleService.deleteRecycle(executeContext.getAuthoredUser(), executeContext.getTmActivityId(), submitDataList);
        return ExecuteResult.ok();
    }

    private List<Map<String, Object>> getSubmitDataList(Map<String, Object> data) {
        if (MapUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        Optional<Object> dataOptional = data.values().stream().findFirst();
        if (dataOptional.isPresent()) {
            return (List)dataOptional.get();
        }
        return Collections.emptyList();
    }
}

