package com.digiwin.athena.base.sdk.db.infrastructure.meta.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Supplier;

@Slf4j
@Component
public class BaseEntityMetaObjectHandler implements MetaObjectHandler {
    @Override
    public void insertFill(MetaObject metaObject) {
        log.info("start insert fill ....");
        Supplier<Object> supplier = () -> LocalDateTime.now();
        this.myStrictFillStrategy(metaObject, "createDate", supplier); // 起始版本 3.3.0(推荐使用)
        this.myStrictFillStrategy(metaObject, "modifyDate", supplier); // 起始版本 3.3.0(推荐使用)
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        log.info("start update fill ....");
        Supplier<Object> supplier = () -> LocalDateTime.now();
        this.myStrictFillStrategy(metaObject, "modifyDate", supplier); // 起始版本 3.3.0(推荐使用)
    }

    void myStrictFillStrategy(MetaObject metaObject, String fieldName, Supplier<Object> fieldVal) {
        Object obj = fieldVal.get();
        if (Objects.nonNull(obj)) {
            metaObject.setValue(fieldName, obj);
        }
    }
}
