package com.digiwin.athena.base.sdk.db.infrastructure.meta.injector;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.injector.methods.InsertBatchSomeColumn;

import java.util.List;

public class BatchInsertSqlInjector extends DefaultSqlInjector {
    //参考： https://cloud.tencent.com/developer/article/1711690

    @Override
    public List<AbstractMethod> getMethodList(Class<?> mapperClass, TableInfo tableInfo) {
        // super.getMethodList() 保留 Mybatis Plus 自带的方法
        List<AbstractMethod> methodList = super.getMethodList(mapperClass, tableInfo);
        // 添加自定义方法：批量插入，方法名为 insertBatchSomeColumn 注意：只在mysql下测试过
        methodList.add(new InsertBatchSomeColumn());
        return methodList;
    }
}
