package com.digiwin.athena.itsys.api.service.impl;

import com.digiwin.athena.itsys.api.service.IDataCleanService;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/5/9 16:51
 */
public class DataCleanService implements IDataCleanService {
    private static final Logger LOG = LoggerFactory.getLogger(DataCleanService.class);
    @Autowired
    private SessionFactory sessionFactory;

    private HibernateTemplate hibernateTemplate;

    @Override
    public String deleteErrorByAppId(String appId, String endDate, Integer limit) {
        try {
            Date end = DateUtils.parseDate(endDate, "yyyy-MM-dd");
            for (int i = 0; i < 10000; i++) {
                int deleteCount = getHibernateTemplate().execute(new HibernateCallback<Integer>() {
                    @Override
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createNativeQuery("delete FROM error_log where created_time < :endDate and app_id = :appId order by id limit :count");
                            tQuery.setParameter("endDate", end);
                            tQuery.setParameter("appId", appId);
                            tQuery.setParameter("count", limit);
                            return tQuery.executeUpdate();
                        } finally {
                            tx.commit();
                        }
                    }
                });
                if (deleteCount < limit) {
                    return "delete success";
                }
            }
            LOG.info("cleanErrorByAppId 执行成功");
        } catch (ParseException e) {
            LOG.error("cleanErrorByAppId 异常", e);
            throw new RuntimeException(e);
        }
        return "delete success";
    }

    @Override
    public String deleteCompleteProject(String endDate, Integer limit) {
        try {
            Date end = DateUtils.parseDate(endDate, "yyyy-MM-dd");
            int size = 0;
            for (int i = 0; i < 10000; i++) {
                List<ProjectLog> projects = getHibernateTemplate().execute(new HibernateCallback<List<ProjectLog>>() {
                    @Override
                    public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                        StringBuilder tHqlSB = new StringBuilder();
                        tHqlSB.append("select processSerialNumber as processSerialNumber from ProjectLog where " +
                                " appId = :appId and state = :state " +
                                " and createdTime < :endDate order by id");
                        Query tQuery = pSession.createQuery(tHqlSB.toString());
                        tQuery.setResultTransformer(Transformers.aliasToBean(ProjectLog.class));
                        tQuery.setParameter("appId", AppTypeEnum.TASKENGINE.getType());
                        tQuery.setParameter("state", 3);
                        tQuery.setParameter("endDate", end);
                        tQuery.setMaxResults(limit);
                        return tQuery.getResultList();
                    }
                });
                if (null == projects || projects.size() == 0) {
                    LOG.info("deleteCompleteProject success,deleted project size {}", size);
                    return "delete success";
                }
                Set<String> serialNumbers = projects.stream().map(one -> one.getProcessSerialNumber()).collect(Collectors.toSet());
                size += serialNumbers.size();
                getHibernateTemplate().execute(new HibernateCallback<Integer>() {
                    @Override
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ProjectLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", serialNumbers);
                            return tQuery.executeUpdate();
                        } finally {
                            tx.commit();
                        }
                    }
                });
                getHibernateTemplate().execute(new HibernateCallback<Integer>() {
                    @Override
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ErrorMessage where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", serialNumbers);
                            return tQuery.executeUpdate();
                        } finally {
                            tx.commit();
                        }
                    }
                });
                getHibernateTemplate().execute(new HibernateCallback<Integer>() {
                    @Override
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM TaskLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", serialNumbers);
                            return tQuery.executeUpdate();
                        } finally {
                            tx.commit();
                        }
                    }
                });
                getHibernateTemplate().execute(new HibernateCallback<Integer>() {
                    @Override
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ActivityLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", serialNumbers);
                            return tQuery.executeUpdate();
                        } finally {
                            tx.commit();
                        }
                    }
                });
                if (serialNumbers.size() < limit) {
                    LOG.info("deleteCompleteProject success,deleted project size {}", size);
                    return "delete success";
                }
            }
        } catch (ParseException e) {
            LOG.error("deleteCompleteProject 异常", e);
            throw new RuntimeException(e);
        }
        return "delete success";
    }

    public HibernateTemplate getHibernateTemplate() {
        if (null == hibernateTemplate) {
            hibernateTemplate = new HibernateTemplate(sessionFactory);
        }
        return hibernateTemplate;
    }
}
