package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ErrorNotificationUserDao;
import com.digiwin.athena.itsys.dao.NotificationUserChangeLogDao;
import com.digiwin.athena.itsys.enums.ErrorNotificationEnum;
import com.digiwin.athena.itsys.model.ErrorNotificationUser;
import com.digiwin.athena.itsys.model.NotificationUserChangeLog;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

@Service
public class ErrorNotificationProcessor {

	@Autowired
	ErrorNotificationUserDao errorNotificationUserDao;

	@Autowired
	NotificationUserChangeLogDao notificationUserChangeLogDao;

	ObjectMapper mapper = new ObjectMapper();

	protected final Log log = LogFactory.getLog(getClass());

	public Map<String, Object> setUserSend(String tenantId, String userSend, String toggle)
			throws JsonParseException, JsonMappingException, IOException {

		NotificationUserChangeLog notificationUserChangeLog = new NotificationUserChangeLog();

		ArrayNode userSendArrayNode = mapper.createArrayNode();

		userSendArrayNode = (ArrayNode) mapper.readTree(userSend);

		List<String> userList = new ArrayList<String>();

		for (JsonNode userIdNode : userSendArrayNode) {
			userList.add(userIdNode.asText().trim());
		}

		if (toggle.equals(ErrorNotificationEnum.ON.getCode())) {

			for (String userId : userList) {
				if (errorNotificationUserDao.getErrorNotificationUserByUserandTenantId(userId, tenantId).isEmpty()) {
					ErrorNotificationUser user = new ErrorNotificationUser();
					user.setUserId(userId);
					user.setTenantId(tenantId);
					user.setBuildTime(Calendar.getInstance());
					errorNotificationUserDao.save(user);

					notificationUserChangeLog.setTenantId(tenantId);
					notificationUserChangeLog.setUserId(userId);
					notificationUserChangeLog.setBuildTime(Calendar.getInstance());
					notificationUserChangeLog.setOperation(ErrorNotificationEnum.ON.getCode());
					notificationUserChangeLogDao.save(notificationUserChangeLog);
				}
			}

		} else if (toggle.equals(ErrorNotificationEnum.OFF.getCode())) {
			for (String userId : userList) {
				List<ErrorNotificationUser> notificationUsers = errorNotificationUserDao
						.getErrorNotificationUserByUserandTenantId(userId, tenantId);
				if (!notificationUsers.isEmpty()) {
					errorNotificationUserDao.remove(notificationUsers.get(0).getId());

					notificationUserChangeLog.setTenantId(tenantId);
					notificationUserChangeLog.setUserId(userId);
					notificationUserChangeLog.setBuildTime(Calendar.getInstance());
					notificationUserChangeLog.setOperation(ErrorNotificationEnum.OFF.getCode());
					notificationUserChangeLogDao.save(notificationUserChangeLog);
				}
			}
		}

		Map tReturn = new HashMap<String, String>();
		tReturn.put("result", "success");

		return tReturn;
	}

	public Map<String, Object> checkUserSendInfo(String tenantId, String userId)
			throws JsonParseException, JsonMappingException, IOException {

		ObjectNode outerNode = mapper.createObjectNode();

		List<ErrorNotificationUser> users = errorNotificationUserDao.getErrorNotificationUserByUserandTenantId(userId,
				tenantId);

		if (users.isEmpty()) {
			outerNode.put(ErrorNotificationEnum.TOGGLE.getCode(), ErrorNotificationEnum.OFF.getCode());
		} else {
			outerNode.put(ErrorNotificationEnum.TOGGLE.getCode(), ErrorNotificationEnum.ON.getCode());
		}

		Map tReturn = new HashMap<String, String>();
		tReturn.put("result", outerNode.toString());

		return tReturn;
	}
}
