package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.dao.*;
import com.digiwin.athena.itsys.enums.*;
import com.digiwin.athena.itsys.model.*;
import com.digiwin.athena.itsys.service.JsonManipulateService;
import com.digiwin.athena.itsys.service.LogManipulateService;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 任務查詢視角查詢處理 /restful/service/itsys/processLog/view
 */
@Service
public class ExecutionViewProcessor {

	@Autowired
	private ErrorMessageDao errorMessageDao;
	@Autowired
	private ProcessLogDao processLogDao;
	@Autowired
	private ProjectLogDao projectLogDao;
	@Autowired
	private ActivityLogDao activityLogDao;
	@Autowired
	private TaskLogDao taskLogDao;
	@Autowired
	private MonitorLogDao monitorLogDao;
	@Autowired
	private ErrorSummaryDao errorSummaryDao;
	@Autowired
	private LogManipulateService logManipulateService;
	@Autowired
	private JsonManipulateService jsonManipulateService;

	protected final Log log = LogFactory.getLog(getClass());
	ObjectMapper mapper = new ObjectMapper();
	private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");
	private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";
	private static String TASKENGINE_URL = DWApplicationConfigUtils.getProperty("taskengine.url");
	private static String RETRY_ERROR_CODE = DWApplicationConfigUtils.getProperty("retry.error.code");

	public Map<String, Object> execute(String tenantId, String sourceId, String queryStartDate, String queryEndDate,
			String condition, String ruleCode, String createdTime, String processSerialNumber)
			throws JsonParseException, JsonMappingException, IOException, ParseException, DWHttpFailedException,
			URISyntaxException {

		Map<String, Object> outerNode = new HashMap<>();
		List<Map<String, Object>> sourceIdInfoArynode = new ArrayList<>();
		sourceId = sourceId.trim();

		if (StringUtil.isEmptyOrSpace(sourceId) && StringUtil.isEmptyOrSpace(ruleCode)
				&& StringUtil.isEmptyOrSpace(processSerialNumber)) {
			// 執行視角沒有輸入單號
			return fullSearch(tenantId, queryStartDate, queryEndDate, condition);
		}

		/** 執行視角有輸入單號 **/
		sourceIdInfoArynode = sourceNoSearch(sourceIdInfoArynode, tenantId, queryStartDate, queryEndDate, condition,
				sourceId, ruleCode, createdTime, processSerialNumber);

		Map tReturn = new HashMap<String, String>();
		tReturn.put("list", sourceIdInfoArynode);

		return tReturn;
	}

	/**
	 * 執行視角查詢沒有輸入單號
	 */
	private Map<String, Object> fullSearch(String pTenantId, String pQueryStartDate, String pQueryEndDate,
			String pCondition)
			throws ParseException, DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException {

		Map<String, Object> outerNode = new HashMap<>();
		List<Map<String, Object>> sourceIdInfoArynode = new ArrayList<>();

		// (舊)搜尋類型，預設用blocked
		// (新)搜尋類型，如果前端畫面沒有指定搜尋類型，則預設用類型"異常"=ExecutionViewSearchEnum.STUCK
		// 以下三種appId拋的it_sys_error消息都屬於分類"異常"
		// AppTypeEnum.BPMCLOUD
		// AppTypeEnum.TASKENGINE
		// AppTypeEnum.ATMC
		if (StringUtil.isEmptyOrSpace(pCondition)) {
			pCondition = ExecutionViewSearchEnum.STUCK.getType();
		}

		/** (舊) 搜尋類型"阻塞"、"有問題" **/
		/** (新) 搜尋類型"異常"=ExecutionViewSearchEnum.STUCK **/
		if (pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {

			sourceIdInfoArynode = generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate,
					pCondition);

			/** 搜尋類型"正常" **/
		} else if (pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
			sourceIdInfoArynode = generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate,
					pCondition);
			sourceIdInfoArynode = generateSuccessResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate,
					pCondition);

			/** 搜尋類型"全部" **/
		} else if (pCondition.equals(ExecutionViewSearchEnum.TOTAL.getType())) {

			sourceIdInfoArynode = generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate,
					pCondition);
			sourceIdInfoArynode = generateSuccessResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate,
					pCondition);

		}

		// 舊
		// sourceIdInfoArynode =
		// jsonManipulateService.sortJsonArrayByAttribute(sourceIdInfoArynode,
		// LogAttributeEnum.DETECT_TIME.getAttribute());

		// 新
		sourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(sourceIdInfoArynode,
				LogAttributeEnum.CREATED_TIME.getAttribute(), true);

		Map tReturn = new HashMap<String, String>();
		tReturn.put("list", sourceIdInfoArynode);

		return tReturn;
	}

	/** 設定問題描述與解決方案 **/
	private void setExceptionContentAndSolution(Map<String, Object> pTargetNode, ErrorMessage pErrorMessage, String pLocale) {
		List<ErrorSummary> errorSummaries = errorSummaryDao.getErrorSummaryByCode(pErrorMessage.getErrorCode());
		ErrorSummary tErrorSummary;

		// 有對應的異常分類
		if (errorSummaries != null && errorSummaries.size() != 0) {
			tErrorSummary = errorSummaries.get(0);
			// 根據前端語系選擇回傳對應語系的異常原因
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
				break;
			case "en_US":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
				break;
			default:
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
				break;
			}
		}
		// 無對應的異常分類
		else {
			errorSummaries = errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
			tErrorSummary = errorSummaries.get(0);

			// 根據前端語系選擇回傳對應語系的異常原因
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
				break;
			case "en_US":
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
				break;
			default:
				pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
				break;
			}
		}

		if (pErrorMessage.getApiErrorInfo() != null) {
			pTargetNode.put("hasErrorInfo", Boolean.TRUE);
			pTargetNode.put("apiErrorInfo", pErrorMessage.getApiErrorInfo());
			pTargetNode.put("apiErrorInfoMetadata", pErrorMessage.getApiErrorInfoMetadata());
			pTargetNode.put("healthState", "normal");

		} else {
			pTargetNode.put("hasErrorInfo", Boolean.FALSE);

			// 沒有重試url就顯示聯繫客服
			if (StringUtil.isEmptyOrSpace(pErrorMessage.getRetryUrl())) {
				pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());

				// 有重試url
			} else {
				// 有actionId代表是呼叫API型錯誤
				if (!StringUtil.isEmptyOrSpace(pErrorMessage.getActionId())) {
					// 如果冪等性為true才做重送按鈕
					if (pErrorMessage.isIdempotency()) {
						pTargetNode.put("solution", ExecutionViewSearchEnum.REEXECUTE.getType());

						try {

							JsonNode jsonNode = mapper.readTree(pErrorMessage.getRetryUrl());

							pTargetNode.put("reExecuteUrl", TASKENGINE_URL + jsonNode.get("url").asText());
							pTargetNode.put("requestBody", jsonNode.get("requestBody").toString());
							pTargetNode.put("requestToken", pErrorMessage.getToken());
						} catch (Exception e) {
							log.error(e.getMessage(), e);
						}

					} else {
						pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
					}
					// 沒有actionId代表是非呼叫API型錯誤，就直接做重送按鈕
				} else {

					try {

						if (RETRY_ERROR_CODE.contains(tErrorSummary.getCode())) {

							JsonNode jsonNode = mapper.readTree(pErrorMessage.getRetryUrl());

							if (jsonNode.get("url").asText().equals("/v1/projects/re-invoke-project")) {
								pTargetNode.put("solution", ExecutionViewSearchEnum.RE_PUBLISH_PROJECT.getType());
							} else if (jsonNode.get("url").asText().equals("/v1/tasks/activity/restart")) {
								pTargetNode.put("solution", ExecutionViewSearchEnum.RESTART.getType());
							} else {
								// pTargetNode.put("solution", ExecutionViewSearchEnum.REEXECUTE.getType());
								pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
							}

							pTargetNode.put("reExecuteUrl",
									TASKENGINE_URL + "/restful/standard/taskengine" + jsonNode.get("url").asText());

							pTargetNode.put("requestBody", jsonNode.get("requestBody").toString());
							pTargetNode.put("requestToken", pErrorMessage.getToken());

						} else {
							pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
						}
					} catch (Exception e) {
						log.error(e.getMessage(), e);
					}
				}
			}

			pTargetNode.put("processSerialNumber", pErrorMessage.getProcessSerialNumber());
			pTargetNode.put("processActivityId", pErrorMessage.getProcessActivityId());
			pTargetNode.put("processActivityOid", pErrorMessage.getProcessActivityOid());
//			pTargetNode.put("exceptionDetail", pErrorMessage.getException());
		}
	}

	/** 根據語系設定應用名稱 **/
	private void setAppNameByLocale(Map<String, Object> pTargetNode, Object pLog, String pLocale) {

		if (pLog == null) {
			pTargetNode.put("appName", "");
		} else if (pLog instanceof MonitorLog) {
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("appName", ((MonitorLog) pLog).getAppNameZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("appName", ((MonitorLog) pLog).getAppNameZhCn());
				break;
			case "en_US":
				pTargetNode.put("appName", ((MonitorLog) pLog).getAppNameEnUs());
				break;
			default:
				pTargetNode.put("appName", ((MonitorLog) pLog).getAppNameZhCn());
				break;
			}
		} else if (pLog instanceof ProjectLog) {
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("appName", ((ProjectLog) pLog).getAppNameZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("appName", ((ProjectLog) pLog).getAppNameZhCn());
				break;
			case "en_US":
				pTargetNode.put("appName", ((ProjectLog) pLog).getAppNameEnUs());
				break;
			default:
				pTargetNode.put("appName", ((ProjectLog) pLog).getAppNameZhCn());
				break;
			}
		}
	}

	/** 根據語系設定項目名稱 **/
	private void setProjectNameByLocale(Map<String, Object> pTargetNode, ProjectLog pProjectLog, String pLocale) {
		if (pProjectLog == null) {
			pTargetNode.put("projectName", "");
		} else {
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("projectName", pProjectLog.getProjectNameZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("projectName", pProjectLog.getProjectNameZhCn());
				break;
			case "en_US":
				pTargetNode.put("projectName", pProjectLog.getProjectNameEnUs());
				break;
			default:
				pTargetNode.put("projectName", pProjectLog.getProjectNameZhCn());
				break;
			}
		}
	}

	/** 根據語系設定任務名稱 **/
	private void setTaskNameByLocale(Map<String, Object> pTargetNode, TaskLog pTaskLog, String pLocale) {

		if (pTaskLog == null) {
			pTargetNode.put("taskName", "");
		} else {
			switch (pLocale) {
			case "zh_TW":
				pTargetNode.put("taskName", pTaskLog.getTaskNameZhTw());
				break;
			case "zh_CN":
				pTargetNode.put("taskName", pTaskLog.getTaskNameZhCn());
				break;
			case "en_US":
				pTargetNode.put("taskName", pTaskLog.getTaskNameEnUs());
				break;
			default:
				pTargetNode.put("taskName", pTaskLog.getTaskNameZhCn());
				break;
			}
		}
	}

	private List<Map<String, Object>> generateStuckResult(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate,
			String pQueryEndDate, String pCondition) throws ParseException {

		// 取得前端語系
		String tLocale;
		tLocale = (String) DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
		if (StringUtil.isEmptyOrSpace(tLocale)) {
			tLocale = "";
		}

		log.info("執行視角前端查詢語系：" + tLocale);

		List<ErrorMessage> errorMessages;
		List<ProjectLog> projectLogs;
		List<MonitorLog> monitorLogs;

		List<String> serialNumbers = new ArrayList<String>();
		List<String> traceIds = new ArrayList<String>();

		Map<String, List<ErrorMessage>> errorMessageMapByTraceId = new HashMap<>();
		Map<String, List<ErrorMessage>> errorMessageMapBySerialNumber = new HashMap<>();

		Map<String, List<ProjectLog>> projectLogMapBySerialNumber = new HashMap<String, List<ProjectLog>>();
		Map<String, List<MonitorLog>> monitorLogMapByTraceId = new HashMap<String, List<MonitorLog>>();

		Map<String, String> conditionMap = new HashMap<String, String>();

		// 租戶ID
		if (!StringUtil.isEmptyOrSpace(pTenantId)) {
			conditionMap.put("tenant_id", pTenantId);
			conditionMap.put(ProjectLogConditionEnum.TENANT_ID.toString(), pTenantId);
		}

		// 日期區間
		if (!StringUtil.isEmptyOrSpace(pQueryStartDate) && !StringUtil.isEmptyOrSpace(pQueryEndDate)) {
			conditionMap.put("query_start_date", pQueryStartDate);
			conditionMap.put("query_end_date", pQueryEndDate);
		}

		conditionMap.put("condition", "stuck");
		conditionMap.put("is_error", String.valueOf(Boolean.TRUE));

		// 尚未解決的異常[errorMessages]
		errorMessages = errorMessageDao.fetch(conditionMap);

		if (errorMessages != null && pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {
			List<ErrorMessage> tRemoveApiErrorMessages = new ArrayList<ErrorMessage>();
			for (ErrorMessage errorMessage : errorMessages) {
				if (!"P.ATDM.560.0001".equals(errorMessage.getErrorCode())) {
					tRemoveApiErrorMessages.add(errorMessage);
				}
			}
			errorMessages = tRemoveApiErrorMessages;
		} else if (errorMessages != null && pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
			List<ErrorMessage> tRemoveApiErrorMessages = new ArrayList<>();
			for (ErrorMessage errorMessage : errorMessages) {
				if ("P.ATDM.560.0001".equals(errorMessage.getErrorCode())) {
					tRemoveApiErrorMessages.add(errorMessage);
				}
			}
			errorMessages = tRemoveApiErrorMessages;
		}

		// 用process_serial_number將異常分組[errorMessageMapBySerialNumber]
		errorMessageMapBySerialNumber = logManipulateService.mapErrorMessageByType(errorMessages,
				MappingTypeEnum.SERIAL_NUMBER.getType());

		// 取得異常的所有process_serial_number[serialNumbers]
		for (String serialNumber : errorMessageMapBySerialNumber.keySet()) {
			serialNumbers.add(serialNumber);
		}

		// 用所有process_serial_number取得對應的項目[projectLogs]，不區分項目狀態
		projectLogs = projectLogDao.getProjectLogsBySerialNumbers(serialNumbers, pTenantId);

		// 用process_serial_number將項目分組[projectLogMapBySerialNumber]
		projectLogMapBySerialNumber = logManipulateService.mapProjectLogByType(projectLogs,
				MappingTypeEnum.SERIAL_NUMBER.getType());

		// 將projectLogMapBySerialNumber中重複的projectLog剃除
		logManipulateService.sortLatestProjectLog(projectLogMapBySerialNumber);

		// 用trace_id將異常分組[errorMessageMapByTraceId]
		errorMessageMapByTraceId = logManipulateService.mapErrorMessageByType(errorMessages,
				MappingTypeEnum.TRACE_ID.getType());

		// 取得異常的所有偵測ID[traceIds]
		for (String traceId : errorMessageMapByTraceId.keySet()) {
			traceIds.add(traceId);
		}

		// 用所有偵測ID取得對應的偵測資訊[monitorLogs]
		monitorLogs = monitorLogDao.getMonitorLogsByTraceIds(traceIds, pTenantId);

		monitorLogMapByTraceId = logManipulateService.mapMonitorLogByType(monitorLogs,
				MappingTypeEnum.TRACE_ID.getType());

		logManipulateService.sortLatestMonitorLog(monitorLogMapByTraceId);

		List<TaskLog> tAllTaskLogs = taskLogDao.getTaskLogsBySerialNumbers(serialNumbers);

		List<ActivityLog> tAllActivityLogs = activityLogDao.getActivityLogsBySerialNumbers(serialNumbers);

		for (String serialnumber : errorMessageMapBySerialNumber.keySet()) {

			// 檢查異常是否對應偵測log[monitorLogExist]
			boolean monitorLogExist = false;

			for (String traceId : monitorLogMapByTraceId.keySet()) {

				MonitorLog monitorLog = monitorLogMapByTraceId.get(traceId).get(0);

				// 異常有對應偵測
				if (monitorLog.getTraceId()
						.equals(errorMessageMapBySerialNumber.get(serialnumber).get(0).getTraceId())) {

					// 有偵測為true
					monitorLogExist = true;

					// 異常有對應項目，同時必須滿足該項目為進行中的項目
					if (projectLogMapBySerialNumber.get(serialnumber) != null
							&& !projectLogMapBySerialNumber.get(serialnumber).isEmpty()
							&& (projectLogMapBySerialNumber.get(serialnumber).get(0).getState() == 1
									|| projectLogMapBySerialNumber.get(serialnumber).get(0).getState() == 2)) {

						// 用process_serial_number做分組的異常，errorMessageMapBySerialNumber，逐該serialnumber的每筆異常errorMessage
						for (ErrorMessage errorMessage : errorMessageMapBySerialNumber.get(serialnumber)) {

							// 對應項目log[projectLog]
							ProjectLog projectLog = projectLogMapBySerialNumber.get(serialnumber).get(0);

							// 建立項目層級Node[projectLogNode]
							Map<String, Object> projectLogNode = new HashMap<>();
							// 建立任務層級arrayNode[rowDataAryNode]
							// ArrayNode rowDataAryNode = mapper.createArrayNode();
							// projectLogNode.put("rowData", rowDataAryNode);
							// pSourceIdInfoArynode.add(projectLogNode);

							// 建立時間[項目層級]
							projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
									formatToSecond.format(projectLog.getCreatedTime().getTime()));
							// 健康狀態[項目層級]
							projectLogNode.put("healthState", "abnormal");
							// 應用[項目層級]
							setAppNameByLocale(projectLogNode, monitorLog, tLocale);
							// 項目[項目層級]
							setProjectNameByLocale(projectLogNode, projectLog, tLocale);
							// 項目ID[項目層級]
							projectLogNode.put("projectId", projectLog.getProjectId());
							// 項目卡ID[項目層級]
							projectLogNode.put("projectCardId", projectLog.getProjectCardId());
							// 當前任務[項目層級] TODO

							// 任務類型[項目層級]
							projectLogNode.put("activityType", "auto");
							// 任務狀態[項目層級]
							if (projectLog.getState() == 1 || projectLog.getState() == 2) {
								projectLogNode.put("taskState", "continued");
							} else if (projectLog.getState() == 3) {
								projectLogNode.put("taskState", "finished");
							}
							// 源數據[項目層級]
							projectLogNode.put("source_no", projectLog.getSourceIds());
							// traceId[項目層級]
							projectLogNode.put("traceId", monitorLog.getTraceId());
							// appCode[項目層級]
							projectLogNode.put("appCode", monitorLog.getAppCode());
							// ruleCode
							projectLogNode.put("ruleCode", monitorLog.getRuleCode());
							// 异常时间
							// 异常时间
							projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));

							// 此異常有taskUid
							if (!StringUtil.isEmptyOrSpace(errorMessage.getTaskUid())) {

								// 找出異常對應的任務，taskengine、ptm的紀錄都找
								Map<String, String> tTaskCondition = new HashMap<String, String>();
								tTaskCondition.put(TaskLogConditionEnum.TASK_UID.toString(), errorMessage.getTaskUid());

								List<TaskLog> taskLogs = logManipulateService.getTargetTaskLogs(tAllTaskLogs,
										tTaskCondition);

								TaskLog taskLog = null;

								if (taskLogs != null && !taskLogs.isEmpty()) {
									taskLog = logManipulateService.getLatestTaskLog(taskLogs);
								}

								// 有找到對應任務
								if (taskLog != null) {

									// 找出任務對應活動，一個任務有多個活動，要找到對應報錯的活動(用process_activity_oid)，只找ptm紀錄
									Map<String, String> tActivityCondition = new HashMap<String, String>();

									tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
									tActivityCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
											errorMessage.getProcessActivityOid());
									// 取最新的紀錄
									tActivityCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");

									List<ActivityLog> activitiLogs = logManipulateService
											.getTargetActivityLogs(tAllActivityLogs, tActivityCondition);

									ActivityLog activityLog = null;

									// 有找到該任務對應的多個活動
									if (activitiLogs != null && !activitiLogs.isEmpty()) {
										activityLog = activitiLogs.get(0);
									}

									// 建立任務層級Node[taskNode]
									Map<String, Object> taskLogNode = new HashMap<>();
									// 异常时间
									taskLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));

									if (activityLog != null) {
										// 建立時間[任務層級]
										taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
												formatToSecond.format(activityLog.getCreatedTime().getTime()));
									} else {
										// 建立時間[任務層級]
										taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
												formatToSecond.format(taskLog.getCreatedTime().getTime()));
									}

									// 健康狀態[任務層級]
									taskLogNode.put("healthState", "abnormal");
									// 應用[任務層級]
									setAppNameByLocale(taskLogNode, monitorLog, tLocale);
									// appCode
									taskLogNode.put("appCode", monitorLog.getAppCode());
									// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
									taskLogNode.put("projectCardId", projectLog.getProjectCardId());
									// ruleCode
									taskLogNode.put("ruleCode", monitorLog.getRuleCode());
									// 項目[任務層級]
									setProjectNameByLocale(taskLogNode, projectLog, tLocale);
									// 當前任務[任務層級]
									setTaskNameByLocale(taskLogNode, taskLog, tLocale);
									// 當前任務[項目層級]
									if (taskLog.getState() == 1 || taskLog.getState() == 2) {
										setTaskNameByLocale(projectLogNode, taskLog, tLocale);
									}

									if (activityLog != null) {
										// 任務類型[任務層級]
										taskLogNode.put("activityType", activityLog.getActivityType());
									} else {
										// 任務類型[任務層級]
										taskLogNode.put("activityType", "");
									}

									if (activityLog != null) {
										// 任務狀態[任務層級]
										if (activityLog.getState() == 1 || activityLog.getState() == 2) {
											taskLogNode.put("taskState", "continued");
										} else if (activityLog.getState() == 3) {
											taskLogNode.put("taskState", "finished");
										}
									} else {
										// 任務狀態[任務層級]
										if (taskLog.getState() == 1 || taskLog.getState() == 2) {
											taskLogNode.put("taskState", "continued");
										} else if (taskLog.getState() == 3) {
											taskLogNode.put("taskState", "finished");
										}
									}

									if (activityLog != null) {
										// 任務卡ID TODO
										taskLogNode.put("taskCardId", activityLog.getTaskCardId());
									} else {
										// 任務卡ID TODO
										taskLogNode.put("taskCardId", "");
									}

									if (activityLog != null) {
										// 源數據
										taskLogNode.put("source_no", activityLog.getSourceNo());
									} else {
										// 源數據
										taskLogNode.put("source_no", taskLog.getSourceIds());
									}

									// taskId
									taskLogNode.put("taskId", taskLog.getTaskId());

									// processSerialNumber
									taskLogNode.put("processSerialNumber", errorMessage.getProcessSerialNumber());

									if (activityLog != null) {

										// 查詢該activity的atmc紀錄
										Map<String, String> tActivityAtmcCondition = new HashMap<String, String>();
										ActivityLog activityAtmcLog = null;
										tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
										tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
												activityLog.getActivityUid());
										tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(),
												activityLog.getTaskCardId());
										tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(),
												"");

										List<ActivityLog> activityAtmcLogs = logManipulateService
												.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);

										if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
											activityAtmcLog = activityAtmcLogs.get(0);
										}

										// 操作者[活動層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("performerId", activityAtmcLog.getPerformerId());
											taskLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
											taskLogNode.put("agentPerformerName",
													activityAtmcLog.getAgentPerformerName());
											taskLogNode.put("performerType", activityAtmcLog.getPerformerType());
										} else {
											taskLogNode.put("performerId", activityLog.getPerformerId());
										}

										// 操作者名稱[活動層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("performerName", activityAtmcLog.getPerformerName());
										} else {
											taskLogNode.put("performerName", activityLog.getPerformerName());
										}

										// 操作，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("operate", activityAtmcLog.getOperate());
										}
										// 操作時間，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
											taskLogNode.put("operateTime",
													formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
										}

									}

									// 設定問題描述與解決方案
									setExceptionContentAndSolution(taskLogNode, errorMessage, tLocale);

									// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平攤
									// 將節點[任務層級]放入rowData array node中
									// rowDataAryNode.add(taskLogNode);
									pSourceIdInfoArynode.add(taskLogNode);

									// 沒有找到對應任務
								} else {

									// #6251/6389【项目】栏位： 去掉展开收起 由於此異常所屬的項目底下找不到任何任務，所以此處要留projectLogNode不然沒有辦法展示異常
									pSourceIdInfoArynode.add(projectLogNode);
									// 設定問題描述與解決方案
									setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);
								}

								// 此異常沒有taskUid
							} else {
								// #6251/6389【项目】栏位： 去掉展开收起 由於此異常所屬的項目底下找不到任何任務，所以此處要留projectLogNode不然沒有辦法展示異常
								pSourceIdInfoArynode.add(projectLogNode);
								// 設定問題描述與解決方案
								setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);

							}
							// rowDataAryNode =
							// jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
							// LogAttributeEnum.CREATED_TIME.getAttribute(), true);
//							pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
//									LogAttributeEnum.CREATED_TIME.getAttribute(), true);
							// projectLogNode.put("rowData", rowDataAryNode);

						}

						// 異常有偵測、沒有對應項目
					} else {
						// 用process_serial_number做分組的異常，errorMessageMapBySerialNumber，逐該serialnumber的每筆異常errorMessage
						for (ErrorMessage errorMessage : errorMessageMapBySerialNumber.get(serialnumber)) {

							// 建立項目層級Node[projectLogNode]
							Map<String, Object> projectLogNode = new HashMap<>();
							// 建立任務層級arrayNode[rowDataAryNode]
							// ArrayNode rowDataAryNode = mapper.createArrayNode();
							// projectLogNode.put("rowData", rowDataAryNode);
							// pSourceIdInfoArynode.add(projectLogNode);

							// 建立時間[項目層級]
							projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
									formatToSecond.format(errorMessage.getCreatedTime().getTime()));
							// 健康狀態[項目層級]
							projectLogNode.put("healthState", "abnormal");
							// 應用[項目層級]
							setAppNameByLocale(projectLogNode, monitorLog, tLocale);
							// 源數據[項目層級]
							projectLogNode.put("source_no", monitorLog.getSourceId());
							// traceId[項目層級]
							projectLogNode.put("traceId", monitorLog.getTraceId());
							// appCode[項目層級]
							projectLogNode.put("appCode", monitorLog.getAppCode());
							// ruleCode
							projectLogNode.put("ruleCode", monitorLog.getRuleCode());
							// 异常时间
							projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));

							// #6251/6389【项目】栏位： 去掉展开收起 由於此異常所屬的項目底下找不到任何任務，所以此處要留projectLogNode不然沒有辦法展示異常
							pSourceIdInfoArynode.add(projectLogNode);

							// 設定問題描述與解決方案
							setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);

							// rowDataAryNode =
							// jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
							// LogAttributeEnum.CREATED_TIME.getAttribute(), true);
//							pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
//									LogAttributeEnum.CREATED_TIME.getAttribute(), true);
							// projectLogNode.put("rowData", rowDataAryNode);

						}
					}
				}
			}

			// 異常沒有對應偵測資訊 TODO
			if (!monitorLogExist) {

				// 異常有對應項目
				if (projectLogMapBySerialNumber.get(serialnumber) != null
						&& !projectLogMapBySerialNumber.get(serialnumber).isEmpty()) {

					// 項目必須是還在進行中的
					if (projectLogMapBySerialNumber.get(serialnumber).get(0).getState() == 1
							|| projectLogMapBySerialNumber.get(serialnumber).get(0).getState() == 2) {

						// 用process_serial_number做分組的異常，errorMessageMapBySerialNumber，逐該serialnumber的每筆異常errorMessage
						for (ErrorMessage errorMessage : errorMessageMapBySerialNumber.get(serialnumber)) {

							ProjectLog projectLog = projectLogMapBySerialNumber.get(serialnumber).get(0);

							// 建立項目層級Node[projectLogNode]
							Map<String, Object> projectLogNode = new HashMap<>();
							// 建立任務層級arrayNode[rowDataAryNode]
							// ArrayNode rowDataAryNode = mapper.createArrayNode();
							// projectLogNode.put("rowData", rowDataAryNode);
							// pSourceIdInfoArynode.add(projectLogNode);

							// 建立時間[項目層級]
							projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
									formatToSecond.format(projectLog.getCreatedTime().getTime()));
							// 健康狀態[項目層級]
							projectLogNode.put("healthState", "abnormal");
							// 應用[項目層級]
							setAppNameByLocale(projectLogNode, projectLog, tLocale);
							// 項目[項目層級]
							setProjectNameByLocale(projectLogNode, projectLog, tLocale);
							// 項目ID[項目層級]
							projectLogNode.put("projectId", projectLog.getProjectId());
							// 項目卡ID[項目層級]
							projectLogNode.put("projectCardId", projectLog.getProjectCardId());
							// 當前任務[項目層級] TODO

							// 任務類型[項目層級]
							projectLogNode.put("activityType", "auto");
							// 任務狀態[項目層級]
							if (projectLog.getState() == 1 || projectLog.getState() == 2) {
								projectLogNode.put("taskState", "continued");
							} else if (projectLog.getState() == 3) {
								projectLogNode.put("taskState", "finished");
							}
							// 源數據[項目層級]
							// projectLogNode.put("source_no", monitorLog.getSourceId());
							projectLogNode.put("source_no", projectLog.getSourceIds());
							// traceId[項目層級]
							projectLogNode.put("traceId", projectLog.getTraceId());
							// appCode[項目層級]
							projectLogNode.put("appCode", projectLog.getAppCode());
							// 异常时间
							projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));

							// 此異常有taskUid
							if (!StringUtil.isEmptyOrSpace(errorMessage.getTaskUid())) {

								// 找出異常對應的任務，taskengine、ptm的紀錄都找
								Map<String, String> tTaskCondition = new HashMap<String, String>();
								// tTaskCondition.put(TaskLogConditionEnum.TENANT_ID.toString(),
								// errorMessage.getTenantId());
								// tTaskCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
								// errorMessage.getProcessSerialNumber());
								tTaskCondition.put(TaskLogConditionEnum.TASK_UID.toString(), errorMessage.getTaskUid());

								// List<TaskLog> taskLogs = taskLogDao.fetch(tTaskCondition);

								List<TaskLog> taskLogs = logManipulateService.getTargetTaskLogs(tAllTaskLogs,
										tTaskCondition);

								TaskLog taskLog = null;

								if (taskLogs != null && !taskLogs.isEmpty()) {
									taskLog = logManipulateService.getLatestTaskLog(taskLogs);
								}

								// 有找到對應任務
								if (taskLog != null) {

									// 找出任務對應活動，一個任務有多個活動，要找到對應報錯的活動(用process_activity_oid)，只找ptm紀錄
									Map<String, String> tActivityCondition = new HashMap<String, String>();

									tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
									// tActivityCondition.put(ActivityLogConditionEnum.TENANT_ID.toString(),
									// projectLog.getTenantId());
									// tActivityCondition.put(ActivityLogConditionEnum.TASK_UID.toString(),
									// taskLog.getTaskUid());
									tActivityCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
											errorMessage.getProcessActivityOid());
									// 取最新的紀錄
									tActivityCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");

									// List<ActivityLog> activitiLogs = activityLogDao.fetch(tActivityCondition);

									List<ActivityLog> activitiLogs = logManipulateService
											.getTargetActivityLogs(tAllActivityLogs, tActivityCondition);

									ActivityLog activityLog = null;

									// 有找到該任務對應的多個活動
									if (activitiLogs != null && !activitiLogs.isEmpty()) {
										activityLog = activitiLogs.get(0);
									}

									// 建立任務層級Node[taskNode]
									Map<String, Object> taskLogNode = new HashMap<>();
									// 异常时间
									taskLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));
									if (activityLog != null) {
										// 建立時間[任務層級]
										taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
												formatToSecond.format(activityLog.getCreatedTime().getTime()));
									} else {
										// 建立時間[任務層級]
										taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
												formatToSecond.format(taskLog.getCreatedTime().getTime()));
									}

									// 健康狀態[任務層級]
									taskLogNode.put("healthState", "abnormal");
									// 應用[任務層級]
									setAppNameByLocale(taskLogNode, projectLog, tLocale);
									// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
									taskLogNode.put("projectCardId", projectLog.getProjectCardId());
									// appCode
									taskLogNode.put("appCode", projectLog.getAppCode());
									// 項目[任務層級]
									setProjectNameByLocale(taskLogNode, projectLog, tLocale);
									// 當前任務[任務層級]
									setTaskNameByLocale(taskLogNode, taskLog, tLocale);
									// 當前任務[項目層級]
									if (taskLog.getState() == 1 || taskLog.getState() == 2) {
										setTaskNameByLocale(projectLogNode, taskLog, tLocale);
									}

									if (activityLog != null) {
										// 任務類型[任務層級]
										taskLogNode.put("activityType", activityLog.getActivityType());
									} else {
										// 任務類型[任務層級]
										taskLogNode.put("activityType", "");
									}

									if (activityLog != null) {
										// 任務狀態[任務層級]
										if (activityLog.getState() == 1 || activityLog.getState() == 2) {
											taskLogNode.put("taskState", "continued");
										} else if (activityLog.getState() == 3) {
											taskLogNode.put("taskState", "finished");
										}
									} else {
										// 任務狀態[任務層級]
										if (taskLog.getState() == 1 || taskLog.getState() == 2) {
											taskLogNode.put("taskState", "continued");
										} else if (taskLog.getState() == 3) {
											taskLogNode.put("taskState", "finished");
										}
									}

									if (activityLog != null) {
										// 任務卡ID TODO
										taskLogNode.put("taskCardId", activityLog.getTaskCardId());
									} else {
										// 任務卡ID TODO
										taskLogNode.put("taskCardId", "");
									}

									if (activityLog != null) {
										// 源數據
										taskLogNode.put("source_no", activityLog.getSourceNo());
									} else {
										// 源數據
										taskLogNode.put("source_no", taskLog.getSourceIds());
									}

									// taskId
									taskLogNode.put("taskId", taskLog.getTaskId());

									// processSerialNumber
									taskLogNode.put("processSerialNumber", errorMessage.getProcessSerialNumber());

									if (activityLog != null) {

										// 查詢該activity的atmc紀錄
										Map<String, String> tActivityAtmcCondition = new HashMap<String, String>();
										ActivityLog activityAtmcLog = null;
										tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
										// tActivityAtmcCondition.put(ActivityLogConditionEnum.TENANT_ID.toString(),
										// projectLog.getTenantId());
										// tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_UID.toString(),
										// activityLog.getTaskUid());
										tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
												activityLog.getActivityUid());
										tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(),
												activityLog.getTaskCardId());
										tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(),
												"");

										// List<ActivityLog> activityAtmcLogs =
										// activityLogDao.fetch(tActivityAtmcCondition);

										List<ActivityLog> activityAtmcLogs = logManipulateService
												.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);

										if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
											activityAtmcLog = activityAtmcLogs.get(0);
										}

										// 操作者[活動層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("performerId", activityAtmcLog.getPerformerId());
											taskLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
											taskLogNode.put("agentPerformerName",
													activityAtmcLog.getAgentPerformerName());
											taskLogNode.put("performerType", activityAtmcLog.getPerformerType());
										} else {
											taskLogNode.put("performerId", activityLog.getPerformerId());
										}

										// 操作者名稱[活動層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("performerName", activityAtmcLog.getPerformerName());
										} else {
											taskLogNode.put("performerName", activityLog.getPerformerName());
										}

										// 操作，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											taskLogNode.put("operate", activityAtmcLog.getOperate());
										}
										// 操作時間，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
											taskLogNode.put("operateTime",
													formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
										}

									}

									// 設定問題描述與解決方案
									setExceptionContentAndSolution(taskLogNode, errorMessage, tLocale);

									// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平攤
									// 將節點[任務層級]放入rowData array node中
									// rowDataAryNode.add(taskLogNode);
									pSourceIdInfoArynode.add(taskLogNode);

									// 沒有找到對應任務
								} else {

									// #6251/6389【项目】栏位： 去掉展开收起 由於此異常所屬的項目底下找不到任何任務，所以此處要留projectLogNode不然沒有辦法展示異常
									pSourceIdInfoArynode.add(projectLogNode);
									// 設定問題描述與解決方案
									setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);
								}

								// 此異常沒有taskUid
							} else {
								// #6251/6389【项目】栏位： 去掉展开收起 由於此異常所屬的項目底下找不到任何任務，所以此處要留projectLogNode不然沒有辦法展示異常
								pSourceIdInfoArynode.add(projectLogNode);
								// 設定問題描述與解決方案
								setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);
							}
							// rowDataAryNode =
							// jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
							// LogAttributeEnum.CREATED_TIME.getAttribute(), true);
//							pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
//									LogAttributeEnum.CREATED_TIME.getAttribute(), true);
							// projectLogNode.put("rowData", rowDataAryNode);
						}
					}
					// 異常沒有對應偵測、沒有項目
				} else {
					// 用process_serial_number做分組的異常，errorMessageMapBySerialNumber，逐該serialnumber的每筆異常errorMessage
					for (ErrorMessage errorMessage : errorMessageMapBySerialNumber.get(serialnumber)) {

						// 建立項目層級Node[projectLogNode]
						Map<String, Object> projectLogNode = new HashMap<>();
						// 建立任務層級arrayNode[rowDataAryNode]
						// ArrayNode rowDataAryNode = mapper.createArrayNode();
						// projectLogNode.put("rowData", rowDataAryNode);
						pSourceIdInfoArynode.add(projectLogNode);

						// 建立時間[項目層級]
						projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
								formatToSecond.format(errorMessage.getCreatedTime().getTime()));
						// 健康狀態[項目層級]
						projectLogNode.put("healthState", "abnormal");
						// 异常时间
						projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(errorMessage.getCreatedTime().getTime()));

						// 設定問題描述與解決方案
						setExceptionContentAndSolution(projectLogNode, errorMessage, tLocale);

						// rowDataAryNode =
						// jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
						// LogAttributeEnum.CREATED_TIME.getAttribute(), true);
//						pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
//								LogAttributeEnum.CREATED_TIME.getAttribute(), true);
						// projectLogNode.put("rowData", rowDataAryNode);

					}
				}

			}

		}

		return pSourceIdInfoArynode;
	}

	private List<Map<String, Object>> generateSuccessResult(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate,
			String pQueryEndDate, String pCondition) throws ParseException {
		// 取得前端語系
		String tLocale;
		tLocale = (String) DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
		if (StringUtil.isEmptyOrSpace(tLocale)) {
			tLocale = "";
		}

		log.info("執行視角前端查詢語系：" + tLocale);

		List<ErrorMessage> errorMessages;
		List<ProcessLog> processLogs;
		List<ProjectLog> projectLogs;
		List<MonitorLog> monitorLogs;

		List<String> serialNumbers = new ArrayList<String>();
		List<String> serialNumbersWithError = new ArrayList<String>();
		List<String> traceIds = new ArrayList<String>();

		Map<String, List<ErrorMessage>> errorMessageMapByTraceId = new HashMap<String, List<ErrorMessage>>();
		Map<String, List<ErrorMessage>> errorMessageMapBySerialNumber = new HashMap<String, List<ErrorMessage>>();
		Map<String, List<ProcessLog>> processLogMapByTraceId = new HashMap<String, List<ProcessLog>>();
		Map<String, List<ProcessLog>> processLogMapBySerialNumber = new HashMap<String, List<ProcessLog>>();

		Map<String, List<ProjectLog>> projectLogMapBySerialNumber = new HashMap<String, List<ProjectLog>>();
		Map<String, List<ProjectLog>> projectLogMapByTraceId = new HashMap<String, List<ProjectLog>>();
		Map<String, List<TaskLog>> taskLogMapByTaskUid = new HashMap<String, List<TaskLog>>();
		Map<String, List<MonitorLog>> monitorLogMapByTraceId = new HashMap<String, List<MonitorLog>>();

		Map<String, String> conditionMap = new HashMap<String, String>();

		// 租戶ID
		if (!StringUtil.isEmptyOrSpace(pTenantId)) {
			conditionMap.put("tenant_id", pTenantId);
			conditionMap.put(ProjectLogConditionEnum.TENANT_ID.toString(), pTenantId);
		}

		// 日期區間
		if (!StringUtil.isEmptyOrSpace(pQueryStartDate) && !StringUtil.isEmptyOrSpace(pQueryEndDate)) {
			conditionMap.put("query_start_date", pQueryStartDate);
			conditionMap.put("query_end_date", pQueryEndDate);
		}

		conditionMap.put("condition", pCondition);
		conditionMap.put("is_error", String.valueOf(Boolean.TRUE));

		// (old)取得運行中的流程
		// processLogs = processLogDao.fetch(conditionMap);

		// (new)取得所有的項目[projectLogs]
		conditionMap.put(ProjectLogConditionEnum.STATE.toString(), "1");
		projectLogs = projectLogDao.fetch(conditionMap);

		// (old)用process_serial_number將流程分組[processLogMapBySerialNumber]
		// processLogMapBySerialNumber =
		// logManipulateService.mapProcessLogByType(processLogs,
		// MappingTypeEnum.SERIAL_NUMBER.getType());

		// (new)用process_serial_number將項目分組[projectLogMapBySerialNumber]
		projectLogMapBySerialNumber = logManipulateService.mapProjectLogByType(projectLogs,
				MappingTypeEnum.SERIAL_NUMBER.getType());

		logManipulateService.sortLatestProjectLog(projectLogMapBySerialNumber);

		// 取得項目的所有process_serial_number[serialNumbers]
		for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
			serialNumbers.add(serialNumber);
		}

		// (old)用所有process_serial_number取得對應的異常[errorMessages]
		// errorMessages = errorMessageDao.getErrorsBySerialNumbers(serialNumbers);

		// (new)用所有process_serial_number取得對應的異常[errorMessages]
		errorMessages = errorMessageDao.getErrorsBySerialNumbers(serialNumbers, pTenantId);

		// (old)取得有異常的process_serial_number[serialNumbersWithError]
		// for (String serialNumber : processLogMapBySerialNumber.keySet()) {
		// for (ErrorMessage errorMessage : errorMessages) {
		// if (errorMessage.getProcessSerialNumber().equals(serialNumber)) {
		// serialNumbersWithError.add(serialNumber);
		// break;
		// }
		// }
		// }

		// (new)取得有異常的process_serial_number[serialNumbersWithError]
		for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
			for (ErrorMessage errorMessage : errorMessages) {
				if (errorMessage.getProcessSerialNumber().equals(serialNumber)) {
					serialNumbersWithError.add(serialNumber);
					break;
				}
			}
		}

		// (old)將有異常的process_serial_number移除的結果[processLogMapBySerialNumber]
		// for (String number : serialNumbersWithError) {
		// processLogMapBySerialNumber.remove(number);
		// }

		// (new)將有異常的process_serial_number移除的結果[projectLogMapBySerialNumber]
		for (String number : serialNumbersWithError) {
			projectLogMapBySerialNumber.remove(number);
		}

		// (new)用trace_id將項目分組[projectLogMapByTraceId]
		for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
			for (ProjectLog projectLog : projectLogMapBySerialNumber.get(serialNumber)) {
				if (projectLogMapByTraceId.get(projectLog.getTraceId()) != null) {
					projectLogMapByTraceId.get(projectLog.getTraceId()).add(projectLog);
				} else {
					List<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
					projectLogList.add(projectLog);
					projectLogMapByTraceId.put(projectLog.getTraceId(), projectLogList);
				}
			}
		}

		// 用偵測ID將項目分組，projectLogMapByTraceId
		// projectLogMapByTraceId =
		// logManipulateService.mapProjectLogByType(projectLogs,
		// MappingTypeEnum.TRACE_ID.getType());

		// 將projectLogMapByTraceId中重複的projectLog剃除，優先取app_id
		// = ptm的最新紀錄，沒有的話則取app_id = taskengine的最新紀錄
		// for (String tTraceId : projectLogMapByTraceId.keySet()) {
		// // (new)用app_id將項目分組[tProjectLogMapByAppId]
		// Map<String, List<ProjectLog>> tProjectLogMapByAppId = logManipulateService
		// .mapProjectLogByType(projectLogMapByTraceId.get(tTraceId),
		// MappingTypeEnum.APP_ID.getType());
		//
		// if (tProjectLogMapByAppId.get("ptm") != null) {
		// Collections.sort(tProjectLogMapByAppId.get("ptm"), new Comparator() {
		// @Override
		// public int compare(Object o1, Object o2) {
		// return ((ProjectLog) o1).getBuildTime().getTime()
		// .compareTo(((ProjectLog) o2).getBuildTime().getTime());
		// }
		// });
		//
		// List<ProjectLog> latestLog = new ArrayList<ProjectLog>();
		//
		// latestLog.add(tProjectLogMapByAppId.get("ptm").get(tProjectLogMapByAppId.get("ptm").size()
		// - 1));
		//
		// projectLogMapByTraceId.put(tTraceId, latestLog);
		// } else if (tProjectLogMapByAppId.get("taskengine") != null) {
		// Collections.sort(tProjectLogMapByAppId.get("taskengine"), new Comparator() {
		// @Override
		// public int compare(Object o1, Object o2) {
		// return ((ProjectLog) o1).getBuildTime().getTime()
		// .compareTo(((ProjectLog) o2).getBuildTime().getTime());
		// }
		// });
		//
		// List<ProjectLog> latestLog = new ArrayList<ProjectLog>();
		//
		// latestLog.add(tProjectLogMapByAppId.get("taskengine")
		// .get(tProjectLogMapByAppId.get("taskengine").size() - 1));
		//
		// projectLogMapByTraceId.put(tTraceId, latestLog);
		// }
		//
		// }

		// 取得所有的trace_id[traceIds]
		for (String traceId : projectLogMapByTraceId.keySet()) {
			traceIds.add(traceId);
		}

		// 用所有的trace_id取得對應的偵測資訊[monitorLogs]
		monitorLogs = monitorLogDao.getMonitorLogsByTraceIds(traceIds, pTenantId);

		monitorLogMapByTraceId = logManipulateService.mapMonitorLogByType(monitorLogs,
				MappingTypeEnum.TRACE_ID.getType());

		logManipulateService.sortLatestMonitorLog(monitorLogMapByTraceId);

		serialNumbers.removeAll(serialNumbersWithError);

		List<TaskLog> tAllTaskLogs = taskLogDao.getTaskLogsBySerialNumbers(serialNumbers);

		List<ActivityLog> tAllActivityLogs = activityLogDao.getActivityLogsBySerialNumbers(serialNumbers);

		// 逐[projectLogMapByTraceId]的trace_id
		for (String traceId : projectLogMapByTraceId.keySet()) {

			// 項目是否有對應偵測log[monitorLogExist]
			boolean monitorLogExist = false;

			// 項目有對應偵測log
			if (monitorLogMapByTraceId.containsKey(traceId)) {

				monitorLogExist = true;

				MonitorLog monitorLog = monitorLogMapByTraceId.get(traceId).get(0);
				ArrayNode monitorLogEmptyRowDataAryNode = mapper.createArrayNode();

				// 建立偵測條目
				Map<String, Object> monitorLogNode = new HashMap<>();

				monitorLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
						formatToSecond.format(monitorLog.getCreatedTime().getTime()));
				monitorLogNode.put("healthState", "normal");
				setAppNameByLocale(monitorLogNode, monitorLog, tLocale);
				switch (tLocale) {
				case "zh_TW":
					monitorLogNode.put("projectName", "發起偵測");
					break;
				case "zh_CN":
					monitorLogNode.put("projectName", "发起侦测");
					break;
				case "en_US":
					monitorLogNode.put("projectName", "Initiate detection");
					break;
				default:
					monitorLogNode.put("projectName", "发起侦测");
					break;
				}
				monitorLogNode.put("activityType", "auto");
				monitorLogNode.put("taskState", "finished");
				monitorLogNode.put("source_no", monitorLog.getSourceId());
				monitorLogNode.put("traceId", monitorLog.getTraceId());
				monitorLogNode.put("appCode", monitorLog.getAppCode());
				monitorLogNode.put("ruleCode", monitorLog.getRuleCode());
				monitorLogNode.put("rowData", monitorLogEmptyRowDataAryNode);
				// 异常时间
				monitorLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(monitorLog.getCreatedTime()));
				pSourceIdInfoArynode.add(monitorLogNode);

				// 逐[projectLogMapByTraceId]的projectLog
				for (ProjectLog projectLog : projectLogMapByTraceId.get(traceId)) {

					// 項目的JsonNode[projectLogNode]
					Map<String, Object> projectLogNode = new HashMap<>();

					// 任務/活動的ArrayNode[rowDataAryNode]
					// ArrayNode rowDataAryNode = mapper.createArrayNode();

					// pSourceIdInfoArynode.add(projectLogNode);
					// projectLogNode.put("rowData", rowDataAryNode);
					// 項目建立時間
					projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
							formatToSecond.format(projectLog.getCreatedTime().getTime()));
					// 項目健康狀態
					projectLogNode.put("healthState", "normal");
					// 項目所屬應用
					setAppNameByLocale(projectLogNode, monitorLog, tLocale);
					// 項目名稱
					setProjectNameByLocale(projectLogNode, projectLog, tLocale);
					// 項目類型(預設寫自動)
					projectLogNode.put("activityType", "auto");
					// 項目狀態
					if (projectLog.getState() == 1 || projectLog.getState() == 2) {
						projectLogNode.put("taskState", "continued");
					} else if (projectLog.getState() == 3) {
						projectLogNode.put("taskState", "finished");
					}
					// 項目源數據
					// projectLogNode.put("source_no", "");
					projectLogNode.put("source_no", projectLog.getSourceIds());
					// 項目對應偵測ID
					projectLogNode.put("traceId", monitorLog.getTraceId());
					// 項目對應應用appCode
					projectLogNode.put("appCode", monitorLog.getAppCode());
					// ruleCode
					projectLogNode.put("ruleCode", monitorLog.getRuleCode());
					// 項目ID
					projectLogNode.put("projectId", projectLog.getProjectId());
					// 項目卡ID(前端跳轉所用)
					projectLogNode.put("projectCardId", projectLog.getProjectCardId());
					// 項目序號
					projectLogNode.put("processSerialNumber", projectLog.getProcessSerialNumber());
					// 异常时间
					projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(projectLog.getCreatedTime()));

					// 找出項目底下的任務，一個項目可以有多個任務，taskengine、ptm的紀錄都找
					Map<String, String> tTaskCondition = new HashMap<String, String>();

					tTaskCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
							projectLog.getProcessSerialNumber());

					List<TaskLog> taskLogs = logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);

					// 有找到任務紀錄
					if (taskLogs != null && !taskLogs.isEmpty()) {
						// 將任務紀錄依照task_uid分組[taskLogMapByTaskUid]
						taskLogMapByTaskUid = logManipulateService.mapTaskLogByType(taskLogs,
								MappingTypeEnum.TASK_UID.getType());
					}

					// 逐taskUid
					for (String taskUid : taskLogMapByTaskUid.keySet()) {

						// 找出任務對應活動，一個任務有多個活動，只找ptm紀錄
						Map<String, String> tActivityCondition = new HashMap<String, String>();

						tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
						tActivityCondition.put(ActivityLogConditionEnum.TASK_UID.toString(), taskUid);

						List<ActivityLog> activitiLogs = logManipulateService.getTargetActivityLogs(tAllActivityLogs,
								tActivityCondition);

						// 有找到該任務對應的多個活動
						if (activitiLogs != null && !activitiLogs.isEmpty()) {

							// 逐活動
							for (ActivityLog activityLog : activitiLogs) {

								// 任務/活動JsonNode[taskOrActivityLogNode]
								Map<String, Object> taskOrActivityLogNode = new HashMap<>();

//								rowDataAryNode.add(taskOrActivityLogNode);
								pSourceIdInfoArynode.add(taskOrActivityLogNode);

								// 活動建立時間
								taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
										formatToSecond.format(activityLog.getCreatedTime().getTime()));

								// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
								taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
								// 任務健康狀態
								taskOrActivityLogNode.put("healthState", "normal");
								// 异常时间
								taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(activityLog.getCreatedTime().getTime()));

								// 當前任務所屬應用
								setAppNameByLocale(taskOrActivityLogNode, monitorLog, tLocale);

								// 任務名稱
								setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);

								List<TaskLog> tTaskLogs = taskLogMapByTaskUid.get(taskUid);

								TaskLog tTaskLog = null;

								tTaskLog = logManipulateService.getLatestTaskLog(tTaskLogs);

								// 查詢該activity的atmc紀錄
								Map<String, String> tActivityAtmcCondition = new HashMap<String, String>();
								ActivityLog activityAtmcLog = null;
								tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
								tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
										activityLog.getActivityUid());
								tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(),
										activityLog.getTaskCardId());
								tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");

								List<ActivityLog> activityAtmcLogs = logManipulateService
										.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);

								if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
									activityAtmcLog = activityAtmcLogs.get(0);
								}

								// 活動類型
								taskOrActivityLogNode.put("activityType", activityLog.getActivityType());
								// 活動狀態
								if (activityLog != null) {
									if (activityLog.getState() == 1 || activityLog.getState() == 2) {
										taskOrActivityLogNode.put("taskState", "continued");
									} else if (activityLog.getState() == 3) {
										taskOrActivityLogNode.put("taskState", "finished");
									}
								}
								// 活動源數據，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("source_no", activityAtmcLog.getSourceNo());
								} else {
									taskOrActivityLogNode.put("source_no", activityLog.getSourceNo());
								}
								// 活動操作者，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("performerId", activityAtmcLog.getPerformerId());
									taskOrActivityLogNode.put("agentPerformerId",
											activityAtmcLog.getAgentPerformerId());
									taskOrActivityLogNode.put("agentPerformerName",
											activityAtmcLog.getAgentPerformerName());
									taskOrActivityLogNode.put("performerType", activityAtmcLog.getPerformerType());
								} else {
									taskOrActivityLogNode.put("performerId", activityLog.getPerformerId());
								}
								// 活動操作者名稱，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("performerName", activityAtmcLog.getPerformerName());
								} else {
									taskOrActivityLogNode.put("performerName", activityLog.getPerformerName());
								}

								// 活動操作，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("operate", activityAtmcLog.getOperate());
								}
								// 活動操作時間，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
									taskOrActivityLogNode.put("operateTime",
											formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
								}
								// 活動任務卡ID，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
								} else {
									taskOrActivityLogNode.put("taskCardId", activityLog.getTaskCardId());
								}
								// 活動所屬任務的uid，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("taskUid", activityAtmcLog.getTaskUid());
								} else {
									taskOrActivityLogNode.put("taskUid", activityLog.getTaskUid());
								}
								// 活動所屬的項目序號
								taskOrActivityLogNode.put("processSerialNumber", activityLog.getProcessSerialNumber());
								// 活動所屬的應用appCode
								taskOrActivityLogNode.put("appCode", monitorLog.getAppCode());
								// ruleCode
								taskOrActivityLogNode.put("ruleCode", monitorLog.getRuleCode());

								if (tTaskLog != null) {

									// 任務名稱
									setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);

									// 任務ID
									taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());

									if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {

										// 補上項目的當前任務
										setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);

										// 補上項目的當前任務的類型
										projectLogNode.put("activityType", activityLog.getActivityType());

										// 補上項目的當前任務ID
										projectLogNode.put("taskId", tTaskLog.getTaskId());

										// 補上項目的當前任務卡ID，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											projectLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
										} else {
											projectLogNode.put("taskCardId", activityLog.getTaskCardId());
										}
										// 補上項目的當前任務uid，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											projectLogNode.put("taskUid", activityAtmcLog.getTaskUid());
										} else {
											projectLogNode.put("taskUid", activityLog.getTaskUid());
										}

									}

								}

							}
							// 沒有找到該任務對應的任何活動
						} else {

							Map<String, Object> taskOrActivityLogNode = new HashMap<>();

//							rowDataAryNode.add(taskOrActivityLogNode);
							pSourceIdInfoArynode.add(taskOrActivityLogNode);

							List<TaskLog> tTaskLogs = taskLogMapByTaskUid.get(taskUid);

							TaskLog tTaskLog = null;

							tTaskLog = logManipulateService.getLatestTaskLog(tTaskLogs);

							if (tTaskLog != null) {

								// 任務建立時間
								taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
										formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
								// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
								taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
								// 任務健康狀態
								taskOrActivityLogNode.put("healthState", "normal");
								// 异常时间
								taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(tTaskLog.getCreatedTime().getTime()));

								// 任務所屬應用名稱
								setAppNameByLocale(taskOrActivityLogNode, monitorLog, tLocale);

								// 任務所屬項目名稱
								setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);

								// 任務類型
								taskOrActivityLogNode.put("activityType", "");

								// 任務狀態
								if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {
									taskOrActivityLogNode.put("taskState", "continued");
								} else if (tTaskLog.getState() == 3) {
									taskOrActivityLogNode.put("taskState", "finished");
								}

								// 任務源數據
								taskOrActivityLogNode.put("source_no", tTaskLog.getSourceIds());

								// 任務所屬項目序號
								taskOrActivityLogNode.put("processSerialNumber", tTaskLog.getProcessSerialNumber());

								// 任務所屬應用appCode
								taskOrActivityLogNode.put("appCode", monitorLog.getAppCode());

								// ruleCode
								taskOrActivityLogNode.put("ruleCode", monitorLog.getRuleCode());

								// 任務名稱
								setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);

								// 任務ID
								taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());

								if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {

									// 補上項目的當前任務
									setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);

									// 補上項目的當前任務類型
									projectLogNode.put("activityType", "");

									// 補上項目的當前任務ID
									projectLogNode.put("taskId", tTaskLog.getTaskId());

									// 補上項目的當前任務uid
									projectLogNode.put("taskUid", tTaskLog.getTaskUid());

								}

							}
						}

					}
//					rowDataAryNode = jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
//							LogAttributeEnum.CREATED_TIME.getAttribute(), true);

					pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
							LogAttributeEnum.CREATED_TIME.getAttribute(), true);
					// projectLogNode.put("rowData", rowDataAryNode);
				}
			}

			if (!monitorLogExist) {

				// 逐[projectLogMapByTraceId]的projectLog
				for (ProjectLog projectLog : projectLogMapByTraceId.get(traceId)) {

					// 項目的JsonNode[projectLogNode]
					Map<String, Object> projectLogNode = new HashMap<>();

					// 任務/活動的ArrayNode[rowDataAryNode]
//					ArrayNode rowDataAryNode = mapper.createArrayNode();

//					pSourceIdInfoArynode.add(projectLogNode);
//					projectLogNode.put("rowData", rowDataAryNode);
					// 建立時間[項目層級]
					projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
							formatToSecond.format(projectLog.getCreatedTime().getTime()));
					// 健康狀態[項目層級]
					projectLogNode.put("healthState", "normal");
					// 當前項目所屬應用[項目層級]
					setAppNameByLocale(projectLogNode, projectLog, tLocale);
					// 項目名稱[項目層級]
					setProjectNameByLocale(projectLogNode, projectLog, tLocale);
					// 項目類型(預設是自動)
					projectLogNode.put("activityType", "auto");
					// 項目狀態
					if (projectLog.getState() == 1 || projectLog.getState() == 2) {
						projectLogNode.put("taskState", "continued");
					} else if (projectLog.getState() == 3) {
						projectLogNode.put("taskState", "finished");
					}
					// 源數據
					// projectLogNode.put("source_no", "");
					projectLogNode.put("source_no", projectLog.getSourceIds());
					// 偵測ID
					projectLogNode.put("traceId", projectLog.getTraceId());
					// appCode
					projectLogNode.put("appCode", projectLog.getAppCode());
					// 項目ID
					projectLogNode.put("projectId", projectLog.getProjectId());
					// 項目卡ID(前端跳轉所用)
					projectLogNode.put("projectCardId", projectLog.getProjectCardId());
					// 項目序號
					projectLogNode.put("processSerialNumber", projectLog.getProcessSerialNumber());
					// 异常时间
					projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(projectLog.getCreatedTime()));

					// 找出項目底下的任務，一個項目可以有多個任務，taskengine、ptm的紀錄都找
					Map<String, String> tTaskCondition = new HashMap<String, String>();

//					tTaskCondition.put(TaskLogConditionEnum.TENANT_ID.toString(), projectLog.getTenantId());
					tTaskCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
							projectLog.getProcessSerialNumber());

//					List<TaskLog> taskLogs = taskLogDao.fetch(tTaskCondition);
					List<TaskLog> taskLogs = logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);

					// 有找到任務紀錄
					if (taskLogs != null && !taskLogs.isEmpty()) {
						// 將任務紀錄依照task_uid分組[taskLogMapByTaskUid]
						taskLogMapByTaskUid = logManipulateService.mapTaskLogByType(taskLogs,
								MappingTypeEnum.TASK_UID.getType());
					}

					// 逐taskUid
					for (String taskUid : taskLogMapByTaskUid.keySet()) {

						// 找出任務對應活動，一個任務有多個活動，只找ptm紀錄
						Map<String, String> tActivityCondition = new HashMap<String, String>();

						tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
						tActivityCondition.put(ActivityLogConditionEnum.TASK_UID.toString(), taskUid);

						List<ActivityLog> activitiLogs = logManipulateService.getTargetActivityLogs(tAllActivityLogs,
								tActivityCondition);

						// 有找到該任務對應的多個活動
						if (activitiLogs != null && !activitiLogs.isEmpty()) {

							// 逐活動
							for (ActivityLog activityLog : activitiLogs) {

								// 任務/活動JsonNode[taskOrActivityLogNode]
								Map<String, Object> taskOrActivityLogNode = new HashMap<>();

//								rowDataAryNode.add(taskOrActivityLogNode);
								pSourceIdInfoArynode.add(taskOrActivityLogNode);

								// 建立時間[活動層級]
								taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
										formatToSecond.format(activityLog.getCreatedTime().getTime()));
								// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
								taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
								// 健康狀態[活動層級]
								taskOrActivityLogNode.put("healthState", "normal");
								// 异常时间
								taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(activityLog.getCreatedTime().getTime()));
								// 當前任務所屬應用[活動層級]
								setAppNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
								// 項目名稱[活動層級]
								setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);

								List<TaskLog> tTaskLogs = taskLogMapByTaskUid.get(taskUid);

								TaskLog tTaskLog = null;

								tTaskLog = logManipulateService.getLatestTaskLog(tTaskLogs);

								// 查詢該activity的atmc紀錄
								Map<String, String> tActivityAtmcCondition = new HashMap<String, String>();
								ActivityLog activityAtmcLog = null;
								tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
								tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(),
										activityLog.getActivityUid());
								tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(),
										activityLog.getTaskCardId());
								tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");

								List<ActivityLog> activityAtmcLogs = logManipulateService
										.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);

								if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
									activityAtmcLog = activityAtmcLogs.get(0);
								}

								// 活動類型[活動層級]
								taskOrActivityLogNode.put("activityType", activityLog.getActivityType());
								// 活動狀態[活動層級]
								if (activityLog != null) {
									if (activityLog.getState() == 1 || activityLog.getState() == 2) {
										taskOrActivityLogNode.put("taskState", "continued");
									} else if (activityLog.getState() == 3) {
										taskOrActivityLogNode.put("taskState", "finished");
									}
								}
								// 源數據[活動層級]，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("source_no", activityAtmcLog.getSourceNo());
								} else {
									taskOrActivityLogNode.put("source_no", activityLog.getSourceNo());
								}
								// 操作者[活動層級]，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("performerId", activityAtmcLog.getPerformerId());
									taskOrActivityLogNode.put("agentPerformerId",
											activityAtmcLog.getAgentPerformerId());
									taskOrActivityLogNode.put("agentPerformerName",
											activityAtmcLog.getAgentPerformerName());
									taskOrActivityLogNode.put("performerType", activityAtmcLog.getPerformerType());
								} else {
									taskOrActivityLogNode.put("performerId", activityLog.getPerformerId());
								}
								// 操作者名稱[活動層級]，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("performerName", activityAtmcLog.getPerformerName());
								} else {
									taskOrActivityLogNode.put("performerName", activityLog.getPerformerName());
								}

								// 操作，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("operate", activityAtmcLog.getOperate());
								}
								// 操作時間，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
									taskOrActivityLogNode.put("operateTime",
											formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
								}
								// 任務卡ID，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
								} else {
									taskOrActivityLogNode.put("taskCardId", activityLog.getTaskCardId());
								}
								// taskUid，如果atmc有操作紀錄就用atmc的
								if (activityAtmcLog != null) {
									taskOrActivityLogNode.put("taskUid", activityAtmcLog.getTaskUid());
								} else {
									taskOrActivityLogNode.put("taskUid", activityLog.getTaskUid());
								}
								// processSerialNumber
								taskOrActivityLogNode.put("processSerialNumber", activityLog.getProcessSerialNumber());
								// appCode
								taskOrActivityLogNode.put("appCode", projectLog.getAppCode());

								if (tTaskLog != null) {
									// 任務名稱[活動層級]
									setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);

									// 任務ID[活動層級]
									taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());

									if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {

										// 補上項目層級的當前任務[項目層級]
										setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
										// 補上項目層級的當前任務ID[項目層級]
										projectLogNode.put("taskId", tTaskLog.getTaskId());

										// 補上項目層級的當前任務ID[項目層級]
										projectLogNode.put("activityType", activityLog.getActivityType());

										// 補上項目層級的當前任務卡ID[項目層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											projectLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
										} else {
											projectLogNode.put("taskCardId", activityLog.getTaskCardId());
										}
										// 補上項目層級的當前任務taskUid[項目層級]，如果atmc有操作紀錄就用atmc的
										if (activityAtmcLog != null) {
											projectLogNode.put("taskUid", activityAtmcLog.getTaskUid());
										} else {
											projectLogNode.put("taskUid", activityLog.getTaskUid());
										}

									}

								}

							}
							// 沒有找到該任務對應的任何活動
						} else {

							Map<String, Object> taskOrActivityLogNode = new HashMap<>();

//							rowDataAryNode.add(taskOrActivityLogNode);
							pSourceIdInfoArynode.add(taskOrActivityLogNode);

							List<TaskLog> tTaskLogs = taskLogMapByTaskUid.get(taskUid);

							TaskLog tTaskLog = null;
							tTaskLog = logManipulateService.getLatestTaskLog(tTaskLogs);

							if (tTaskLog != null) {

								// 建立時間[任務層級]
								taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(),
										formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
								// #6251/6389【项目】栏位： 去掉展开收起 任務不用再放入rowData Ary Node，改為直接平
								taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
								// 健康狀態[任務層級]
								taskOrActivityLogNode.put("healthState", "normal");
								// 异常时间
								taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), formatToSecond.format(tTaskLog.getCreatedTime().getTime()));

								// 當前任務所屬應用[任務層級]
								setAppNameByLocale(taskOrActivityLogNode, projectLog, tLocale);

								// 項目名稱[任務層級]
								setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);

								// 任務類型[任務層級]
								taskOrActivityLogNode.put("activityType", "");

								// 任務狀態[任務層級]
								if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {
									taskOrActivityLogNode.put("taskState", "continued");
								} else if (tTaskLog.getState() == 3) {
									taskOrActivityLogNode.put("taskState", "finished");
								}

								// 源數據[任務層級]
								taskOrActivityLogNode.put("source_no", tTaskLog.getSourceIds());

								// processSerialNumber[任務層級]
								taskOrActivityLogNode.put("processSerialNumber", tTaskLog.getProcessSerialNumber());

								// appCode[任務層級]
								taskOrActivityLogNode.put("appCode", projectLog.getAppCode());

								// 任務名稱[任務層級]
								setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);

								// 任務ID[任務層級]
								taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());

								if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {

									// 補上項目層級的當前任務[項目層級]
									setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
									// 補上項目層級的當前任務ID[項目層級]
									projectLogNode.put("taskId", tTaskLog.getTaskId());

									projectLogNode.put("activityType", "");

									// 補上項目層級的當前任務taskUid[項目層級]，如果atmc有操作紀錄就用atmc的
									projectLogNode.put("taskUid", tTaskLog.getTaskUid());

								}

							}
						}

					}

//					rowDataAryNode = jsonManipulateService.sortJsonArrayByAttribute(rowDataAryNode,
//							LogAttributeEnum.CREATED_TIME.getAttribute(), true);

					pSourceIdInfoArynode = jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode,
							LogAttributeEnum.CREATED_TIME.getAttribute(), true);
//					projectLogNode.put("rowData", rowDataAryNode);
				}

			}

		}
		return pSourceIdInfoArynode;
	}

	private List<Map<String, Object>> sourceNoSearch(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate,
													 String pQueryEndDate, String pCondition, String pSourceId, String pRuleCode, String pCreatedTime,
													 String pProcessSerialNumber) throws ParseException {

		List<Map<String, Object>> finalSourceIdInfoArayNode = new ArrayList<>();

		if (!StringUtil.isEmptyOrSpace(pProcessSerialNumber) && !StringUtil.isEmptyOrSpace(pCreatedTime)) {

			Date tCreateDate = formatToDate.parse(pCreatedTime);
			pSourceIdInfoArynode = generateStuckResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tCreateDate),
					formatToDate.format(Calendar.getInstance().getTime()), pCondition);
			pSourceIdInfoArynode = generateSuccessResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tCreateDate),
					formatToDate.format(Calendar.getInstance().getTime()), pCondition);

			for (Map<String, Object> node : pSourceIdInfoArynode) {
				if (node.get("processSerialNumber") != null
						&& pProcessSerialNumber.equals(node.get("processSerialNumber"))) {
					finalSourceIdInfoArayNode.add(node);
				}
			}

		} else {

			Date tStartDate = formatToDate.parse(pQueryStartDate);
			Date tEndDate = formatToDate.parse(pQueryEndDate);
			if (pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {
				pSourceIdInfoArynode = generateStuckResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tStartDate),
						formatToDate.format(tEndDate), pCondition);
			} else if (pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
				pSourceIdInfoArynode = generateSuccessResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tStartDate),
						formatToDate.format(tEndDate), pCondition);
			} else if (pCondition.equals(ExecutionViewSearchEnum.TOTAL.getType())) {
				pSourceIdInfoArynode = generateStuckResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tStartDate),
						formatToDate.format(tEndDate), pCondition);
				pSourceIdInfoArynode = generateSuccessResult(pSourceIdInfoArynode, pTenantId, formatToDate.format(tStartDate),
						formatToDate.format(tEndDate), pCondition);
			}
		}

		for (Map<String, Object> node : pSourceIdInfoArynode) {

			// 如果有來源單號又有偵測ruleCode，則兩者做and
			if (!StringUtil.isEmptyOrSpace(pSourceId) && !StringUtil.isEmptyOrSpace(pRuleCode)) {
				if (node.get("source_no") != null && String.valueOf(node.get("source_no")).indexOf(pSourceId) != -1
						&& node.get("ruleCode") != null && pRuleCode.contains(String.valueOf(node.get("ruleCode")))) {
					finalSourceIdInfoArayNode.add(node);
				}
//				} else {
//					ArrayNode rowData = mapper.createArrayNode();
//					rowData = (ArrayNode) node.get("rowData");
//					for (JsonNode dataNode : rowData) {
//						if (dataNode.get("source_no") != null && pSourceId.equals(dataNode.get("source_no").asText())
//								&& dataNode.get("ruleCode") != null
//								&& pRuleCode.contains(dataNode.get("ruleCode").asText())) {
//							finalSourceIdInfoArayNode.add(node);
//							break;
//						}
//
//					}
//				}
				// 只有來源單號
			} else if (!StringUtil.isEmptyOrSpace(pSourceId)) {
				if (node.get("source_no") != null && String.valueOf(node.get("source_no")).indexOf(pSourceId) != -1) {
					finalSourceIdInfoArayNode.add(node);
				}
//				} else {
//					ArrayNode rowData = mapper.createArrayNode();
//					rowData = (ArrayNode) node.get("rowData");
//					for (JsonNode dataNode : rowData) {
//						if (dataNode.get("source_no") != null && pSourceId.equals(dataNode.get("source_no").asText())) {
//							finalSourceIdInfoArayNode.add(node);
//							break;
//						}
//
//					}
//				}
				// 只有偵測ruleCode
			} else if (!StringUtil.isEmptyOrSpace(pRuleCode)) {
				if (node.get("ruleCode") != null && pRuleCode.contains(String.valueOf(node.get("ruleCode")))) {
					finalSourceIdInfoArayNode.add(node);
				}
//				} else {
//					ArrayNode rowData = mapper.createArrayNode();
//					rowData = (ArrayNode) node.get("rowData");
//					for (JsonNode dataNode : rowData) {
//						if (dataNode.get("ruleCode") != null && pRuleCode.contains(dataNode.get("ruleCode").asText())) {
//							finalSourceIdInfoArayNode.add(node);
//							break;
//						}
//
//					}
//				}
			}

		}

		return jsonManipulateService.sortJsonArrayByAttribute(finalSourceIdInfoArayNode,
				LogAttributeEnum.CREATED_TIME.getAttribute(), true);

	}
}