package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 获取错误明细
 */
@Service
public class GetExceptionDetailProcessor {

	@Autowired
	private ErrorMessageDao errorMessageDao;


	protected final Log log = LogFactory.getLog(getClass());

	/**
	 * 根据ID挥着执行序号获取错误明细
	 * @param errorLogId
	 * @param processSerialNumber
	 * @return
	 */
	public Map<String, Object> execute(Long errorLogId, String processSerialNumber) {
		Map<String, Object> tReturn = new HashMap<>();
		if (null != errorLogId || !StringUtil.isEmptyOrSpace(processSerialNumber)) {
			tReturn.put("result", errorMessageDao.getExceptionDetail(errorLogId, processSerialNumber));
		}
		return tReturn;
	}

}
