package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.constant.ItsysConstant;
import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.enums.ErrorSummaryEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.enums.LogAttributeEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.internal.LinkedTreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.net.URI;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class MonitorLogConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private MonitorLogDao monitorLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	private String GET_APPCODE_BY_MONITOR_RULECODE_PATH = "/restful/service/knowledgegraph/app/appCodeByMonitorRuleCode";
	private String GET_SOURCEIDKEY_BY_MONITOR_RULECODE_PATH = "/restful/service/knowledgegraph/action/sourceIdKey";
	private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
	private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";

	public MonitorLogConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.MONITOR_LOG_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws Exception {

		ObjectMapper mapper = new ObjectMapper();
		JsonNode tMessageNode = mapper.readTree(pMessage);

		saveData(tMessageNode);

	}

	protected MonitorLog saveData(JsonNode pMessageNode) throws Exception {

		MonitorLog monitorLog = new MonitorLog();

		if (pMessageNode.get("traceId") != null) {
			monitorLog.setTraceId(pMessageNode.get("traceId").asText());
		}

		monitorLog.setRuleCode(pMessageNode.get("ruleCode").asText());

		if (pMessageNode.get(LogAttributeEnum.DETECT_TIME.getAttribute()) != null) {
			monitorLog.setDetectTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
					.parse(pMessageNode.get(LogAttributeEnum.DETECT_TIME.getAttribute()).asText()));

		}

		if (pMessageNode.get("createdTime") != null) {
			monitorLog.setCreatedTime(
					new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));

		}

		monitorLog.setTenantId(pMessageNode.get("tenantId").asText());
		if (pMessageNode.get("processEntities") != null
				&& ((ArrayNode) pMessageNode.get("processEntities")).size() != 0) {
			monitorLog.setDetectData(pMessageNode.get("processEntities").toString());
		}
		monitorLog.setBuildTime(Calendar.getInstance());
		if (pMessageNode.get("state") != null) {
			monitorLog.setState(pMessageNode.get("state").asBoolean());
		}
		try {

			Map<String, String> tAppNameMap = getAppName(pMessageNode.get("ruleCode").asText(),
					pMessageNode.get("tenantId").asText());

			monitorLog.setAppNameZhCn(tAppNameMap.get(LocaleEnum.ZH_CN.getType()));
			monitorLog.setAppNameZhTw(tAppNameMap.get(LocaleEnum.ZH_TW.getType()));
			monitorLog.setAppNameEnUs(tAppNameMap.get(LocaleEnum.EN_US.getType()));

			monitorLog.setAppCode(tAppNameMap.get(ErrorSummaryEnum.APP_CODE.getCode()));

		} catch (DWHttpFailedException e) {
			String exceptionEntity = e.getEntity(String.class);
			log.error("exceptionEntity = " + exceptionEntity, e);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			log.error("取得應用名稱(appName)失敗, ruleCode = " + pMessageNode.get("ruleCode").asText() + "，原始訊息："
					+ pMessageNode.toString());
		}

		try {
			if (pMessageNode.get("processEntities") != null
					&& ((ArrayNode) pMessageNode.get("processEntities")).size() != 0) {
				monitorLog.setSourceIdKey(
						getSourceIdKey(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText()));
				monitorLog.setSourceId(getSourceIds(pMessageNode));
			}
		} catch (DWHttpFailedException e) {
			String exceptionEntity = e.getEntity(String.class);
			log.error("exceptionEntity = " + exceptionEntity, e);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			log.error("取得源單據(sourceId)失敗, ruleCode = " + pMessageNode.get("ruleCode").asText() + "，sourceIdKey = "
					+ getSourceIdKey(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText())
					+ "，原始訊息：" + pMessageNode.toString());
		}

		if (pMessageNode.get("exception") != null) {
			monitorLog.setException(pMessageNode.get("exception").asText());
		}

		if (pMessageNode.get("exceptionType") != null) {
			monitorLog.setExceptionType(pMessageNode.get("exceptionType").asText());
		}

		if (pMessageNode.get("initial") != null) {
			monitorLog.setInitial(pMessageNode.get("initial").asBoolean());
		}

		if (pMessageNode.get("eocId") != null) {

			ObjectNode eocIdNode = (ObjectNode) pMessageNode.get("eocId");

			if (eocIdNode.get("eocCompanyId") != null) {
				monitorLog.setEocCompanyId(eocIdNode.get("eocCompanyId").asText());
			}
			if (eocIdNode.get("eocSiteId") != null) {
				monitorLog.setEocSiteId(eocIdNode.get("eocSiteId").asText());
			}
			if (eocIdNode.get("eocRegionId") != null) {
				monitorLog.setEocRegionId(eocIdNode.get("eocRegionId").asText());
			}
		}

		return monitorLogDao.save(monitorLog);

	}

	protected Map<String, Object> updateErrorState(String pMessage) {

		return null;

	}

	// 調TM取得appName(應用名稱)
	protected Map<String, String> getAppName(String pRuleCode, String pTenant) throws Exception {

		Map<String, String> returnMap = new HashMap<String, String>();

		String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgemaps.url");
		URI tKnowledgemapsTargetUri = DWURIBuilder
				.create(tKnowledgemapsUrl + GET_APPCODE_BY_MONITOR_RULECODE_PATH + "?code=" + pRuleCode).build();

		HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);

		tHttpGet.setHeader("token", getToken(pTenant));

		Map<String, Object> tResponseAsMap = dwHttpClient.execute(tHttpGet, Map.class);

		ArrayList<Object> tResponseAry = (ArrayList<Object>) tResponseAsMap.get("response");

		Object obj = null;
		if(tResponseAry!=null && tResponseAry.size()>0){
			obj = tResponseAry.get(0);
		}
		if(null==obj){
			return returnMap;
		}

		String firstObjectInResponseAry = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((obj));

		JsonNode firstObjectNode = mapper.readTree(firstObjectInResponseAry);

		String appCode = firstObjectNode.get(ErrorSummaryEnum.APP_CODE.getCode()).asText();

		returnMap.put(ErrorSummaryEnum.APP_CODE.getCode(), appCode);

		JsonNode langObjectNode = firstObjectNode.get(ErrorSummaryEnum.LANG.getCode());
		if (null == langObjectNode) {
			return returnMap;
		}
		JsonNode appNameObjectNode = langObjectNode.get(ErrorSummaryEnum.APP_NAME.getCode());
		if (null == appNameObjectNode) {
			return returnMap;
		}
		if (appNameObjectNode.get(LocaleEnum.ZH_CN.getType()) != null) {
			returnMap.put(LocaleEnum.ZH_CN.getType(), appNameObjectNode.get(LocaleEnum.ZH_CN.getType()).asText());
		}
		if (appNameObjectNode.get(LocaleEnum.ZH_TW.getType()) != null) {
			returnMap.put(LocaleEnum.ZH_TW.getType(), appNameObjectNode.get(LocaleEnum.ZH_TW.getType()).asText());
		}
		if (appNameObjectNode.get(LocaleEnum.EN_US.getType()) != null) {
			returnMap.put(LocaleEnum.EN_US.getType(), appNameObjectNode.get(LocaleEnum.EN_US.getType()).asText());
		}
		return returnMap;
	}

	// 取得sourceId
	protected String getSourceIds(JsonNode pMessageNode) throws Exception {

		List<String> tProcessEntitiesAry = new ArrayList<String>();

		String tSourceIdKey = getSourceIdKey(pMessageNode.get("ruleCode").asText(),
				pMessageNode.get("tenantId").asText());

		ArrayNode tProcessEntitiesAryNode = mapper.createArrayNode();
		tProcessEntitiesAryNode = (ArrayNode) pMessageNode.get("processEntities");

		for (JsonNode processEntity : tProcessEntitiesAryNode) {
			tProcessEntitiesAry.add(processEntity.findValue(tSourceIdKey).asText());
		}

		return tProcessEntitiesAry.toString();

	}

	// 取得sourceIdKey
	protected String getSourceIdKey(String pRuleCode, String pTenant) throws Exception {

		String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgemaps.url");

		URI tKnowledgemapsTargetUri = DWURIBuilder
				.create(tKnowledgemapsUrl + GET_SOURCEIDKEY_BY_MONITOR_RULECODE_PATH + "?ruleCode=" + pRuleCode)
				.build();

		HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);

		tHttpGet.setHeader("token", getToken(pTenant));

		Map<String, String> tGetAppCodeInfoResponse = dwHttpClient.execute(tHttpGet, Map.class);

		String tAppNameJsonPath = tGetAppCodeInfoResponse.get("response");

		return tAppNameJsonPath;

	}

	private String getToken(String pTenant) throws Exception {

		String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgemaps.url");

		URI tKnowledgemapsTargetUri = DWURIBuilder
				.create(tKnowledgemapsUrl + GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant).build();

		HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);

		Map<String, String> tGetLicenseKeyResponse = dwHttpClient.execute(tHttpGet, Map.class);

		String tSecretKey = "";

		tSecretKey = decodeAES(tGetLicenseKeyResponse.get("response"));

		String tIamUrl = DWApplicationConfigUtils.getProperty("iam.url");
		URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_IDENTITY_LOGIN_PATH).build();
		HttpPost tPost = new HttpPost(tIamTargetUri);
		tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
		Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
		tGetIamRequest.put("secretKey", tSecretKey);
		tGetIamRequest.put("identityType", "secretKey");
		tPost.setEntity(new DWJsonEntity(tGetIamRequest));
		Map<String, String> tGetIamResponse = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));

		log.info("偵測消息取得用戶token, 租戶[" + pTenant + "], token = " + tGetIamResponse.get("token"));

		return tGetIamResponse.get("token");

	}

	private static String decodeAES(String secretFile) throws Exception {
		byte[] result = new byte[0];
		String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
		try {
			Key key1 = new SecretKeySpec(Hex.decodeHex(secretKey), "AES");
			Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
			cipher.init(2, key1);
			result = cipher.doFinal(Hex.decodeHex(secretFile));
		} catch (Exception e) {
			throw e;
		}

		return new String(result);
	}
}
