package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.constant.ItsysConstant;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.*;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.internal.LinkedTreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class ProjectLogPtmConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private ProjectLogDao projectLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	private String GET_APP_NAME_PATH = "/restful/service/knowledgegraph/app/AppCodeByTypeAndCode?type=task&";
	private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
	private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";

	public ProjectLogPtmConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.PROJECT_LOG_PTM_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws Exception {

		JsonNode tMessageNode = mapper.readTree(pMessage);

		Map<String, String> tProjectLogCondition = new HashMap<String, String>();

		// taskengine更新taskengine的消息
		// ptm更新ptm的消息
		// 用appId判斷

		// TODO projectId是什麼?子項目ID是什麼?key是什麼組成

		tProjectLogCondition.put(ProjectLogConditionEnum.APP_ID.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());

		tProjectLogCondition.put(ProjectLogConditionEnum.TENANT_ID.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());

		tProjectLogCondition.put(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());

		List<ProjectLog> tProjectLogs = projectLogDao.fetch(tProjectLogCondition);

		if (!tProjectLogs.isEmpty()) {
			// 有對應紀錄則做更新
			updateProjectLog(tProjectLogs.get(0), tMessageNode);
		} else {
			// 無對應紀錄則做新增
			saveProjectLog(tMessageNode);
		}
	}

	protected ProjectLog saveProjectLog(JsonNode pMessageNode)
			throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {

		ProjectLog tProjectLog = new ProjectLog();

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()) != null) {
			tProjectLog.setTraceId(pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()) != null) {
			tProjectLog.setAppId(pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()) != null) {
			tProjectLog.setSourceIds(pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()).asText());
		}

		// TODO projectId是什麼?子項目ID是什麼?
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()) != null) {
			tProjectLog.setProjectId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectCardId.toString()) != null) {
			tProjectLog
					.setProjectCardId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectCardId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
			tProjectLog.setProcessSerialNumber(
					pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
		}
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()) != null) {
				tProjectLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()) != null) {
			tProjectLog.setTenantId(pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
			tProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
			tProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
		}
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.personInCharge.toString()) != null) {
				tProjectLog.setPersonInCharge(
						pMessageNode.get(ProjectLogJsonAttributeEnum.personInCharge.toString()).asText());
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.personInChargeName.toString()) != null) {
				tProjectLog.setPersonInChargeName(
						pMessageNode.get(ProjectLogJsonAttributeEnum.personInChargeName.toString()).asText());
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		// 要做多語系
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()) != null) {

				// tProjectLog.setProjectName(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());

				JsonNode jsonNode = mapper
						.readTree(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());

				tProjectLog.setProjectNameZhTw(jsonNode.get("zh_TW").asText());
				tProjectLog.setProjectNameZhCn(jsonNode.get("zh_CN").asText());
				tProjectLog.setProjectNameEnUs(jsonNode.get("en_US").asText());
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectStartTime.toString()) != null) {
				tProjectLog.setProjectStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.projectStartTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectEndTime.toString()) != null) {
				tProjectLog.setProjectEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.projectEndTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectCode.toString()) != null) {
			tProjectLog.setProjectCode(pMessageNode.get(ProjectLogJsonAttributeEnum.projectCode.toString()).asText());

			try {

				Map<String, String> tAppNameMap = getAppName(pMessageNode.get("projectCode").asText(),
						pMessageNode.get("tenantId").asText());

				tProjectLog.setAppNameZhCn(tAppNameMap.get(LocaleEnum.ZH_CN.getType()));
				tProjectLog.setAppNameZhTw(tAppNameMap.get(LocaleEnum.ZH_TW.getType()));
				tProjectLog.setAppNameEnUs(tAppNameMap.get(LocaleEnum.EN_US.getType()));

				tProjectLog.setAppCode(tAppNameMap.get(ErrorSummaryEnum.APP_CODE.getCode()));

			} catch (DWHttpFailedException e) {
				String exceptionEntity = e.getEntity(String.class);
				log.error("exceptionEntity = " + exceptionEntity, e);
			} catch (Exception e) {
				log.error(e.getMessage(), e);
				log.error("ptm項目消息取得應用名稱(appName)失敗, projectCode = " + pMessageNode.get("projectCode").asText()
						+ "，原始訊息：" + pMessageNode.toString());
			}

		}

		tProjectLog.setBuildTime(Calendar.getInstance());

		return projectLogDao.save(tProjectLog);

	}

	protected void updateProjectLog(ProjectLog pProjectLog, JsonNode pMessageNode) throws ParseException {

		// 狀態更新
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
			pProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
		}

		// 子狀態更新
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
			pProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
		}

		// 項目結束時間更新
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()) != null) {
				pProjectLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

		// 紀錄最後更新時間
		pProjectLog.setLastUpdateTime(Calendar.getInstance());

		projectLogDao.saveOrupdate(pProjectLog);
	}

	// 調TM取得appName(應用名稱)
	// https://knowledgemaps-test.apps.digiwincloud.com.cn/restful/service/knowledgegraph/app/AppCodeByTypeAndCode?type=task&code=task_RE_Preparation
	protected Map<String, String> getAppName(String pProjectCode, String pTenant) throws Exception {

		Map<String, String> returnMap = new HashMap<String, String>();

		String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgemaps.url");
		URI tKnowledgemapsTargetUri = DWURIBuilder
				.create(tKnowledgemapsUrl + GET_APP_NAME_PATH + "code=" + pProjectCode).build();

		HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);

		tHttpGet.setHeader("token", getToken(pTenant));

		Map<String, Object> tResponseAsMap = dwHttpClient.execute(tHttpGet, Map.class);

		ArrayList<Object> tResponseAry = (ArrayList<Object>) tResponseAsMap.get("response");

		String firstObjectInResponseAry = mapper.writerWithDefaultPrettyPrinter()
				.writeValueAsString(((LinkedTreeMap<String, Object>) tResponseAry.get(0)));

		JsonNode firstObjectNode = mapper.readTree(firstObjectInResponseAry);

		String appCode = firstObjectNode.get(ErrorSummaryEnum.APP_CODE.getCode()).asText();
		returnMap.put(ErrorSummaryEnum.APP_CODE.getCode(), appCode);

		JsonNode langObjectNode = firstObjectNode.get(ErrorSummaryEnum.LANG.getCode());
		if (null == langObjectNode) {
			return returnMap;
		}
		JsonNode appNameObjectNode = langObjectNode.get(ErrorSummaryEnum.APP_NAME.getCode());
		if (null == appNameObjectNode) {
			return returnMap;
		}
		if (appNameObjectNode.get(LocaleEnum.ZH_CN.getType()) != null) {
			returnMap.put(LocaleEnum.ZH_CN.getType(), appNameObjectNode.get(LocaleEnum.ZH_CN.getType()).asText());
		}
		if (appNameObjectNode.get(LocaleEnum.ZH_TW.getType()) != null) {
			returnMap.put(LocaleEnum.ZH_TW.getType(), appNameObjectNode.get(LocaleEnum.ZH_TW.getType()).asText());
		}
		if (appNameObjectNode.get(LocaleEnum.EN_US.getType()) != null) {
			returnMap.put(LocaleEnum.EN_US.getType(), appNameObjectNode.get(LocaleEnum.EN_US.getType()).asText());
		}

		return returnMap;

	}

	private String getToken(String pTenant) throws Exception {

		String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgemaps.url");

		URI tKnowledgemapsTargetUri = DWURIBuilder
				.create(tKnowledgemapsUrl + GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant).build();

		HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);

		Map<String, String> tGetLicenseKeyResponse = dwHttpClient.execute(tHttpGet, Map.class);

		String tSecretKey = "";

		tSecretKey = decodeAES(tGetLicenseKeyResponse.get("response"));

		String tIamUrl = DWApplicationConfigUtils.getProperty("iam.url");
		URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_IDENTITY_LOGIN_PATH).build();
		HttpPost tPost = new HttpPost(tIamTargetUri);
		tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
		Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
		tGetIamRequest.put("secretKey", tSecretKey);
		tGetIamRequest.put("identityType", "secretKey");
		tPost.setEntity(new DWJsonEntity(tGetIamRequest));
		Map<String, String> tGetIamResponse = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));

		log.info("ptm項目消息取得用戶token, 租戶[" + pTenant + "], token = " + tGetIamResponse.get("token"));

		return tGetIamResponse.get("token");

	}

	private static String decodeAES(String secretFile) throws Exception {
		byte[] result = new byte[0];
		String sKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
		try {
			Key key1 = new SecretKeySpec(Hex.decodeHex(sKey), "AES");
			Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
			cipher.init(2, key1);
			result = cipher.doFinal(Hex.decodeHex(secretFile));
		} catch (Exception e) {
			throw e;
		}

		return new String(result);
	}
}
