package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.enums.ProjectLogConditionEnum;
import com.digiwin.athena.itsys.enums.ProjectLogJsonAttributeEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProjectLogTaskengineConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private ProjectLogDao projectLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	public ProjectLogTaskengineConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.PROJECT_LOG_TASKENGINE_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws Exception {

		JsonNode tMessageNode = mapper.readTree(pMessage);

		Map<String, String> tProjectLogCondition = new HashMap<String, String>();

		// taskengine更新taskengine的消息
		// ptm更新ptm的消息
		// 用appId判斷
		tProjectLogCondition.put(ProjectLogConditionEnum.APP_ID.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());

		tProjectLogCondition.put(ProjectLogConditionEnum.TENANT_ID.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());

		tProjectLogCondition.put(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
				tMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());

		List<ProjectLog> tProjectLogs = projectLogDao.fetch(tProjectLogCondition);

		if (!tProjectLogs.isEmpty()) {
			// 有對應紀錄則做更新
			updateProjectLog(tProjectLogs.get(0), tMessageNode);
		} else {
			// 無對應紀錄則做新增
			saveProjectLog(tMessageNode);
		}
	}

	protected ProjectLog saveProjectLog(JsonNode pMessageNode)
			throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {

		ProjectLog tProjectLog = new ProjectLog();

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()) != null) {
			tProjectLog.setTraceId(pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()) != null) {
			tProjectLog.setSourceIds(pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()) != null) {
			tProjectLog.setAppId(pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
			tProjectLog.setProcessSerialNumber(
					pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
		}
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()) != null) {
				tProjectLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		// 要做多語系
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()) != null) {

				// tProjectLog.setProjectName(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());

				JsonNode jsonNode = mapper
						.readTree(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());

				tProjectLog.setProjectNameZhTw(jsonNode.get("zh_TW").asText());
				tProjectLog.setProjectNameZhCn(jsonNode.get("zh_CN").asText());
				tProjectLog.setProjectNameEnUs(jsonNode.get("en_US").asText());
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

		// TODO projectId是什麼?子項目ID是什麼?
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()) != null) {
			tProjectLog.setProjectId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()) != null) {
			tProjectLog.setTenantId(pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
			tProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
		}

		if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
			tProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
		}

		tProjectLog.setBuildTime(Calendar.getInstance());

		return projectLogDao.save(tProjectLog);

	}

	protected void updateProjectLog(ProjectLog pProjectLog, JsonNode pMessageNode) throws ParseException {

		// 狀態更新
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
			pProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
		}

		// 子狀態更新
		if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
			pProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
		}

		// 項目結束時間更新
		try {
			if (pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()) != null) {
				pProjectLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		// 紀錄最後更新時間
		pProjectLog.setLastUpdateTime(Calendar.getInstance());

		projectLogDao.saveOrupdate(pProjectLog);
	}
}
