package com.digiwin.athena.itsys.api.service.request;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/4/17 16:16
 */
public class ErrorProjectRequest {

    /**异常产生时间的开始值*/
    @NotNull(message = "startDate empty error")
    private Date startDate;

    /**异常产生时间的截止条件，startDate和endDate区间不超过1个月，不超过31天*/
    @NotNull(message = "startDate empty error")
    private Date endDate;

    /**查询发生异常的项目定义code*/
    @NotEmpty(message = "projectCode empty error")
    private String projectCode;

    /**侦测的code*/
    @NotEmpty(message = "ruleCode empty error")
    private String ruleCode;

    /**侦测的数据KEY名称，配合detectData可以达到精确匹配*/
    private String detectDataName;

    /**侦测的数据，只支持一个条件。*/
    @NotEmpty(message = "detectData empty error")
    private List<String> detectData;

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public List<String> getDetectData() {
        return detectData;
    }

    public void setDetectData(List<String> detectData) {
        this.detectData = detectData;
    }

    public String getDetectDataName() {
        return detectDataName;
    }

    public void setDetectDataName(String detectDataName) {
        this.detectDataName = detectDataName;
    }
}
