package com.digiwin.athena.itsys.config;

import com.alibaba.druid.pool.DruidDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Configuration
public class ItsysHibernateConfig {


    @Value("${hibernate.cache.use_second_level_cache:false}")
    private String use_second_level_cache;

    @Value("${hibernate.cache.use_query_cache:false}")
    private String use_query_cache;


    @Bean("itysDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.itsys")
    public DruidDataSource itsysDataSource() {
        DruidDataSource druidDataSource= new DruidDataSource();
        return druidDataSource;
    }

    @Bean("itsysLocalSessionFactoryBean")
    public LocalSessionFactoryBean itsysLocalSessionFactoryBean(@Qualifier("itysDataSource") DataSource dataSource){
        LocalSessionFactoryBean factoryBean = new LocalSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        factoryBean.setHibernateProperties(hibernateProperties());
        factoryBean.setPackagesToScan("com.digiwin.athena.itsys.model");


        return factoryBean;
    }

    @Bean("itsysTransactionManager")
    public HibernateTransactionManager itsysHibernateTransactionManager(@Qualifier("itsysLocalSessionFactoryBean") SessionFactory localSessionFactoryBean){
        HibernateTransactionManager hibernateTransactionManager = new HibernateTransactionManager(localSessionFactoryBean);

        return hibernateTransactionManager;
    }



    private Properties hibernateProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.hbm2ddl.auto", "update");
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQL8Dialect");
        properties.put("hibernate.show_sql", "true");
        properties.put("hibernate.format_sql","true");
        properties.put("hibernate.query.substitutions","true 'Y', false 'N'");
        properties.put("hibernate.cache.use_second_level_cache",use_second_level_cache);
        properties.put("hibernate.cache.use_query_cache",use_query_cache);
        properties.put("hibernate.cache.region.factory_class","org.hibernate.cache.ehcache.EhCacheRegionFactory");

        return properties;
    }


}
