package com.digiwin.athena.itsys.dao;

import com.digiwin.athena.itsys.model.ProjectLog;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ProjectLogDao extends GenericDao<ProjectLog, Long> {
	List<ProjectLog> fetch (Map<String, String> pConditions);

	List<ProjectLog> getProjectLogsByTraceId (String pTraceId);

	List<ProjectLog> getProjectLogsBySerialNumbers (List<String> pSerialNumbers, String pTenantId);

	List<ProjectLog> getErrorProject(String tenantId, Pair<Date, Date> dateRange, String projectCode);

	Long getSuccessProjectCnt (String pTenantId);
}
