package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.model.ErrorSummary;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional("itsysTransactionManager")
public class ErrorSummaryDaoImpl extends GenericDaoImpl<ErrorSummary, Long> implements ErrorSummaryDao {

	public ErrorSummaryDaoImpl () {
		super(ErrorSummary.class);
	}

	@Override
	public List<ErrorSummary> getErrorSummaryByCode(String pCode) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ErrorSummary>>() {
			@Override
			public List<ErrorSummary> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();

				tHqlSB.append("from ErrorSummary where code=:code");

				Query<ErrorSummary> tQuery = pSession.createQuery(tHqlSB.toString(), ErrorSummary.class);

				tQuery.setParameter("code", pCode);

				return tQuery.getResultList();
			}
		});

	}

}
