package com.digiwin.athena.itsys.dao.impl;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.athena.itsys.dao.ExecutionLogDao;
import com.digiwin.athena.itsys.model.ExecutionLog;

@Service
@Transactional("itsysTransactionManager")
public class ExecutionLogDaoImpl extends GenericDaoImpl<ExecutionLog, Long> implements ExecutionLogDao {

	public ExecutionLogDaoImpl() {
		super(ExecutionLog.class);
	}

	@Override
	public void deleteExecutionLogsByTenantId(String pTenantId) {

		getHibernateTemplate().execute(new HibernateCallback() {
			@Override
			public Object doInHibernate(Session pSession) throws HibernateException {
				Query tQuery = pSession.createQuery("delete ExecutionLog where tenantId =:tenantId");
				tQuery.setParameter("tenantId", pTenantId);

				return tQuery.executeUpdate();
			}
		});

	}
}
