package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * 活動Activity
 * 
 */
@Entity
@Table(name = "activity_log")
public class ActivityLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "process_serial_number")
	@JsonProperty("process_serial_number")
	private String processSerialNumber;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "source_no")
	@JsonProperty("source_no")
	private String sourceNo;

	@Column(name = "performer_id")
	@JsonProperty("performer_id")
	private String performerId;

	@Column(name = "performer_name")
	@JsonProperty("performer_name")
	private String performerName;

	@Column(name = "activity_code")
	@JsonProperty("activity_code")
	private String activityCode;

	@Column(name = "activity_uid")
	@JsonProperty("activity_uid")
	private String activityUid;

	@Column(name = "activity_type")
	@JsonProperty("activity_type")
	private String activityType;

	@Column(name = "state")
	@JsonProperty("state")
	private int state;

	@Column(name = "sub_state")
	@JsonProperty("sub_state")
	private int subState;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "completed_time")
	private Date completedTime;

	@Column(name = "operate_time")
	private Date operateTime;

	@Column(name = "operate")
	@JsonProperty("operate")
	private String operate;

	// TODO 要做多語系
	@Column(name = "activity_name_zh_tw")
	@JsonProperty("activity_name_zh_tw")
	private String activityNameZhTw;

	@Column(name = "activity_name_zh_cn")
	@JsonProperty("activity_name_zh_cn")
	private String activityNameZhCn;

	@Column(name = "activity_name_en_us")
	@JsonProperty("activity_name_en_us")
	private String activityNameEnUs;

	// 關卡所屬任務的uid
	@Column(name = "task_uid")
	@JsonProperty("task_uid")
	private String taskUid;

	@Column(name = "task_card_id")
	@JsonProperty("task_card_id")
	private String taskCardId;

	@Column(name = "agent_performer_id")
	@JsonProperty("agent_performer_id")
	private String agentPerformerId;

	@Column(name = "agent_performer_name")
	@JsonProperty("agent_performer_name")
	private String agentPerformerName;

	@Column(name = "performer_type")
	@JsonProperty("performer_type")
	private String performerType;

	public ActivityLog() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getProcessSerialNumber() {
		return processSerialNumber;
	}

	public void setProcessSerialNumber(String processSerialNumber) {
		this.processSerialNumber = processSerialNumber;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public Date getCompletedTime() {
		return completedTime;
	}

	public void setCompletedTime(Date completedTime) {
		this.completedTime = completedTime;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public String getPerformerId() {
		return performerId;
	}

	public void setPerformerId(String performerId) {
		this.performerId = performerId;
	}

	public String getActivityCode() {
		return activityCode;
	}

	public void setActivityCode(String activityCode) {
		this.activityCode = activityCode;
	}

	public String getActivityUid() {
		return activityUid;
	}

	public void setActivityUid(String activityUid) {
		this.activityUid = activityUid;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public int getSubState() {
		return subState;
	}

	public void setSubState(int subState) {
		this.subState = subState;
	}

	public Date getOperateTime() {
		return operateTime;
	}

	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public String getTaskUid() {
		return taskUid;
	}

	public void setTaskUid(String taskUid) {
		this.taskUid = taskUid;
	}

	public String getTaskCardId() {
		return taskCardId;
	}

	public void setTaskCardId(String taskCardId) {
		this.taskCardId = taskCardId;
	}

	public String getOperate() {
		return operate;
	}

	public void setOperate(String operate) {
		this.operate = operate;
	}

	public String getSourceNo() {
		return sourceNo;
	}

	public void setSourceNo(String sourceNo) {
		this.sourceNo = sourceNo;
	}

	public String getActivityNameZhTw() {
		return activityNameZhTw;
	}

	public void setActivityNameZhTw(String activityNameZhTw) {
		this.activityNameZhTw = activityNameZhTw;
	}

	public String getActivityNameZhCn() {
		return activityNameZhCn;
	}

	public void setActivityNameZhCn(String activityNameZhCn) {
		this.activityNameZhCn = activityNameZhCn;
	}

	public String getActivityNameEnUs() {
		return activityNameEnUs;
	}

	public void setActivityNameEnUs(String activityNameEnUs) {
		this.activityNameEnUs = activityNameEnUs;
	}

	public String getPerformerName() {
		return performerName;
	}

	public void setPerformerName(String performerName) {
		this.performerName = performerName;
	}

	public String getAgentPerformerId() {
		return agentPerformerId;
	}

	public void setAgentPerformerId(String agentPerformerId) {
		this.agentPerformerId = agentPerformerId;
	}

	public String getAgentPerformerName() {
		return agentPerformerName;
	}

	public void setAgentPerformerName(String agentPerformerName) {
		this.agentPerformerName = agentPerformerName;
	}

	public String getPerformerType() {
		return performerType;
	}

	public void setPerformerType(String performerType) {
		this.performerType = performerType;
	}

}